/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.apim.infra.domain_service.api;

import io.gravitee.apim.core.api.domain_service.ApiStateDomainService;
import io.gravitee.apim.core.api.model.Api;
import io.gravitee.apim.core.audit.model.AuditInfo;
import io.gravitee.apim.infra.adapter.ApiAdapter;
import io.gravitee.rest.api.model.api.ApiDeploymentEntity;
import io.gravitee.rest.api.model.v4.api.GenericApiEntity;
import io.gravitee.rest.api.service.common.ExecutionContext;
import io.gravitee.rest.api.service.v4.ApiStateService;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class ApiStateDomainServiceLegacyWrapper
implements ApiStateDomainService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ApiStateDomainServiceLegacyWrapper.class);
    public static final ApiAdapter apiAdapter = ApiAdapter.INSTANCE;
    private final ApiStateService apiStateService;

    @Override
    public boolean isSynchronized(Api api, AuditInfo auditInfo) {
        ExecutionContext executionContext = new ExecutionContext(auditInfo.organizationId(), auditInfo.environmentId());
        return this.apiStateService.isSynchronized(executionContext, (GenericApiEntity)apiAdapter.toApiEntity(api));
    }

    @Override
    public Api deploy(Api api, String deploymentLabel, AuditInfo auditInfo) {
        ExecutionContext executionContext = new ExecutionContext(auditInfo.organizationId(), auditInfo.environmentId());
        GenericApiEntity deployed = this.apiStateService.deploy(executionContext, apiAdapter.toRepository(api), auditInfo.actor().userId(), new ApiDeploymentEntity(deploymentLabel));
        return apiAdapter.fromApiEntity(deployed);
    }

    @Override
    public Api start(Api api, AuditInfo auditInfo) {
        ExecutionContext executionContext = new ExecutionContext(auditInfo.organizationId(), auditInfo.environmentId());
        String userId = auditInfo.actor().userId();
        GenericApiEntity started = this.apiStateService.start(executionContext, api.getId(), userId);
        return ApiAdapter.INSTANCE.fromApiEntity(started);
    }

    @Override
    public Api stop(Api api, AuditInfo auditInfo) {
        ExecutionContext executionContext = new ExecutionContext(auditInfo.organizationId(), auditInfo.environmentId());
        String userId = auditInfo.actor().userId();
        GenericApiEntity stopped = this.apiStateService.stop(executionContext, api.getId(), userId);
        return ApiAdapter.INSTANCE.fromApiEntity(stopped);
    }

    @Generated
    public ApiStateDomainServiceLegacyWrapper(ApiStateService apiStateService) {
        this.apiStateService = apiStateService;
    }
}

