/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.apim.infra.crud_service.integration;

import io.gravitee.apim.core.integration.crud_service.IntegrationCrudService;
import io.gravitee.apim.core.integration.model.Integration;
import io.gravitee.apim.infra.adapter.IntegrationAdapter;
import io.gravitee.repository.exceptions.TechnicalException;
import io.gravitee.repository.management.api.IntegrationRepository;
import io.gravitee.rest.api.service.exceptions.TechnicalManagementException;
import io.gravitee.rest.api.service.impl.AbstractService;
import java.util.Optional;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Service;

@Service
public class IntegrationCrudServiceImpl
extends AbstractService
implements IntegrationCrudService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(IntegrationCrudServiceImpl.class);
    private final IntegrationRepository integrationRepository;

    public IntegrationCrudServiceImpl(@Lazy IntegrationRepository integrationRepository) {
        this.integrationRepository = integrationRepository;
    }

    @Override
    public Integration create(Integration integration) {
        try {
            io.gravitee.repository.management.model.Integration createdIntegration = (io.gravitee.repository.management.model.Integration)this.integrationRepository.create((Object)IntegrationAdapter.INSTANCE.toRepository(integration));
            return IntegrationAdapter.INSTANCE.toEntity(createdIntegration);
        }
        catch (TechnicalException e) {
            throw new TechnicalManagementException("Error when creating Integration: " + integration.getName(), e);
        }
    }

    @Override
    public Optional<Integration> findById(String id) {
        try {
            return this.integrationRepository.findById((Object)id).map(IntegrationAdapter.INSTANCE::toEntity);
        }
        catch (TechnicalException e) {
            throw new TechnicalManagementException("An error occurs while trying to find the integration: " + id, e);
        }
    }

    @Override
    public Integration update(Integration integration) {
        try {
            io.gravitee.repository.management.model.Integration updatedIntegration = (io.gravitee.repository.management.model.Integration)this.integrationRepository.update((Object)IntegrationAdapter.INSTANCE.toRepository(integration));
            return IntegrationAdapter.INSTANCE.toEntity(updatedIntegration);
        }
        catch (TechnicalException e) {
            throw new TechnicalManagementException("An error occurred when updating integration: " + integration.getId(), e);
        }
    }

    @Override
    public void delete(String id) {
        try {
            this.integrationRepository.delete((Object)id);
        }
        catch (TechnicalException e) {
            throw new TechnicalManagementException("Error when deleting Integration: " + id, e);
        }
    }
}

