/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.apim.infra.adapter;

import io.gravitee.apim.core.member.model.RoleScope;
import io.gravitee.apim.core.membership.model.Role;
import io.gravitee.apim.infra.adapter.RoleAdapter;
import io.gravitee.repository.management.model.RoleReferenceType;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.util.Arrays;

public class RoleAdapterImpl
implements RoleAdapter {
    @Override
    public Role toEntity(io.gravitee.repository.management.model.Role role) {
        if (role == null) {
            return null;
        }
        Role.RoleBuilder role1 = Role.builder();
        role1.id(role.getId());
        role1.name(role.getName());
        role1.referenceId(role.getReferenceId());
        role1.referenceType(this.roleReferenceTypeToReferenceType(role.getReferenceType()));
        role1.scope(this.roleScopeToScope(role.getScope()));
        role1.description(role.getDescription());
        role1.defaultRole(role.isDefaultRole());
        int[] permissions = role.getPermissions();
        if (permissions != null) {
            role1.permissions(Arrays.copyOf(permissions, permissions.length));
        }
        role1.system(role.isSystem());
        if (role.getCreatedAt() != null) {
            role1.createdAt(ZonedDateTime.ofInstant(role.getCreatedAt().toInstant(), ZoneId.systemDefault()));
        }
        if (role.getUpdatedAt() != null) {
            role1.updatedAt(ZonedDateTime.ofInstant(role.getUpdatedAt().toInstant(), ZoneId.systemDefault()));
        }
        return role1.build();
    }

    @Override
    public io.gravitee.rest.api.model.permissions.RoleScope mapScope(RoleScope scope) {
        if (scope == null) {
            return null;
        }
        return switch (scope) {
            case RoleScope.API -> io.gravitee.rest.api.model.permissions.RoleScope.API;
            case RoleScope.APPLICATION -> io.gravitee.rest.api.model.permissions.RoleScope.APPLICATION;
            case RoleScope.GROUP -> io.gravitee.rest.api.model.permissions.RoleScope.GROUP;
            case RoleScope.ENVIRONMENT -> io.gravitee.rest.api.model.permissions.RoleScope.ENVIRONMENT;
            case RoleScope.ORGANIZATION -> io.gravitee.rest.api.model.permissions.RoleScope.ORGANIZATION;
            case RoleScope.PLATFORM -> io.gravitee.rest.api.model.permissions.RoleScope.PLATFORM;
            case RoleScope.INTEGRATION -> io.gravitee.rest.api.model.permissions.RoleScope.INTEGRATION;
            default -> throw new IllegalArgumentException("Unexpected enum constant: " + scope);
        };
    }

    protected Role.ReferenceType roleReferenceTypeToReferenceType(RoleReferenceType roleReferenceType) {
        if (roleReferenceType == null) {
            return null;
        }
        return switch (roleReferenceType) {
            case RoleReferenceType.ENVIRONMENT -> Role.ReferenceType.ENVIRONMENT;
            case RoleReferenceType.ORGANIZATION -> Role.ReferenceType.ORGANIZATION;
            default -> throw new IllegalArgumentException("Unexpected enum constant: " + roleReferenceType);
        };
    }

    protected Role.Scope roleScopeToScope(io.gravitee.repository.management.model.RoleScope roleScope) {
        if (roleScope == null) {
            return null;
        }
        return switch (roleScope) {
            case io.gravitee.repository.management.model.RoleScope.API -> Role.Scope.API;
            case io.gravitee.repository.management.model.RoleScope.APPLICATION -> Role.Scope.APPLICATION;
            case io.gravitee.repository.management.model.RoleScope.GROUP -> Role.Scope.GROUP;
            case io.gravitee.repository.management.model.RoleScope.ENVIRONMENT -> Role.Scope.ENVIRONMENT;
            case io.gravitee.repository.management.model.RoleScope.ORGANIZATION -> Role.Scope.ORGANIZATION;
            case io.gravitee.repository.management.model.RoleScope.PLATFORM -> Role.Scope.PLATFORM;
            case io.gravitee.repository.management.model.RoleScope.INTEGRATION -> Role.Scope.INTEGRATION;
            default -> throw new IllegalArgumentException("Unexpected enum constant: " + roleScope);
        };
    }
}

