/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.apim.core.subscription.domain_service;

import io.gravitee.apim.core.DomainService;
import io.gravitee.apim.core.audit.domain_service.AuditDomainService;
import io.gravitee.apim.core.audit.model.ApiAuditLogEntity;
import io.gravitee.apim.core.audit.model.AuditInfo;
import io.gravitee.apim.core.audit.model.event.SubscriptionAuditEvent;
import io.gravitee.apim.core.subscription.crud_service.SubscriptionCrudService;
import io.gravitee.apim.core.subscription.model.SubscriptionEntity;
import io.gravitee.common.utils.TimeProvider;
import java.util.Collections;

@DomainService
public class DeleteSubscriptionDomainService {
    SubscriptionCrudService subscriptionCrudService;
    AuditDomainService auditService;

    public DeleteSubscriptionDomainService(SubscriptionCrudService subscriptionCrudService, AuditDomainService auditService) {
        this.subscriptionCrudService = subscriptionCrudService;
        this.auditService = auditService;
    }

    public void delete(SubscriptionEntity subscriptionEntity, AuditInfo auditInfo) {
        this.subscriptionCrudService.delete(subscriptionEntity.getId());
        this.createAuditLog(subscriptionEntity, auditInfo);
    }

    private void createAuditLog(SubscriptionEntity subscriptionEntity, AuditInfo auditInfo) {
        this.auditService.createApiAuditLog(ApiAuditLogEntity.builder().organizationId(auditInfo.organizationId()).environmentId(auditInfo.environmentId()).apiId(subscriptionEntity.getApiId()).event(SubscriptionAuditEvent.SUBSCRIPTION_DELETED).actor(auditInfo.actor()).oldValue(subscriptionEntity).createdAt(TimeProvider.now()).properties(Collections.emptyMap()).build());
    }
}

