/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.apim.core.specgen.use_case;

import io.gravitee.apim.core.UseCase;
import io.gravitee.apim.core.specgen.crud_service.ApiSpecGenCrudService;
import io.gravitee.apim.core.specgen.model.ApiSpecGen;
import io.gravitee.apim.core.specgen.model.ApiSpecGenOperation;
import io.gravitee.apim.core.specgen.model.ApiSpecGenRequestState;
import io.gravitee.apim.core.specgen.model.ApiSpecGenState;
import io.gravitee.apim.core.specgen.query_service.ApiSpecGenQueryService;
import io.gravitee.apim.core.specgen.service_provider.SpecGenProvider;
import io.gravitee.definition.model.v4.ApiType;
import io.gravitee.rest.api.service.common.GraviteeContext;
import io.reactivex.rxjava3.core.Single;
import io.reactivex.rxjava3.core.SingleSource;
import lombok.Generated;

@UseCase
public class SpecGenRequestUseCase {
    private final ApiSpecGenQueryService apiSpecGenQueryService;
    private final SpecGenProvider specGenProvider;
    private final ApiSpecGenCrudService apiSpecGenCrudService;

    public Single<ApiSpecGenState> getState(String apiId, String userId) {
        return this.performRequest(apiId, ApiSpecGenOperation.GET_STATE, userId);
    }

    public Single<ApiSpecGenState> postJob(String apiId, String userId) {
        return this.performRequest(apiId, ApiSpecGenOperation.POST_JOB, userId);
    }

    private Single<ApiSpecGenState> performRequest(String apiId, ApiSpecGenOperation operation, String userId) {
        return this.apiSpecGenQueryService.rxFindByIdAndType(GraviteeContext.getExecutionContext(), apiId, ApiType.PROXY).flatMapSingle(api -> this.specGenProvider.performRequest(apiId, operation, userId).map(reply -> new ApiSpecGenState(reply.requestState())).doOnSuccess(reply -> this.enableLoggingIfNecessary((ApiSpecGen)api, (ApiSpecGenState)reply, userId))).switchIfEmpty((SingleSource)Single.just((Object)new ApiSpecGenState(ApiSpecGenRequestState.UNAVAILABLE)));
    }

    private void enableLoggingIfNecessary(ApiSpecGen api, ApiSpecGenState reply, String userId) {
        if (ApiSpecGenRequestState.STARTED.equals((Object)reply.state())) {
            this.apiSpecGenCrudService.enableAnalyticsLogging(api, userId);
        }
    }

    @Generated
    public SpecGenRequestUseCase(ApiSpecGenQueryService apiSpecGenQueryService, SpecGenProvider specGenProvider, ApiSpecGenCrudService apiSpecGenCrudService) {
        this.apiSpecGenQueryService = apiSpecGenQueryService;
        this.specGenProvider = specGenProvider;
        this.apiSpecGenCrudService = apiSpecGenCrudService;
    }
}

