/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.apim.core.shared_policy_group.use_case;

import io.gravitee.apim.core.DomainService;
import io.gravitee.apim.core.shared_policy_group.model.SharedPolicyGroup;
import io.gravitee.apim.core.shared_policy_group.query_service.SharedPolicyGroupQueryService;
import io.gravitee.common.data.domain.Page;
import io.gravitee.rest.api.model.common.Pageable;
import io.gravitee.rest.api.model.common.PageableImpl;
import io.gravitee.rest.api.model.common.Sortable;
import io.gravitee.rest.api.model.common.SortableImpl;
import java.util.Set;
import lombok.Generated;

@DomainService
public class SearchSharedPolicyGroupUseCase {
    private final SharedPolicyGroupQueryService sharedPolicyGroupQueryService;
    private static final Set<String> allowedSortableFields = Set.of("name", "-name", "apiType", "-apiType", "phase", "-phase", "updatedAt", "-updatedAt", "deployedAt", "-deployedAt");

    public Output execute(Input input) {
        Pageable pageable = input.pageable != null ? input.pageable : new PageableImpl(1, 10);
        Sortable sortable = SearchSharedPolicyGroupUseCase.toSortable(input.sortBy());
        return new Output(this.sharedPolicyGroupQueryService.searchByEnvironmentId(input.environmentId, input.q, pageable, sortable));
    }

    private static Sortable toSortable(String sortBy) {
        SearchSharedPolicyGroupUseCase.validateSortBy(sortBy);
        if (sortBy == null) {
            return new SortableImpl("updatedAt", false);
        }
        boolean isAscending = !sortBy.startsWith("-");
        String field = isAscending ? sortBy : sortBy.substring(1);
        return new SortableImpl(field, isAscending);
    }

    private static void validateSortBy(String sortBy) {
        if (sortBy != null && !allowedSortableFields.contains(sortBy)) {
            throw new IllegalArgumentException("Invalid sort by field: " + sortBy);
        }
    }

    @Generated
    public SearchSharedPolicyGroupUseCase(SharedPolicyGroupQueryService sharedPolicyGroupQueryService) {
        this.sharedPolicyGroupQueryService = sharedPolicyGroupQueryService;
    }

    public record Input(String environmentId, String q, Pageable pageable, String sortBy) {
        @Generated
        public static InputBuilder builder() {
            return new InputBuilder();
        }

        @Generated
        public static class InputBuilder {
            @Generated
            private String environmentId;
            @Generated
            private String q;
            @Generated
            private Pageable pageable;
            @Generated
            private String sortBy;

            @Generated
            InputBuilder() {
            }

            @Generated
            public InputBuilder environmentId(String environmentId) {
                this.environmentId = environmentId;
                return this;
            }

            @Generated
            public InputBuilder q(String q) {
                this.q = q;
                return this;
            }

            @Generated
            public InputBuilder pageable(Pageable pageable) {
                this.pageable = pageable;
                return this;
            }

            @Generated
            public InputBuilder sortBy(String sortBy) {
                this.sortBy = sortBy;
                return this;
            }

            @Generated
            public Input build() {
                return new Input(this.environmentId, this.q, this.pageable, this.sortBy);
            }

            @Generated
            public String toString() {
                return "SearchSharedPolicyGroupUseCase.Input.InputBuilder(environmentId=" + this.environmentId + ", q=" + this.q + ", pageable=" + this.pageable + ", sortBy=" + this.sortBy + ")";
            }
        }
    }

    public record Output(Page<SharedPolicyGroup> result) {
    }
}

