/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.apim.core.scoring.domain_service;

import io.gravitee.apim.core.DomainService;
import java.math.BigDecimal;
import java.math.RoundingMode;

@DomainService
public class ScoreComputingDomainService {
    public Double computeScore(long nbErrors, long nbWarnings, long nbInfos, long nbHints) {
        double errorsWeight = 1.0;
        double warningsWeight = 0.5;
        double infosWeight = 0.2;
        double hintsWeight = 0.1;
        double aggressivenessParam = 0.1;
        double sum = errorsWeight * (double)nbErrors + warningsWeight * (double)nbWarnings + infosWeight * (double)nbInfos + hintsWeight * (double)nbHints;
        double agg = sum * aggressivenessParam;
        double exp = StrictMath.exp(-agg);
        return BigDecimal.valueOf(1L).multiply(BigDecimal.valueOf(exp)).setScale(2, RoundingMode.HALF_EVEN).doubleValue();
    }
}

