/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.apim.core.plan.domain_service;

import io.gravitee.apim.core.DomainService;
import io.gravitee.apim.core.audit.domain_service.AuditDomainService;
import io.gravitee.apim.core.audit.model.ApiAuditLogEntity;
import io.gravitee.apim.core.audit.model.AuditInfo;
import io.gravitee.apim.core.audit.model.AuditProperties;
import io.gravitee.apim.core.audit.model.event.PlanAuditEvent;
import io.gravitee.apim.core.exception.ValidationDomainException;
import io.gravitee.apim.core.plan.crud_service.PlanCrudService;
import io.gravitee.apim.core.plan.model.Plan;
import io.gravitee.apim.core.subscription.query_service.SubscriptionQueryService;
import io.gravitee.common.utils.TimeProvider;
import java.util.Map;

@DomainService
public class DeletePlanDomainService {
    private final PlanCrudService planCrudService;
    private final SubscriptionQueryService subscriptionQueryService;
    private final AuditDomainService auditService;

    public DeletePlanDomainService(PlanCrudService planCrudService, SubscriptionQueryService subscriptionQueryService, AuditDomainService auditService) {
        this.planCrudService = planCrudService;
        this.subscriptionQueryService = subscriptionQueryService;
        this.auditService = auditService;
    }

    public void delete(Plan plan, AuditInfo auditInfo) {
        if (!this.subscriptionQueryService.findActiveSubscriptionsByPlan(plan.getId()).isEmpty()) {
            throw new ValidationDomainException("Impossible to delete a plan with active subscriptions");
        }
        this.planCrudService.delete(plan.getId());
        this.createAuditLog(plan, auditInfo);
    }

    private void createAuditLog(Plan planToDelete, AuditInfo auditInfo) {
        this.auditService.createApiAuditLog(ApiAuditLogEntity.builder().organizationId(auditInfo.organizationId()).environmentId(auditInfo.environmentId()).apiId(planToDelete.getApiId()).event(PlanAuditEvent.PLAN_DELETED).actor(auditInfo.actor()).oldValue(planToDelete).createdAt(TimeProvider.now()).properties(Map.of(AuditProperties.PLAN, planToDelete.getId())).build());
    }
}

