/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.apim.core.documentation.use_case;

import io.gravitee.apim.core.UseCase;
import io.gravitee.apim.core.api.crud_service.ApiCrudService;
import io.gravitee.apim.core.api.model.Api;
import io.gravitee.apim.core.audit.model.AuditInfo;
import io.gravitee.apim.core.documentation.crud_service.PageCrudService;
import io.gravitee.apim.core.documentation.domain_service.ApiDocumentationDomainService;
import io.gravitee.apim.core.documentation.domain_service.UpdateApiDocumentationDomainService;
import io.gravitee.apim.core.documentation.model.Page;
import io.gravitee.apim.core.exception.ValidationDomainException;
import java.util.Date;
import java.util.Map;

@UseCase
public class ApiUnpublishDocumentationPageUseCase {
    private final ApiDocumentationDomainService apiDocumentationDomainService;
    private final UpdateApiDocumentationDomainService updateApiDocumentationDomainService;
    private final ApiCrudService apiCrudService;
    private final PageCrudService pageCrudService;

    public ApiUnpublishDocumentationPageUseCase(ApiDocumentationDomainService apiDocumentationDomainService, UpdateApiDocumentationDomainService updateApiDocumentationDomainService, ApiCrudService apiCrudService, PageCrudService pageCrudService) {
        this.apiDocumentationDomainService = apiDocumentationDomainService;
        this.updateApiDocumentationDomainService = updateApiDocumentationDomainService;
        this.apiCrudService = apiCrudService;
        this.pageCrudService = pageCrudService;
    }

    public Output execute(Input input) {
        Api api = this.apiCrudService.get(input.apiId);
        Page page = this.pageCrudService.get(input.pageId);
        this.apiDocumentationDomainService.validatePageAssociatedToApi(page, input.apiId);
        if (!page.isPublished()) {
            throw new ValidationDomainException("Page is already unpublished.", Map.of("id", page.getId()));
        }
        Boolean isPageUsedAsGeneralConditions = this.apiDocumentationDomainService.pageIsUsedAsGeneralConditions(page, api);
        if (Boolean.TRUE.equals(isPageUsedAsGeneralConditions)) {
            throw new ValidationDomainException("Page is used as Plan general conditions", Map.of("pageId", page.getId()));
        }
        Page newPage = page.toBuilder().published(false).updatedAt(new Date()).build();
        Page updatedPage = this.updateApiDocumentationDomainService.updatePage(newPage, page, input.auditInfo);
        updatedPage = updatedPage.withHidden(this.apiDocumentationDomainService.pageIsHidden(updatedPage)).withGeneralConditions(isPageUsedAsGeneralConditions);
        return new Output(updatedPage);
    }

    public record Input(String apiId, String pageId, AuditInfo auditInfo) {
    }

    public record Output(Page page) {
    }
}

