/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.apim.core.documentation.domain_service;

import io.gravitee.apim.core.DomainService;
import io.gravitee.apim.core.api.model.Api;
import io.gravitee.apim.core.audit.domain_service.AuditDomainService;
import io.gravitee.apim.core.audit.model.ApiAuditLogEntity;
import io.gravitee.apim.core.audit.model.AuditInfo;
import io.gravitee.apim.core.audit.model.AuditProperties;
import io.gravitee.apim.core.audit.model.event.PageAuditEvent;
import io.gravitee.apim.core.documentation.crud_service.PageCrudService;
import io.gravitee.apim.core.documentation.domain_service.UpdateApiDocumentationDomainService;
import io.gravitee.apim.core.documentation.exception.ApiFolderNotEmptyException;
import io.gravitee.apim.core.documentation.exception.ApiPageInvalidReferenceTypeException;
import io.gravitee.apim.core.documentation.exception.ApiPageUsedAsGeneralConditionException;
import io.gravitee.apim.core.documentation.model.Page;
import io.gravitee.apim.core.documentation.query_service.PageQueryService;
import io.gravitee.apim.core.plan.query_service.PlanQueryService;
import io.gravitee.apim.core.search.Indexer;
import io.gravitee.apim.core.search.model.IndexablePage;
import java.time.Instant;
import java.time.ZoneId;
import java.util.Map;
import java.util.Objects;

@DomainService
public class DeleteApiDocumentationDomainService {
    private final PageCrudService pageCrudService;
    private final PageQueryService pageQueryService;
    private final AuditDomainService auditDomainService;
    private final PlanQueryService planQueryService;
    private final UpdateApiDocumentationDomainService updateApiDocumentationDomainService;
    private final Indexer indexer;

    public DeleteApiDocumentationDomainService(PageCrudService pageCrudService, PageQueryService pageQueryService, AuditDomainService auditDomainService, UpdateApiDocumentationDomainService updateApiDocumentationDomainService, PlanQueryService planQueryService, Indexer indexer) {
        this.pageCrudService = pageCrudService;
        this.pageQueryService = pageQueryService;
        this.auditDomainService = auditDomainService;
        this.updateApiDocumentationDomainService = updateApiDocumentationDomainService;
        this.planQueryService = planQueryService;
        this.indexer = indexer;
    }

    public void delete(Api api, String pageId, AuditInfo auditInfo) {
        Page pageToDelete = this.pageCrudService.get(pageId);
        this.throwIfNotApiPage(pageToDelete);
        this.throwIfPageUsedAsGeneralCondition(api, pageToDelete);
        this.throwIfDeletingNonEmptyFolder(api, pageToDelete);
        this.pageCrudService.delete(pageId);
        this.updatePageOrders(pageToDelete, auditInfo);
        this.indexer.delete(new Indexer.IndexationContext(auditInfo.organizationId(), auditInfo.environmentId()), new IndexablePage(pageToDelete));
        this.auditDomainService.createApiAuditLog(ApiAuditLogEntity.builder().apiId(pageToDelete.getReferenceId()).event(PageAuditEvent.PAGE_DELETED).createdAt(Instant.now().atZone(ZoneId.of("UTC"))).organizationId(auditInfo.organizationId()).environmentId(auditInfo.environmentId()).actor(auditInfo.actor()).properties(Map.of(AuditProperties.PAGE, pageId)).oldValue(pageToDelete).newValue(null).build());
    }

    private void throwIfDeletingNonEmptyFolder(Api api, Page pageToDelete) {
        if (pageToDelete.isFolder()) {
            this.pageQueryService.searchByApiIdAndParentId(api.getId(), pageToDelete.getId()).stream().findAny().ifPresent(childPage -> {
                throw new ApiFolderNotEmptyException(pageToDelete.getId());
            });
        }
    }

    private void throwIfPageUsedAsGeneralCondition(Api api, Page pageToDelete) {
        if (!pageToDelete.isFolder()) {
            this.planQueryService.findAllByApiIdAndGeneralConditionsAndIsActive(api.getId(), api.getDefinitionVersion(), pageToDelete.getId()).stream().findFirst().ifPresent(plan -> {
                throw new ApiPageUsedAsGeneralConditionException(pageToDelete.getId(), plan.getId());
            });
        }
    }

    private void throwIfNotApiPage(Page pageToDelete) {
        if (!pageToDelete.getReferenceType().equals((Object)Page.ReferenceType.API)) {
            throw new ApiPageInvalidReferenceTypeException(pageToDelete.getId(), Page.ReferenceType.API.name());
        }
    }

    private void updatePageOrders(Page deletedPage, AuditInfo auditInfo) {
        this.pageQueryService.searchByApiIdAndParentId(deletedPage.getReferenceId(), deletedPage.getParentId()).stream().filter(page -> DeleteApiDocumentationDomainService.areDifferentPages(deletedPage, page)).filter(page -> DeleteApiDocumentationDomainService.isAfterDeletedPagePosition(deletedPage, page)).forEach(page -> {
            int updatedOrder = page.getOrder() - 1;
            this.updateApiDocumentationDomainService.updatePage(page.toBuilder().order(updatedOrder).build(), (Page)page, auditInfo);
        });
    }

    private static boolean areDifferentPages(Page deletedPage, Page page) {
        return !Objects.equals(page.getId(), deletedPage.getId());
    }

    private static boolean isAfterDeletedPagePosition(Page deletedPage, Page page) {
        return page.getOrder() >= deletedPage.getOrder();
    }
}

