/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.apim.core.api.use_case;

import io.gravitee.apim.core.UseCase;
import io.gravitee.apim.core.api.crud_service.ApiCrudService;
import io.gravitee.apim.core.api.exception.ApiNotFoundException;
import io.gravitee.apim.core.api.model.Api;
import io.gravitee.apim.core.api.model.ApiMetadata;
import io.gravitee.apim.core.api.query_service.ApiMetadataQueryService;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.stream.Stream;

@UseCase
public class GetApiMetadataUseCase {
    private final ApiCrudService apiCrudService;
    private final ApiMetadataQueryService apiMetadataQueryService;

    public GetApiMetadataUseCase(ApiCrudService apiCrudService, ApiMetadataQueryService apiMetadataQueryService) {
        this.apiCrudService = apiCrudService;
        this.apiMetadataQueryService = apiMetadataQueryService;
    }

    public Output execute(Input input) {
        Api api = this.apiCrudService.get(input.apiId);
        if (!api.getEnvironmentId().equals(input.envId)) {
            throw new ApiNotFoundException(input.apiId);
        }
        Map<String, ApiMetadata> apiMetadataMap = this.apiMetadataQueryService.findApiMetadata(api.getEnvironmentId(), input.apiId);
        List<ApiMetadata> sortedApiMetadataList = this.sortApiMetadata(apiMetadataMap.values(), input.sortBy);
        List<ApiMetadata> filteredApiMetadataList = this.filterApiMetadata(sortedApiMetadataList, input.filterBy);
        return new Output(filteredApiMetadataList);
    }

    private List<ApiMetadata> filterApiMetadata(List<ApiMetadata> apiMetadataList, String filterBy) {
        if (filterBy != null) {
            if (filterBy.equals("GLOBAL")) {
                return apiMetadataList.stream().filter(apiMetadata -> apiMetadata.getDefaultValue() != null).toList();
            }
            if (filterBy.equals("API")) {
                return apiMetadataList.stream().filter(apiMetadata -> apiMetadata.getDefaultValue() == null).toList();
            }
        }
        return apiMetadataList;
    }

    private List<ApiMetadata> sortApiMetadata(Collection<ApiMetadata> unsortedList, String sortBy) {
        Stream<ApiMetadata> stream = unsortedList.stream();
        if (sortBy == null) {
            return stream.sorted(Comparator.comparing(ApiMetadata::getKey)).toList();
        }
        return switch (sortBy) {
            case "value" -> stream.sorted(new ApiMetadataValueComparator()).toList();
            case "-value" -> stream.sorted(Collections.reverseOrder(new ApiMetadataValueComparator())).toList();
            case "name" -> stream.sorted(Comparator.comparing(ApiMetadata::getName)).toList();
            case "-name" -> stream.sorted(Collections.reverseOrder(Comparator.comparing(ApiMetadata::getName))).toList();
            case "format" -> stream.sorted(Comparator.comparing(ApiMetadata::getFormatToString)).toList();
            case "-format" -> stream.sorted(Collections.reverseOrder(Comparator.comparing(ApiMetadata::getFormatToString))).toList();
            case "-key" -> stream.sorted(Collections.reverseOrder(Comparator.comparing(ApiMetadata::getKey))).toList();
            default -> stream.sorted(Comparator.comparing(ApiMetadata::getKey)).toList();
        };
    }

    public record Input(String apiId, String envId, String filterBy, String sortBy) {
    }

    public record Output(List<ApiMetadata> metadata) {
    }

    static class ApiMetadataValueComparator
    implements Comparator<ApiMetadata> {
        ApiMetadataValueComparator() {
        }

        @Override
        public int compare(ApiMetadata o1, ApiMetadata o2) {
            String value1 = o1.getValue() != null ? o1.getValue() : o1.getDefaultValue();
            String value2 = o2.getValue() != null ? o2.getValue() : o2.getDefaultValue();
            return value1.compareTo(value2);
        }
    }
}

