/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.apim.core.api.domain_service;

import io.gravitee.apim.core.DomainService;
import io.gravitee.apim.core.api.exception.InvalidApiLifecycleStateException;
import io.gravitee.apim.core.api.model.Api;
import io.gravitee.apim.core.workflow.model.Workflow;
import io.gravitee.apim.core.workflow.query_service.WorkflowQueryService;
import java.util.List;
import lombok.Generated;

@DomainService
public class ApiLifecycleStateDomainService {
    private final WorkflowQueryService workflowQueryService;

    public Api.ApiLifecycleState validateAndSanitizeForUpdate(String apiId, Api.ApiLifecycleState currentState, Api.ApiLifecycleState newState) {
        if (newState == null || Api.ApiLifecycleState.DEPRECATED != currentState && currentState == newState) {
            return currentState;
        }
        switch (currentState) {
            case DEPRECATED: 
            case ARCHIVED: {
                throw new InvalidApiLifecycleStateException(newState.name());
            }
            case PUBLISHED: 
            case UNPUBLISHED: {
                if (Api.ApiLifecycleState.CREATED != newState) break;
                throw new InvalidApiLifecycleStateException(newState.name());
            }
            case CREATED: {
                List<Workflow> status = this.workflowQueryService.findAllByApiIdAndType(apiId, Workflow.Type.REVIEW);
                if (status.isEmpty() || Workflow.State.IN_REVIEW != status.get(0).getState()) break;
                throw new InvalidApiLifecycleStateException(newState.name());
            }
        }
        return newState;
    }

    @Generated
    public ApiLifecycleStateDomainService(WorkflowQueryService workflowQueryService) {
        this.workflowQueryService = workflowQueryService;
    }
}

