/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.apim.infra.adapter;

import io.gravitee.apim.core.plugin.model.FlowPhase;
import io.gravitee.apim.core.shared_policy_group.model.SharedPolicyGroup;
import io.gravitee.apim.infra.adapter.SharedPolicyGroupAdapter;
import io.gravitee.repository.management.model.SharedPolicyGroup;
import io.gravitee.repository.management.model.SharedPolicyGroupLifecycleState;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.util.Date;
import org.springframework.stereotype.Component;

@Component
public class SharedPolicyGroupAdapterImpl
extends SharedPolicyGroupAdapter {
    @Override
    public SharedPolicyGroup toEntity(io.gravitee.repository.management.model.SharedPolicyGroup sharedPolicyGroup) {
        if (sharedPolicyGroup == null) {
            return null;
        }
        SharedPolicyGroup.SharedPolicyGroupBuilder sharedPolicyGroup1 = SharedPolicyGroup.builder();
        sharedPolicyGroup1.id(sharedPolicyGroup.getId());
        sharedPolicyGroup1.environmentId(sharedPolicyGroup.getEnvironmentId());
        sharedPolicyGroup1.organizationId(sharedPolicyGroup.getOrganizationId());
        sharedPolicyGroup1.crossId(sharedPolicyGroup.getCrossId());
        sharedPolicyGroup1.name(sharedPolicyGroup.getName());
        sharedPolicyGroup1.description(sharedPolicyGroup.getDescription());
        sharedPolicyGroup1.prerequisiteMessage(sharedPolicyGroup.getPrerequisiteMessage());
        sharedPolicyGroup1.version(sharedPolicyGroup.getVersion());
        sharedPolicyGroup1.apiType(sharedPolicyGroup.getApiType());
        sharedPolicyGroup1.phase(this.flowPhaseToFlowPhase(sharedPolicyGroup.getPhase()));
        if (sharedPolicyGroup.getDeployedAt() != null) {
            sharedPolicyGroup1.deployedAt(ZonedDateTime.ofInstant(sharedPolicyGroup.getDeployedAt().toInstant(), ZoneId.systemDefault()));
        }
        if (sharedPolicyGroup.getCreatedAt() != null) {
            sharedPolicyGroup1.createdAt(ZonedDateTime.ofInstant(sharedPolicyGroup.getCreatedAt().toInstant(), ZoneId.systemDefault()));
        }
        if (sharedPolicyGroup.getUpdatedAt() != null) {
            sharedPolicyGroup1.updatedAt(ZonedDateTime.ofInstant(sharedPolicyGroup.getUpdatedAt().toInstant(), ZoneId.systemDefault()));
        }
        sharedPolicyGroup1.lifecycleState(this.sharedPolicyGroupLifecycleStateToSharedPolicyGroupLifecycleState(sharedPolicyGroup.getLifecycleState()));
        SharedPolicyGroup sharedPolicyGroup1Result = sharedPolicyGroup1.build();
        this.addPolicyGroupDefinition(sharedPolicyGroup1Result, sharedPolicyGroup);
        return sharedPolicyGroup1Result;
    }

    @Override
    public io.gravitee.repository.management.model.SharedPolicyGroup fromEntity(SharedPolicyGroup sharedPolicyGroupEntity) {
        if (sharedPolicyGroupEntity == null) {
            return null;
        }
        SharedPolicyGroup.SharedPolicyGroupBuilder sharedPolicyGroup = io.gravitee.repository.management.model.SharedPolicyGroup.builder();
        sharedPolicyGroup.definition(this.serializeDefinition(sharedPolicyGroupEntity));
        sharedPolicyGroup.id(sharedPolicyGroupEntity.getId());
        sharedPolicyGroup.environmentId(sharedPolicyGroupEntity.getEnvironmentId());
        sharedPolicyGroup.organizationId(sharedPolicyGroupEntity.getOrganizationId());
        sharedPolicyGroup.crossId(sharedPolicyGroupEntity.getCrossId());
        if (sharedPolicyGroupEntity.hasName()) {
            sharedPolicyGroup.name(sharedPolicyGroupEntity.getName());
        }
        sharedPolicyGroup.description(sharedPolicyGroupEntity.getDescription());
        sharedPolicyGroup.prerequisiteMessage(sharedPolicyGroupEntity.getPrerequisiteMessage());
        sharedPolicyGroup.version(sharedPolicyGroupEntity.getVersion());
        sharedPolicyGroup.apiType(sharedPolicyGroupEntity.getApiType());
        sharedPolicyGroup.phase(this.flowPhaseToFlowPhase1(sharedPolicyGroupEntity.getPhase()));
        if (sharedPolicyGroupEntity.getDeployedAt() != null) {
            sharedPolicyGroup.deployedAt(Date.from(sharedPolicyGroupEntity.getDeployedAt().toInstant()));
        }
        if (sharedPolicyGroupEntity.getCreatedAt() != null) {
            sharedPolicyGroup.createdAt(Date.from(sharedPolicyGroupEntity.getCreatedAt().toInstant()));
        }
        if (sharedPolicyGroupEntity.getUpdatedAt() != null) {
            sharedPolicyGroup.updatedAt(Date.from(sharedPolicyGroupEntity.getUpdatedAt().toInstant()));
        }
        sharedPolicyGroup.lifecycleState(this.fromEntity(sharedPolicyGroupEntity.getLifecycleState()));
        return sharedPolicyGroup.build();
    }

    @Override
    public SharedPolicyGroupLifecycleState fromEntity(SharedPolicyGroup.SharedPolicyGroupLifecycleState sharedPolicyGroupLifecycleState) {
        if (sharedPolicyGroupLifecycleState == null) {
            return null;
        }
        return switch (sharedPolicyGroupLifecycleState) {
            case SharedPolicyGroup.SharedPolicyGroupLifecycleState.UNDEPLOYED -> SharedPolicyGroupLifecycleState.UNDEPLOYED;
            case SharedPolicyGroup.SharedPolicyGroupLifecycleState.DEPLOYED -> SharedPolicyGroupLifecycleState.DEPLOYED;
            case SharedPolicyGroup.SharedPolicyGroupLifecycleState.PENDING -> SharedPolicyGroupLifecycleState.PENDING;
            default -> throw new IllegalArgumentException("Unexpected enum constant: " + sharedPolicyGroupLifecycleState);
        };
    }

    protected FlowPhase flowPhaseToFlowPhase(SharedPolicyGroup.FlowPhase flowPhase) {
        if (flowPhase == null) {
            return null;
        }
        return switch (flowPhase) {
            case SharedPolicyGroup.FlowPhase.REQUEST -> FlowPhase.REQUEST;
            case SharedPolicyGroup.FlowPhase.RESPONSE -> FlowPhase.RESPONSE;
            case SharedPolicyGroup.FlowPhase.INTERACT -> FlowPhase.INTERACT;
            case SharedPolicyGroup.FlowPhase.CONNECT -> FlowPhase.CONNECT;
            case SharedPolicyGroup.FlowPhase.PUBLISH -> FlowPhase.PUBLISH;
            case SharedPolicyGroup.FlowPhase.SUBSCRIBE -> FlowPhase.SUBSCRIBE;
            default -> throw new IllegalArgumentException("Unexpected enum constant: " + flowPhase);
        };
    }

    protected SharedPolicyGroup.SharedPolicyGroupLifecycleState sharedPolicyGroupLifecycleStateToSharedPolicyGroupLifecycleState(SharedPolicyGroupLifecycleState sharedPolicyGroupLifecycleState) {
        if (sharedPolicyGroupLifecycleState == null) {
            return null;
        }
        return switch (sharedPolicyGroupLifecycleState) {
            case SharedPolicyGroupLifecycleState.DEPLOYED -> SharedPolicyGroup.SharedPolicyGroupLifecycleState.DEPLOYED;
            case SharedPolicyGroupLifecycleState.UNDEPLOYED -> SharedPolicyGroup.SharedPolicyGroupLifecycleState.UNDEPLOYED;
            case SharedPolicyGroupLifecycleState.PENDING -> SharedPolicyGroup.SharedPolicyGroupLifecycleState.PENDING;
            default -> throw new IllegalArgumentException("Unexpected enum constant: " + sharedPolicyGroupLifecycleState);
        };
    }

    protected SharedPolicyGroup.FlowPhase flowPhaseToFlowPhase1(FlowPhase flowPhase) {
        if (flowPhase == null) {
            return null;
        }
        return switch (flowPhase) {
            case FlowPhase.INTERACT -> SharedPolicyGroup.FlowPhase.INTERACT;
            case FlowPhase.CONNECT -> SharedPolicyGroup.FlowPhase.CONNECT;
            case FlowPhase.PUBLISH -> SharedPolicyGroup.FlowPhase.PUBLISH;
            case FlowPhase.SUBSCRIBE -> SharedPolicyGroup.FlowPhase.SUBSCRIBE;
            case FlowPhase.REQUEST -> SharedPolicyGroup.FlowPhase.REQUEST;
            case FlowPhase.RESPONSE -> SharedPolicyGroup.FlowPhase.RESPONSE;
            default -> throw new IllegalArgumentException("Unexpected enum constant: " + flowPhase);
        };
    }
}

