/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.apim.infra.converter.oai;

import com.fasterxml.jackson.databind.ObjectMapper;
import io.gravitee.apim.core.api.model.import_definition.ApiExport;
import io.gravitee.apim.core.api.model.import_definition.ImportDefinition;
import io.gravitee.apim.core.utils.CollectionUtils;
import io.gravitee.apim.infra.converter.oai.OAIServersConverter;
import io.gravitee.apim.infra.converter.oai.OAIToEndpointGroupsConverter;
import io.gravitee.apim.infra.converter.oai.OAIToFlowsConverter;
import io.gravitee.apim.infra.converter.oai.OAIToListenersConverter;
import io.gravitee.apim.infra.converter.oai.OAIToMetadataConverter;
import io.gravitee.apim.infra.converter.oai.OAIToPropertiesConverter;
import io.gravitee.definition.model.DefinitionVersion;
import io.gravitee.definition.model.v4.ApiType;
import io.gravitee.rest.api.model.Visibility;
import io.gravitee.rest.api.service.impl.swagger.visitor.v3.OAIOperationVisitor;
import io.gravitee.rest.api.service.swagger.converter.extension.XGraviteeIODefinition;
import io.swagger.v3.oas.models.OpenAPI;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;

public class OAIToImportDefinitionConverter {
    public static OAIToImportDefinitionConverter INSTANCE = new OAIToImportDefinitionConverter();
    private static final String X_GRAVITEEIO_DEFINITION_VENDOR_EXTENSION = "x-graviteeio-definition";
    private static final String PICTURE_REGEX = "^data:image/[\\w]+;base64,.*$";

    public ImportDefinition toImportDefinition(OpenAPI specification, Collection<? extends OAIOperationVisitor> visitors) {
        XGraviteeIODefinition xGraviteeIODefinition = this.getXGraviteeIODefinition(specification);
        List<String> serverUrls = OAIServersConverter.INSTANCE.convert(specification.getServers());
        ImportDefinition.ImportDefinitionBuilder importDefinitionBuilder = ImportDefinition.builder();
        ApiExport.ApiExportBuilder apiBuilder = ApiExport.builder().name(specification.getInfo().getTitle()).description((String)(StringUtils.isEmpty((CharSequence)specification.getInfo().getDescription()) ? "Description of " + specification.getInfo().getTitle() : specification.getInfo().getDescription())).definitionVersion(DefinitionVersion.V4).apiVersion(specification.getInfo().getVersion()).type(ApiType.PROXY).flows(OAIToFlowsConverter.INSTANCE.convert(specification, visitors)).listeners(OAIToListenersConverter.INSTANCE.convert(xGraviteeIODefinition, specification.getInfo().getTitle(), serverUrls.isEmpty() ? null : serverUrls.get(0))).endpointGroups(OAIToEndpointGroupsConverter.INSTANCE.convert(specification.getServers(), serverUrls));
        if (xGraviteeIODefinition != null) {
            apiBuilder.categories((Set<String>)(CollectionUtils.isEmpty(xGraviteeIODefinition.getCategories()) ? Collections.emptySet() : new HashSet<String>(xGraviteeIODefinition.getCategories()))).labels(CollectionUtils.isEmpty(xGraviteeIODefinition.getLabels()) ? Collections.emptyList() : xGraviteeIODefinition.getLabels()).groups((Set<String>)(CollectionUtils.isEmpty(xGraviteeIODefinition.getGroups()) ? Collections.emptySet() : new HashSet<String>(xGraviteeIODefinition.getGroups()))).picture(xGraviteeIODefinition.getPicture() != null && !StringUtils.isEmpty((CharSequence)xGraviteeIODefinition.getPicture()) && xGraviteeIODefinition.getPicture().matches(PICTURE_REGEX) ? xGraviteeIODefinition.getPicture() : null).visibility(xGraviteeIODefinition.getVisibility() != null ? Visibility.valueOf((String)xGraviteeIODefinition.getVisibility().name()) : null).properties(OAIToPropertiesConverter.INSTANCE.convert(xGraviteeIODefinition.getProperties())).tags((Set<String>)(CollectionUtils.isEmpty(xGraviteeIODefinition.getTags()) ? Collections.emptySet() : new HashSet<String>(xGraviteeIODefinition.getTags())));
            importDefinitionBuilder.metadata(OAIToMetadataConverter.INSTANCE.convert(xGraviteeIODefinition.getMetadata()));
        }
        return importDefinitionBuilder.apiExport(apiBuilder.build()).build();
    }

    private XGraviteeIODefinition getXGraviteeIODefinition(OpenAPI specification) {
        if (specification.getExtensions() == null || specification.getExtensions().get(X_GRAVITEEIO_DEFINITION_VENDOR_EXTENSION) == null) {
            return null;
        }
        return (XGraviteeIODefinition)new ObjectMapper().convertValue(specification.getExtensions().get(X_GRAVITEEIO_DEFINITION_VENDOR_EXTENSION), XGraviteeIODefinition.class);
    }
}

