/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.apim.core.plugin.use_case;

import io.gravitee.apim.core.UseCase;
import io.gravitee.apim.core.plugin.crud_service.ResourcePluginCrudService;
import io.gravitee.apim.core.plugin.domain_service.PluginFilterByLicenseDomainService;
import io.gravitee.apim.core.plugin.model.ResourcePlugin;
import io.gravitee.apim.core.plugin.query_service.ResourcePluginQueryService;
import io.gravitee.rest.api.service.exceptions.ResourceNotFoundException;
import java.util.Set;
import lombok.Generated;

@UseCase
public class GetResourcePluginUseCase {
    private final ResourcePluginCrudService resourcePluginCrudService;
    private final ResourcePluginQueryService resourcePluginQueryService;
    private final PluginFilterByLicenseDomainService licenseChecker;

    public Output execute(Input input) {
        ResourcePlugin resourcePlugin = (ResourcePlugin)this.resourcePluginCrudService.get(input.resourceId).flatMap(resource -> this.licenseChecker.setPluginDeployedStatusDependingOnLicense(Set.of(resource), input.organizationId).stream().findFirst()).orElseThrow(() -> new ResourceNotFoundException(input.resourceId));
        if (!input.withSchema) {
            return new Output(resourcePlugin, null);
        }
        String schema = this.resourcePluginQueryService.getSchema(input.resourceId);
        return new Output(resourcePlugin, schema);
    }

    @Generated
    public GetResourcePluginUseCase(ResourcePluginCrudService resourcePluginCrudService, ResourcePluginQueryService resourcePluginQueryService, PluginFilterByLicenseDomainService licenseChecker) {
        this.resourcePluginCrudService = resourcePluginCrudService;
        this.resourcePluginQueryService = resourcePluginQueryService;
        this.licenseChecker = licenseChecker;
    }

    public record Input(String organizationId, String resourceId, boolean withSchema) {
        public Input(String organizationId, String resourceId) {
            this(organizationId, resourceId, true);
        }
    }

    public record Output(ResourcePlugin plugin, String schema) {
    }
}

