/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.rest.api.service.cockpit.command.handler;

import io.gravitee.apim.core.access_point.crud_service.AccessPointCrudService;
import io.gravitee.apim.core.access_point.model.AccessPoint;
import io.gravitee.cockpit.api.command.v1.CockpitCommandType;
import io.gravitee.cockpit.api.command.v1.installation.UnlinkInstallationCommand;
import io.gravitee.cockpit.api.command.v1.installation.UnlinkInstallationCommandPayload;
import io.gravitee.cockpit.api.command.v1.installation.UnlinkInstallationReply;
import io.gravitee.exchange.api.command.CommandHandler;
import io.gravitee.rest.api.model.EnvironmentEntity;
import io.gravitee.rest.api.model.OrganizationEntity;
import io.gravitee.rest.api.service.EnvironmentService;
import io.gravitee.rest.api.service.OrganizationService;
import io.reactivex.rxjava3.core.Single;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class UnlinkInstallationCommandHandler
implements CommandHandler<UnlinkInstallationCommand, UnlinkInstallationReply> {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(UnlinkInstallationCommandHandler.class);
    private final OrganizationService organizationService;
    private final EnvironmentService environmentService;
    private final AccessPointCrudService accessPointService;

    public String supportType() {
        return CockpitCommandType.UNLINK_INSTALLATION.name();
    }

    public Single<UnlinkInstallationReply> handle(UnlinkInstallationCommand command) {
        UnlinkInstallationCommandPayload unlinkInstallationPayload = (UnlinkInstallationCommandPayload)command.getPayload();
        try {
            if (unlinkInstallationPayload.organizationCockpitId() != null) {
                OrganizationEntity organization = this.organizationService.findByCockpitId(unlinkInstallationPayload.organizationCockpitId());
                this.accessPointService.deleteAccessPoints(AccessPoint.ReferenceType.ORGANIZATION, organization.getId());
            }
            if (unlinkInstallationPayload.environmentCockpitId() != null) {
                EnvironmentEntity environment = this.environmentService.findByCockpitId(unlinkInstallationPayload.environmentCockpitId());
                this.accessPointService.deleteAccessPoints(AccessPoint.ReferenceType.ENVIRONMENT, environment.getId());
            }
            return Single.just((Object)new UnlinkInstallationReply(command.getId()));
        }
        catch (Exception ex) {
            String errorDetails = "Error occurred when unlink installation.";
            log.info(errorDetails, (Throwable)ex);
            return Single.just((Object)new UnlinkInstallationReply(command.getId(), errorDetails));
        }
    }

    @Generated
    public UnlinkInstallationCommandHandler(OrganizationService organizationService, EnvironmentService environmentService, AccessPointCrudService accessPointService) {
        this.organizationService = organizationService;
        this.environmentService = environmentService;
        this.accessPointService = accessPointService;
    }
}

