/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.apim.infra.crud_service.scoring;

import io.gravitee.apim.core.scoring.crud_service.ScoringRulesetCrudService;
import io.gravitee.apim.core.scoring.model.ScoringRuleset;
import io.gravitee.apim.infra.adapter.ScoringRulesetAdapter;
import io.gravitee.repository.exceptions.TechnicalException;
import io.gravitee.repository.management.api.ScoringRulesetRepository;
import io.gravitee.rest.api.service.exceptions.TechnicalManagementException;
import io.gravitee.rest.api.service.impl.AbstractService;
import java.util.Optional;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Service;

@Service
public class ScoringRulesetCrudServiceImpl
extends AbstractService
implements ScoringRulesetCrudService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ScoringRulesetCrudServiceImpl.class);
    private final ScoringRulesetRepository scoringRulesetRepository;

    public ScoringRulesetCrudServiceImpl(@Lazy ScoringRulesetRepository scoringRulesetRepository) {
        this.scoringRulesetRepository = scoringRulesetRepository;
    }

    @Override
    public ScoringRuleset create(ScoringRuleset ruleset) {
        try {
            io.gravitee.repository.management.model.ScoringRuleset created = this.scoringRulesetRepository.create(ScoringRulesetAdapter.INSTANCE.toRepository(ruleset));
            return ScoringRulesetAdapter.INSTANCE.toEntity(created);
        }
        catch (TechnicalException e) {
            throw new TechnicalManagementException("Error when creating Scoring Ruleset: " + ruleset.id(), e);
        }
    }

    @Override
    public Optional<ScoringRuleset> findById(String id) {
        try {
            return this.scoringRulesetRepository.findById(id).map(ScoringRulesetAdapter.INSTANCE::toEntity);
        }
        catch (TechnicalException e) {
            throw new TechnicalManagementException("Error when searching for Scoring Ruleset: " + id, e);
        }
    }

    @Override
    public ScoringRuleset update(ScoringRuleset ruleset) {
        try {
            io.gravitee.repository.management.model.ScoringRuleset updated = this.scoringRulesetRepository.update(ScoringRulesetAdapter.INSTANCE.toRepository(ruleset));
            return ScoringRulesetAdapter.INSTANCE.toEntity(updated);
        }
        catch (TechnicalException e) {
            throw new TechnicalManagementException("Error when updating Scoring Ruleset: " + ruleset.id(), e);
        }
    }

    @Override
    public void delete(String id) {
        try {
            this.scoringRulesetRepository.delete(id);
        }
        catch (TechnicalException e) {
            throw new TechnicalManagementException("Error when deleting Scoring Ruleset: %s".formatted(id), e);
        }
    }

    @Override
    public void deleteByReference(String referenceId, ScoringRuleset.ReferenceType referenceType) {
        try {
            this.scoringRulesetRepository.deleteByReferenceId(referenceId, referenceType.name());
        }
        catch (TechnicalException e) {
            throw new TechnicalManagementException("Error when deleting Scoring Ruleset for [%s:%s]".formatted(new Object[]{referenceType, referenceId}), e);
        }
    }
}

