/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.apim.infra.converter.oai;

import io.gravitee.apim.core.utils.CollectionUtils;
import io.gravitee.common.http.HttpMethod;
import io.gravitee.definition.model.flow.Operator;
import io.gravitee.definition.model.v4.flow.Flow;
import io.gravitee.definition.model.v4.flow.selector.ConditionSelector;
import io.gravitee.definition.model.v4.flow.selector.HttpSelector;
import io.gravitee.definition.model.v4.flow.selector.SelectorType;
import io.gravitee.definition.model.v4.flow.step.Step;
import io.gravitee.policy.api.swagger.Policy;
import io.gravitee.rest.api.service.impl.swagger.visitor.v3.OAIOperationVisitor;
import io.gravitee.rest.api.service.validator.JsonHelper;
import io.swagger.v3.oas.models.OpenAPI;
import io.swagger.v3.oas.models.Operation;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.regex.Pattern;

public class OAIToFlowsConverter {
    public static OAIToFlowsConverter INSTANCE = new OAIToFlowsConverter();
    private static final Pattern PATH_PARAMS_PATTERN = Pattern.compile("\\{(.[^/\\}]*)\\}");

    List<Flow> convert(OpenAPI specification, Collection<? extends OAIOperationVisitor> visitors) {
        ArrayList<Flow> flows = new ArrayList<Flow>();
        specification.getPaths().forEach((key, pathItem) -> {
            String path = PATH_PARAMS_PATTERN.matcher((CharSequence)key).replaceAll(":$1");
            Map operations = pathItem.readOperationsMap();
            operations.forEach((httpMethod, operation) -> {
                Flow flow = this.mapFlow(path, Collections.singleton(HttpMethod.valueOf((String)httpMethod.name())));
                if (!CollectionUtils.isEmpty(visitors)) {
                    visitors.forEach(oaiOperationVisitor -> {
                        Optional policy = (Optional)oaiOperationVisitor.visit(specification, operation);
                        if (policy.isPresent()) {
                            String configuration = JsonHelper.clearNullValues(((Policy)policy.get()).getConfiguration());
                            Step step = this.mapStep((Policy)policy.get(), configuration, (Operation)operation);
                            String scope = JsonHelper.getScope(configuration);
                            if (scope != null && scope.equalsIgnoreCase("response")) {
                                flow.getResponse().add(step);
                            } else {
                                flow.getRequest().add(step);
                            }
                        }
                    });
                }
                flows.add(flow);
            });
        });
        return flows;
    }

    private Flow mapFlow(String path, Set<HttpMethod> methods) {
        return ((Flow.FlowBuilder)((Flow.FlowBuilder)Flow.builder().name("")).enabled(true)).selectors(List.of(((ConditionSelector.ConditionSelectorBuilder)ConditionSelector.builder().condition("").type(SelectorType.CONDITION)).build(), ((HttpSelector.HttpSelectorBuilder)HttpSelector.builder().path(path).pathOperator(Operator.EQUALS).methods(methods).type(SelectorType.HTTP)).build())).build();
    }

    private Step mapStep(Policy policy, String configuration, Operation operation) {
        return Step.builder().name(policy.getName()).enabled(true).description(operation.getSummary() == null ? (operation.getOperationId() == null ? operation.getDescription() : operation.getOperationId()) : operation.getSummary()).policy(policy.getName()).configuration((Object)configuration).build();
    }
}

