/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.apim.core.membership.domain_service;

import io.gravitee.apim.core.DomainService;
import io.gravitee.apim.core.audit.model.AuditInfo;
import io.gravitee.apim.core.membership.crud_service.MembershipCrudService;
import io.gravitee.apim.core.membership.model.Membership;
import io.gravitee.apim.core.membership.model.PrimaryOwnerEntity;
import io.gravitee.apim.core.membership.model.Role;
import io.gravitee.apim.core.membership.query_service.MembershipQueryService;
import io.gravitee.apim.core.membership.query_service.RoleQueryService;
import io.gravitee.apim.core.user.crud_service.UserCrudService;
import io.gravitee.common.utils.TimeProvider;
import io.gravitee.rest.api.model.permissions.SystemRole;
import io.gravitee.rest.api.service.common.ReferenceContext;
import io.gravitee.rest.api.service.common.UuidString;
import io.reactivex.rxjava3.core.Flowable;
import io.reactivex.rxjava3.core.Maybe;
import java.util.Optional;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@DomainService
public class IntegrationPrimaryOwnerDomainService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(IntegrationPrimaryOwnerDomainService.class);
    private final MembershipCrudService membershipCrudService;
    private final RoleQueryService roleQueryService;
    private final MembershipQueryService membershipQueryService;
    private final UserCrudService userCrudService;

    public void createIntegrationPrimaryOwnerMembership(String integrationId, PrimaryOwnerEntity primaryOwner, AuditInfo auditInfo) {
        if (primaryOwner.type() == PrimaryOwnerEntity.Type.GROUP) {
            throw new UnsupportedOperationException(String.format("Group Primary Owner is not supported for integrations. Integration id: %s", integrationId));
        }
        this.findPrimaryOwnerRole(auditInfo.organizationId()).ifPresent(role -> {
            Membership membership = Membership.builder().id(UuidString.generateRandom()).referenceId(integrationId).referenceType(Membership.ReferenceType.INTEGRATION).roleId(role.getId()).memberId(primaryOwner.id()).memberType(Membership.Type.valueOf(primaryOwner.type().name())).createdAt(TimeProvider.now()).updatedAt(TimeProvider.now()).build();
            this.membershipCrudService.create(membership);
        });
    }

    public Maybe<PrimaryOwnerEntity> getIntegrationPrimaryOwner(String organizationId, String integrationId) {
        return Maybe.fromOptional(this.findPrimaryOwnerRole(organizationId)).flatMap(role -> this.findApiPrimaryOwnerMembership(integrationId, (Role)role).flatMap(membership -> switch (membership.getMemberType()) {
            default -> throw new IncompatibleClassChangeError();
            case Membership.Type.USER -> this.findUserPrimaryOwner((Membership)membership);
            case Membership.Type.GROUP -> {
                log.error("Can't have group primary owner for Integrations");
                yield Maybe.empty();
            }
        }));
    }

    private Optional<Role> findPrimaryOwnerRole(String organizationId) {
        return this.roleQueryService.findIntegrationRole(SystemRole.PRIMARY_OWNER.name(), ReferenceContext.builder().referenceType(ReferenceContext.Type.ORGANIZATION).referenceId(organizationId).build());
    }

    private Maybe<Membership> findApiPrimaryOwnerMembership(String integrationId, Role role) {
        return Flowable.fromIterable(this.membershipQueryService.findByReferenceAndRoleId(Membership.ReferenceType.INTEGRATION, integrationId, role.getId())).firstElement();
    }

    private Maybe<PrimaryOwnerEntity> findUserPrimaryOwner(Membership membership) {
        return Maybe.fromOptional(this.userCrudService.findBaseUserById(membership.getMemberId())).map(user -> PrimaryOwnerEntity.builder().id(user.getId()).displayName(user.displayName()).email(user.getEmail()).type(PrimaryOwnerEntity.Type.USER).build());
    }

    @Generated
    public IntegrationPrimaryOwnerDomainService(MembershipCrudService membershipCrudService, RoleQueryService roleQueryService, MembershipQueryService membershipQueryService, UserCrudService userCrudService) {
        this.membershipCrudService = membershipCrudService;
        this.roleQueryService = roleQueryService;
        this.membershipQueryService = membershipQueryService;
        this.userCrudService = userCrudService;
    }
}

