/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.rest.api.service.v4.impl;

import io.gravitee.plugin.apiservice.ApiServicePlugin;
import io.gravitee.plugin.core.api.ConfigurablePluginManager;
import io.gravitee.plugin.core.api.Plugin;
import io.gravitee.rest.api.model.v4.apiservice.ApiServicePluginEntity;
import io.gravitee.rest.api.service.JsonSchemaService;
import io.gravitee.rest.api.service.impl.AbstractPluginService;
import io.gravitee.rest.api.service.v4.ApiServicePluginService;
import java.util.Set;
import java.util.stream.Collectors;
import org.springframework.stereotype.Component;

@Component
public class ApiServicePluginServiceImpl
extends AbstractPluginService<ApiServicePlugin<?, ?>, ApiServicePluginEntity>
implements ApiServicePluginService {
    public ApiServicePluginServiceImpl(JsonSchemaService jsonSchemaService, ConfigurablePluginManager<ApiServicePlugin<?, ?>> pluginManager) {
        super(jsonSchemaService, pluginManager);
    }

    @Override
    public String validateApiServiceConfiguration(String apiServicePluginId, String configuration) {
        ApiServicePluginEntity entity = this.findById(apiServicePluginId);
        return this.validateConfiguration(entity.getId(), configuration);
    }

    @Override
    public Set<ApiServicePluginEntity> findAll() {
        return super.list().stream().map(this::convert).collect(Collectors.toSet());
    }

    @Override
    public ApiServicePluginEntity findById(String plugin) {
        ApiServicePlugin apiSevicePlugin = (ApiServicePlugin)super.get(plugin);
        return this.convert((Plugin)apiSevicePlugin);
    }

    protected ApiServicePluginEntity convert(Plugin plugin) {
        ApiServicePluginEntity entity = new ApiServicePluginEntity();
        entity.setId(plugin.id());
        entity.setDescription(plugin.manifest().description());
        entity.setName(plugin.manifest().name());
        entity.setVersion(plugin.manifest().version());
        entity.setCategory(plugin.manifest().category());
        entity.setDeployed(plugin.deployed());
        return entity;
    }
}

