/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.apim.core.scoring.use_case;

import io.gravitee.apim.core.UseCase;
import io.gravitee.apim.core.api.crud_service.ApiCrudService;
import io.gravitee.apim.core.api.domain_service.ApiExportDomainService;
import io.gravitee.apim.core.api.exception.ApiNotFoundException;
import io.gravitee.apim.core.api.model.import_definition.GraviteeDefinition;
import io.gravitee.apim.core.async_job.crud_service.AsyncJobCrudService;
import io.gravitee.apim.core.async_job.model.AsyncJob;
import io.gravitee.apim.core.audit.model.AuditInfo;
import io.gravitee.apim.core.documentation.domain_service.ApiDocumentationDomainService;
import io.gravitee.apim.core.documentation.model.Page;
import io.gravitee.apim.core.json.GraviteeDefinitionSerializer;
import io.gravitee.apim.core.json.JsonProcessingException;
import io.gravitee.apim.core.scoring.model.ScoreRequest;
import io.gravitee.apim.core.scoring.model.ScoringAssetType;
import io.gravitee.apim.core.scoring.model.ScoringFunction;
import io.gravitee.apim.core.scoring.model.ScoringRuleset;
import io.gravitee.apim.core.scoring.query_service.ScoringFunctionQueryService;
import io.gravitee.apim.core.scoring.query_service.ScoringRulesetQueryService;
import io.gravitee.apim.core.scoring.service_provider.ScoringProvider;
import io.gravitee.apim.core.utils.StringUtils;
import io.gravitee.common.utils.TimeProvider;
import io.gravitee.definition.model.DefinitionVersion;
import io.gravitee.rest.api.service.common.UuidString;
import io.reactivex.rxjava3.core.Completable;
import io.reactivex.rxjava3.core.Flowable;
import io.reactivex.rxjava3.core.Maybe;
import io.reactivex.rxjava3.core.Single;
import io.reactivex.rxjava3.core.SingleSource;
import java.time.ZonedDateTime;
import java.util.List;
import lombok.Generated;
import org.reactivestreams.Publisher;

@UseCase
public class ScoreApiRequestUseCase {
    private final ApiCrudService apiCrudService;
    private final ApiDocumentationDomainService apiDocumentationDomainService;
    private final ApiExportDomainService apiExportDomainService;
    private final GraviteeDefinitionSerializer graviteeDefinitionSerializer;
    private final ScoringProvider scoringProvider;
    private final AsyncJobCrudService asyncJobCrudService;
    private final ScoringRulesetQueryService scoringRulesetQueryService;
    private final ScoringFunctionQueryService scoringFunctionQueryService;

    public Completable execute(Input input) {
        Flowable pages$ = Flowable.fromIterable(this.apiDocumentationDomainService.getApiPages(input.apiId, null)).filter(page -> page.isAsyncApi() || page.isSwagger()).map(this::assetToScore);
        Single customRulesets$ = Flowable.fromCallable(() -> this.scoringRulesetQueryService.findByReference(input.auditInfo.environmentId(), ScoringRuleset.ReferenceType.ENVIRONMENT)).flatMap(Flowable::fromIterable).flatMapMaybe(this::customRuleset).toList();
        Single customFunctions$ = Flowable.fromCallable(() -> this.scoringFunctionQueryService.findByReference(input.auditInfo.environmentId(), ScoringFunction.ReferenceType.ENVIRONMENT)).flatMap(Flowable::fromIterable).map(r -> new ScoreRequest.Function(r.name(), r.payload())).toList();
        Flowable export$ = Flowable.fromCallable(() -> this.apiExportDomainService.export(input.apiId, input.auditInfo)).map(this::assetToScore).onErrorResumeNext(th -> Flowable.empty());
        return Maybe.fromOptional(this.apiCrudService.findById(input.apiId())).switchIfEmpty((SingleSource)Single.error((Throwable)new ApiNotFoundException(input.apiId()))).flatMap(api -> Flowable.merge((Publisher)pages$, (Publisher)export$).toList()).flatMap(assets -> Single.zip((SingleSource)customRulesets$, (SingleSource)customFunctions$, RulesetAndFunctions::new).map(entry -> new ScoreRequest(UuidString.generateRandom(), input.auditInfo.organizationId(), input.auditInfo.environmentId(), input.apiId, (List<ScoreRequest.AssetToScore>)assets, entry.rulesets(), entry.functions()))).flatMapCompletable(request -> {
            if (request.assets().isEmpty()) {
                return Completable.complete();
            }
            AsyncJob job = this.newScoringJob(request.jobId(), input.auditInfo, input.apiId);
            return this.scoringProvider.requestScore((ScoreRequest)request).doOnComplete(() -> this.asyncJobCrudService.create(job));
        });
    }

    private ScoreRequest.AssetToScore assetToScore(Page page) {
        return new ScoreRequest.AssetToScore(page.getId(), new ScoreRequest.AssetType(ScoringAssetType.fromPageType(page.getType())), page.getName(), page.getContent());
    }

    private ScoreRequest.AssetToScore assetToScore(GraviteeDefinition definition) throws JsonProcessingException {
        ScoreRequest.Format format;
        if (definition.getApi().getEndpointGroups() != null) {
            definition.getApi().getEndpointGroups().forEach(endpoint -> endpoint.setSharedConfiguration((String)null));
        }
        String string = definition.getApi().getId();
        if (definition.getApi().getDefinitionVersion() == DefinitionVersion.FEDERATED) {
            format = ScoreRequest.Format.GRAVITEE_FEDERATED;
        } else {
            switch (definition.getApi().getType()) {
                case PROXY: {
                    format = ScoreRequest.Format.GRAVITEE_PROXY;
                    break;
                }
                case MESSAGE: {
                    format = ScoreRequest.Format.GRAVITEE_MESSAGE;
                    break;
                }
                default: {
                    format = null;
                }
            }
        }
        return new ScoreRequest.AssetToScore(string, new ScoreRequest.AssetType(ScoringAssetType.GRAVITEE_DEFINITION, format), definition.getApi().getName(), this.graviteeDefinitionSerializer.serialize(definition));
    }

    private Maybe<ScoreRequest.CustomRuleset> customRuleset(ScoringRuleset scoringRuleset) {
        if (StringUtils.isEmpty(scoringRuleset.payload())) {
            return Maybe.empty();
        }
        return scoringRuleset.format() != null ? Maybe.just((Object)new ScoreRequest.CustomRuleset(scoringRuleset.payload(), this.format(scoringRuleset.format()))) : Maybe.just((Object)new ScoreRequest.CustomRuleset(scoringRuleset.payload()));
    }

    private ScoreRequest.Format format(ScoringRuleset.Format format) {
        return switch (format) {
            default -> throw new IncompatibleClassChangeError();
            case ScoringRuleset.Format.GRAVITEE_FEDERATION -> ScoreRequest.Format.GRAVITEE_FEDERATED;
            case ScoringRuleset.Format.GRAVITEE_MESSAGE -> ScoreRequest.Format.GRAVITEE_MESSAGE;
            case ScoringRuleset.Format.GRAVITEE_PROXY -> ScoreRequest.Format.GRAVITEE_PROXY;
        };
    }

    public AsyncJob newScoringJob(String id, AuditInfo auditInfo, String apiId) {
        ZonedDateTime now = TimeProvider.now();
        return AsyncJob.builder().id(id).sourceId(apiId).environmentId(auditInfo.environmentId()).initiatorId(auditInfo.actor().userId()).type(AsyncJob.Type.SCORING_REQUEST).status(AsyncJob.Status.PENDING).upperLimit(1L).createdAt(now).updatedAt(now).build();
    }

    @Generated
    public ScoreApiRequestUseCase(ApiCrudService apiCrudService, ApiDocumentationDomainService apiDocumentationDomainService, ApiExportDomainService apiExportDomainService, GraviteeDefinitionSerializer graviteeDefinitionSerializer, ScoringProvider scoringProvider, AsyncJobCrudService asyncJobCrudService, ScoringRulesetQueryService scoringRulesetQueryService, ScoringFunctionQueryService scoringFunctionQueryService) {
        this.apiCrudService = apiCrudService;
        this.apiDocumentationDomainService = apiDocumentationDomainService;
        this.apiExportDomainService = apiExportDomainService;
        this.graviteeDefinitionSerializer = graviteeDefinitionSerializer;
        this.scoringProvider = scoringProvider;
        this.asyncJobCrudService = asyncJobCrudService;
        this.scoringRulesetQueryService = scoringRulesetQueryService;
        this.scoringFunctionQueryService = scoringFunctionQueryService;
    }

    public record Input(String apiId, AuditInfo auditInfo) {
    }

    private record RulesetAndFunctions(List<ScoreRequest.CustomRuleset> rulesets, List<ScoreRequest.Function> functions) {
    }
}

