/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.rest.api.service.exceptions;

import io.gravitee.rest.api.model.theme.ThemeType;
import io.gravitee.rest.api.service.exceptions.AbstractManagementException;
import java.util.Collections;
import java.util.Map;

public class ThemeTypeNotSupportedException
extends AbstractManagementException {
    private final String id;
    private final String type;

    public ThemeTypeNotSupportedException() {
        this.id = null;
        this.type = null;
    }

    public ThemeTypeNotSupportedException(String id, ThemeType type) {
        this.id = id;
        this.type = type.name();
    }

    @Override
    public int getHttpStatusCode() {
        return 400;
    }

    @Override
    public String getMessage() {
        return String.format("[ %s ] theme is currently not supported", this.type);
    }

    @Override
    public String getTechnicalCode() {
        return "themeType.notAllowed";
    }

    @Override
    public Map<String, String> getParameters() {
        return Collections.singletonMap("id", this.id);
    }
}

