/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.apim.infra.adapter;

import io.gravitee.apim.core.api.model.import_definition.ApiExport;
import io.gravitee.apim.core.api.model.import_definition.GraviteeDefinition;
import io.gravitee.apim.core.api.model.import_definition.PlanExport;
import io.gravitee.apim.infra.adapter.ApiAdapter;
import io.gravitee.apim.infra.adapter.MemberAdapter;
import io.gravitee.apim.infra.adapter.MetadataAdapter;
import io.gravitee.apim.infra.adapter.PageAdapter;
import io.gravitee.apim.infra.adapter.PlanAdapter;
import io.gravitee.definition.model.v4.plan.PlanSecurity;
import io.gravitee.rest.api.model.v4.api.ApiEntity;
import io.gravitee.rest.api.model.v4.api.ExportApiEntity;
import io.gravitee.rest.api.model.v4.api.GenericApiEntity;
import io.gravitee.rest.api.model.v4.plan.GenericPlanEntity;
import io.gravitee.rest.api.model.v4.plan.PlanEntity;
import io.gravitee.rest.api.model.v4.plan.PlanSecurityType;
import java.util.Set;
import java.util.stream.Collectors;
import org.mapstruct.Mapper;
import org.mapstruct.Mapping;
import org.mapstruct.Mappings;
import org.mapstruct.factory.Mappers;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Mapper(uses={ApiAdapter.class, PlanAdapter.class, MemberAdapter.class, MetadataAdapter.class, PageAdapter.class})
public interface GraviteeDefinitionAdapter {
    public static final GraviteeDefinitionAdapter INSTANCE = (GraviteeDefinitionAdapter)Mappers.getMapper(GraviteeDefinitionAdapter.class);
    public static final Logger logger = LoggerFactory.getLogger(GraviteeDefinitionAdapter.class);

    @Mappings(value={@Mapping(target="api", expression="java(mapApi(source.getApiEntity()))"), @Mapping(target="plans", expression="java(mapPlans(source.getPlans()))")})
    public GraviteeDefinition map(ExportApiEntity var1);

    default public ApiExport mapApi(GenericApiEntity source) {
        if (source instanceof ApiEntity) {
            ApiEntity v4 = (ApiEntity)source;
            return this.mapApiEntity(v4);
        }
        return this.mapGenericApiEntity(source);
    }

    public ApiExport mapApiEntity(ApiEntity var1);

    public ApiExport mapGenericApiEntity(GenericApiEntity var1);

    default public Set<PlanExport> mapPlans(Set<? extends GenericPlanEntity> source) {
        return source.stream().map((? super T plan) -> {
            if (plan instanceof PlanEntity) {
                PlanEntity v4 = (PlanEntity)plan;
                return this.mapPlanEntity(v4);
            }
            return this.mapGenericApiEntity((GenericPlanEntity)plan);
        }).collect(Collectors.toSet());
    }

    @Mappings(value={@Mapping(target="mode", source="planMode"), @Mapping(target="security", expression="java(mapPlanSecurity(source.getPlanSecurity()))"), @Mapping(target="status", source="planStatus"), @Mapping(target="type", source="planType"), @Mapping(target="validation", source="planValidation")})
    public PlanExport mapPlanEntity(PlanEntity var1);

    @Mappings(value={@Mapping(target="mode", source="planMode"), @Mapping(target="security", expression="java(mapPlanSecurity(source.getPlanSecurity()))"), @Mapping(target="status", source="planStatus"), @Mapping(target="type", source="planType"), @Mapping(target="validation", source="planValidation")})
    public PlanExport mapGenericApiEntity(GenericPlanEntity var1);

    default public PlanSecurity mapPlanSecurity(PlanSecurity source) {
        return PlanSecurity.builder().type(PlanSecurityType.valueOfLabel((String)source.getType()).name()).configuration(source.getConfiguration()).build();
    }
}

