/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.apim.core.analytics.use_case;

import io.gravitee.apim.core.UseCase;
import io.gravitee.apim.core.analytics.model.AnalyticsQueryParameters;
import io.gravitee.apim.core.analytics.query_service.AnalyticsQueryService;
import io.gravitee.apim.core.api.model.Api;
import io.gravitee.apim.core.api.model.ApiFieldFilter;
import io.gravitee.apim.core.api.model.ApiSearchCriteria;
import io.gravitee.apim.core.api.query_service.ApiQueryService;
import io.gravitee.definition.model.DefinitionVersion;
import io.gravitee.rest.api.model.v4.analytics.ResponseStatusRanges;
import io.gravitee.rest.api.service.common.ExecutionContext;
import java.util.List;
import java.util.Optional;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@UseCase
public class SearchEnvironmentResponseStatusRangesUseCase {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(SearchEnvironmentResponseStatusRangesUseCase.class);
    AnalyticsQueryService analyticsQueryService;
    ApiQueryService apiQueryService;

    public Output execute(Input input) {
        String envId = input.executionContext().getEnvironmentId();
        List<String> v4ApiIds = this.apiQueryService.search(ApiSearchCriteria.builder().environmentId(envId).definitionVersion(List.of(DefinitionVersion.V4)).build(), null, ApiFieldFilter.builder().pictureExcluded(true).definitionExcluded(true).build()).map(Api::getId).toList();
        log.info("Searching environment API response status ranges, found: {} v4 APIs for env: {}", (Object)v4ApiIds.size(), (Object)envId);
        return this.analyticsQueryService.searchResponseStatusRanges(input.executionContext(), input.parameters().withApiIds(v4ApiIds)).map(Output::new).orElse(new Output());
    }

    @Generated
    public SearchEnvironmentResponseStatusRangesUseCase(AnalyticsQueryService analyticsQueryService, ApiQueryService apiQueryService) {
        this.analyticsQueryService = analyticsQueryService;
        this.apiQueryService = apiQueryService;
    }

    public record Input(ExecutionContext executionContext, AnalyticsQueryParameters parameters) {
        @Generated
        public static InputBuilder builder() {
            return new InputBuilder();
        }

        @Generated
        public static class InputBuilder {
            @Generated
            private ExecutionContext executionContext;
            @Generated
            private AnalyticsQueryParameters parameters;

            @Generated
            InputBuilder() {
            }

            @Generated
            public InputBuilder executionContext(ExecutionContext executionContext) {
                this.executionContext = executionContext;
                return this;
            }

            @Generated
            public InputBuilder parameters(AnalyticsQueryParameters parameters) {
                this.parameters = parameters;
                return this;
            }

            @Generated
            public Input build() {
                return new Input(this.executionContext, this.parameters);
            }

            @Generated
            public String toString() {
                return "SearchEnvironmentResponseStatusRangesUseCase.Input.InputBuilder(executionContext=" + this.executionContext + ", parameters=" + this.parameters + ")";
            }
        }
    }

    public record Output(Optional<ResponseStatusRanges> responseStatusRanges) {
        Output(ResponseStatusRanges responseStatusRanges) {
            this(Optional.of(responseStatusRanges));
        }

        Output() {
            this(new ResponseStatusRanges());
        }
    }
}

