/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.rest.api.service.search.query;

import io.gravitee.rest.api.model.common.Pageable;
import io.gravitee.rest.api.model.common.Sortable;
import io.gravitee.rest.api.model.search.Indexable;
import io.gravitee.rest.api.service.search.query.Query;
import java.util.Collection;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.apache.lucene.queryparser.classic.QueryParser;

public class QueryBuilder<T extends Indexable> {
    private final Query<T> query;

    private QueryBuilder(Class<T> root) {
        this.query = new Query<T>(root);
    }

    public static <S extends Indexable> QueryBuilder<S> create(Class<S> root) {
        return new QueryBuilder<S>(root);
    }

    public QueryBuilder<T> setQuery(String query) {
        this.query.setQuery(query);
        return this;
    }

    public QueryBuilder<T> addFilter(String name, Object value) {
        this.query.getFilters().put(name, value);
        return this;
    }

    public QueryBuilder<T> addExplicitFilter(String name, String value) {
        StringBuilder sb = new StringBuilder(name).append(":").append(QueryParser.escape((String)value));
        if (!StringUtils.isBlank((CharSequence)this.query.getQuery())) {
            sb.append(" ").append(this.query.getQuery());
        }
        this.query.setQuery(sb.toString());
        return this;
    }

    public QueryBuilder<T> removeFilter(String name) {
        this.query.getFilters().remove(name);
        return this;
    }

    public QueryBuilder<T> setFilters(Map<String, Object> filters) {
        this.query.setFilters(filters);
        return this;
    }

    public QueryBuilder<T> setExcludedFilters(Map<String, Collection<String>> filters) {
        this.query.setExcludedFilters(filters);
        return this;
    }

    public QueryBuilder<T> setPage(Pageable pageable) {
        this.query.setPage(pageable);
        return this;
    }

    public QueryBuilder<T> setSort(Sortable sortable) {
        this.query.setSort(sortable);
        return this;
    }

    public Query<T> build() {
        return this.query;
    }
}

