/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.rest.api.service.exceptions;

import io.gravitee.rest.api.service.exceptions.AbstractManagementException;
import java.util.Collections;
import java.util.Map;

public class NativePlanAuthenticationConflictException
extends AbstractManagementException {
    private final boolean planToPublishIsKeyless;

    public NativePlanAuthenticationConflictException(boolean planToPublishIsKeyless) {
        this.planToPublishIsKeyless = planToPublishIsKeyless;
    }

    @Override
    public String getMessage() {
        return this.planToPublishIsKeyless ? "A plan with authentication is already published for the Native API." : "A Keyless plan for the Native API is already published.";
    }

    @Override
    public int getHttpStatusCode() {
        return 400;
    }

    @Override
    public String getTechnicalCode() {
        return "plan.native.authentication.conflict";
    }

    @Override
    public Map<String, String> getParameters() {
        return Collections.singletonMap("planToPublishIsKeyless", Boolean.valueOf(this.planToPublishIsKeyless).toString());
    }
}

