/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.apim.infra.crud_service.scoring;

import io.gravitee.apim.core.scoring.crud_service.ScoringFunctionCrudService;
import io.gravitee.apim.core.scoring.model.ScoringFunction;
import io.gravitee.apim.infra.adapter.ScoringFunctionAdapter;
import io.gravitee.repository.exceptions.TechnicalException;
import io.gravitee.repository.management.api.ScoringFunctionRepository;
import io.gravitee.rest.api.service.exceptions.TechnicalManagementException;
import io.gravitee.rest.api.service.impl.AbstractService;
import java.util.Optional;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Service;

@Service
public class ScoringFunctionCrudServiceImpl
extends AbstractService
implements ScoringFunctionCrudService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ScoringFunctionCrudServiceImpl.class);
    private final ScoringFunctionRepository scoringFunctionRepository;

    public ScoringFunctionCrudServiceImpl(@Lazy ScoringFunctionRepository scoringFunctionRepository) {
        this.scoringFunctionRepository = scoringFunctionRepository;
    }

    @Override
    public ScoringFunction create(ScoringFunction function) {
        try {
            this.removeFunctionsWithSameNameAndType(function.name(), function.referenceId(), function.referenceType());
            io.gravitee.repository.management.model.ScoringFunction newFctToSave = ScoringFunctionAdapter.INSTANCE.toRepository(function);
            io.gravitee.repository.management.model.ScoringFunction created = this.scoringFunctionRepository.create(newFctToSave);
            return ScoringFunctionAdapter.INSTANCE.toEntity(created);
        }
        catch (TechnicalException e) {
            throw new TechnicalManagementException("Error when creating Scoring Function: " + function.id(), e);
        }
    }

    @Override
    public Optional<ScoringFunction> findById(String id) {
        try {
            return this.scoringFunctionRepository.findById(id).map(ScoringFunctionAdapter.INSTANCE::toEntity);
        }
        catch (TechnicalException e) {
            throw new TechnicalManagementException("Error when searching for Scoring Function: " + id, e);
        }
    }

    @Override
    public void delete(String id) {
        try {
            this.scoringFunctionRepository.delete(id);
        }
        catch (TechnicalException e) {
            throw new TechnicalManagementException("Error when deleting Scoring Function: %s".formatted(id), e);
        }
    }

    @Override
    public void deleteByReference(String referenceId, ScoringFunction.ReferenceType referenceType) {
        try {
            this.scoringFunctionRepository.deleteByReferenceId(referenceId, referenceType.name());
        }
        catch (TechnicalException e) {
            throw new TechnicalManagementException("Error when deleting Scoring Function for [%s:%s]".formatted(new Object[]{referenceType, referenceId}), e);
        }
    }

    @Override
    public void deleteByReferenceAndName(String referenceId, ScoringFunction.ReferenceType referenceType, String name) {
        try {
            this.removeFunctionsWithSameNameAndType(name, referenceId, referenceType);
        }
        catch (TechnicalException e) {
            throw new TechnicalManagementException("Error when deleting Scoring Function for [%s:%s]".formatted(new Object[]{referenceType, referenceId}), e);
        }
    }

    private void removeFunctionsWithSameNameAndType(String name, String reference, ScoringFunction.ReferenceType refType) throws TechnicalException {
        this.scoringFunctionRepository.findAllByReferenceId(reference, refType.name()).stream().filter(fct -> fct.getName().equals(name)).map(io.gravitee.repository.management.model.ScoringFunction::getId).forEach(this::delete);
    }
}

