/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.apim.infra.adapter;

import io.gravitee.apim.core.api.model.crd.PlanCRD;
import io.gravitee.apim.core.plan.model.Plan;
import io.gravitee.apim.infra.adapter.PlanAdapter;
import io.gravitee.definition.model.DefinitionVersion;
import io.gravitee.definition.model.Plan;
import io.gravitee.definition.model.v4.flow.AbstractFlow;
import io.gravitee.definition.model.v4.flow.Flow;
import io.gravitee.definition.model.v4.nativeapi.NativePlan;
import io.gravitee.definition.model.v4.plan.Plan;
import io.gravitee.definition.model.v4.plan.PlanMode;
import io.gravitee.definition.model.v4.plan.PlanSecurity;
import io.gravitee.definition.model.v4.plan.PlanStatus;
import io.gravitee.repository.management.model.Plan;
import io.gravitee.rest.api.model.PlanEntity;
import io.gravitee.rest.api.model.v4.nativeapi.NativePlanEntity;
import io.gravitee.rest.api.model.v4.plan.NewPlanEntity;
import io.gravitee.rest.api.model.v4.plan.PlanEntity;
import io.gravitee.rest.api.model.v4.plan.PlanType;
import io.gravitee.rest.api.model.v4.plan.PlanValidationType;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.util.ArrayList;
import java.util.Date;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;

public class PlanAdapterImpl
implements PlanAdapter {
    @Override
    public io.gravitee.apim.core.plan.model.Plan fromRepository(io.gravitee.repository.management.model.Plan plan) {
        List list1;
        if (plan == null) {
            return null;
        }
        Plan.PlanBuilder<?, ?> plan1 = io.gravitee.apim.core.plan.model.Plan.builder();
        plan1.apiId(plan.getApi());
        if (plan.getDefinitionVersion() != null) {
            plan1.definitionVersion(plan.getDefinitionVersion());
        } else {
            plan1.definitionVersion(DefinitionVersion.V2);
        }
        plan1.id(plan.getId());
        plan1.crossId(plan.getCrossId());
        plan1.name(plan.getName());
        plan1.description(plan.getDescription());
        if (plan.getCreatedAt() != null) {
            plan1.createdAt(ZonedDateTime.ofInstant(plan.getCreatedAt().toInstant(), ZoneId.systemDefault()));
        }
        if (plan.getUpdatedAt() != null) {
            plan1.updatedAt(ZonedDateTime.ofInstant(plan.getUpdatedAt().toInstant(), ZoneId.systemDefault()));
        }
        if (plan.getPublishedAt() != null) {
            plan1.publishedAt(ZonedDateTime.ofInstant(plan.getPublishedAt().toInstant(), ZoneId.systemDefault()));
        }
        if (plan.getClosedAt() != null) {
            plan1.closedAt(ZonedDateTime.ofInstant(plan.getClosedAt().toInstant(), ZoneId.systemDefault()));
        }
        plan1.needRedeployAt(plan.getNeedRedeployAt());
        plan1.validation(this.planValidationTypeToPlanValidationType(plan.getValidation()));
        plan1.type(this.planTypeToPlanType(plan.getType()));
        plan1.environmentId(plan.getEnvironmentId());
        plan1.order(plan.getOrder());
        List list = plan.getCharacteristics();
        if (list != null) {
            plan1.characteristics(new ArrayList<String>(list));
        }
        if ((list1 = plan.getExcludedGroups()) != null) {
            plan1.excludedGroups(new ArrayList<String>(list1));
        }
        plan1.commentRequired(plan.isCommentRequired());
        plan1.commentMessage(plan.getCommentMessage());
        plan1.generalConditions(plan.getGeneralConditions());
        plan1.apiType(plan.getApiType());
        plan1.planDefinitionHttpV4(this.deserializeDefinitionHttpV4(plan));
        plan1.planDefinitionNativeV4(this.deserializeDefinitionNativeV4(plan));
        plan1.planDefinitionV2(this.deserializeDefinitionV2(plan));
        plan1.federatedPlanDefinition(this.deserializeDefinitionFederated(plan));
        return plan1.build();
    }

    @Override
    public io.gravitee.repository.management.model.Plan toRepository(io.gravitee.apim.core.plan.model.Plan source) {
        List<String> list1;
        List<String> list;
        if (source == null) {
            return null;
        }
        Plan.PlanBuilder plan = io.gravitee.repository.management.model.Plan.builder();
        plan.api(source.getApiId());
        plan.security(this.computeRepositorySecurityType(source.getPlanSecurity()));
        plan.securityDefinition(this.sourcePlanSecurityConfiguration(source));
        plan.mode(this.planModeToPlanMode(source.getPlanMode()));
        plan.status(this.planStatusToStatus(source.getPlanStatus()));
        plan.id(source.getId());
        plan.definitionVersion(source.getDefinitionVersion());
        plan.crossId(source.getCrossId());
        plan.name(source.getName());
        plan.description(source.getDescription());
        plan.validation(this.planValidationTypeToPlanValidationType1(source.getValidation()));
        plan.type(this.planTypeToPlanType1(source.getType()));
        plan.order(source.getOrder());
        plan.environmentId(source.getEnvironmentId());
        if (source.getCreatedAt() != null) {
            plan.createdAt(Date.from(source.getCreatedAt().toInstant()));
        }
        if (source.getUpdatedAt() != null) {
            plan.updatedAt(Date.from(source.getUpdatedAt().toInstant()));
        }
        if (source.getPublishedAt() != null) {
            plan.publishedAt(Date.from(source.getPublishedAt().toInstant()));
        }
        if (source.getClosedAt() != null) {
            plan.closedAt(Date.from(source.getClosedAt().toInstant()));
        }
        if ((list = source.getCharacteristics()) != null) {
            plan.characteristics(new ArrayList<String>(list));
        }
        if ((list1 = source.getExcludedGroups()) != null) {
            plan.excludedGroups(new ArrayList<String>(list1));
        }
        plan.needRedeployAt(source.getNeedRedeployAt());
        plan.commentRequired(source.isCommentRequired());
        plan.commentMessage(source.getCommentMessage());
        plan.generalConditions(source.getGeneralConditions());
        plan.apiType(source.getApiType());
        plan.definition(this.serializeDefinition(source));
        plan.selectionRule(this.serializeSelectionRule(source));
        plan.tags(this.serializeTags(source));
        return plan.build();
    }

    @Override
    public PlanEntity toEntityV4(io.gravitee.apim.core.plan.model.Plan plan) {
        List<String> list1;
        if (plan == null) {
            return null;
        }
        PlanEntity.PlanEntityBuilder planEntity = PlanEntity.builder();
        planEntity.status(plan.getPlanStatus());
        planEntity.security(plan.getPlanSecurity());
        planEntity.mode(plan.getPlanMode());
        planEntity.id(plan.getId());
        planEntity.definitionVersion(plan.getDefinitionVersion());
        planEntity.crossId(plan.getCrossId());
        planEntity.name(plan.getName());
        planEntity.description(plan.getDescription());
        if (plan.getCreatedAt() != null) {
            planEntity.createdAt(Date.from(plan.getCreatedAt().toInstant()));
        }
        if (plan.getUpdatedAt() != null) {
            planEntity.updatedAt(Date.from(plan.getUpdatedAt().toInstant()));
        }
        if (plan.getPublishedAt() != null) {
            planEntity.publishedAt(Date.from(plan.getPublishedAt().toInstant()));
        }
        if (plan.getClosedAt() != null) {
            planEntity.closedAt(Date.from(plan.getClosedAt().toInstant()));
        }
        planEntity.needRedeployAt(plan.getNeedRedeployAt());
        planEntity.validation(this.planValidationTypeToPlanValidationType2(plan.getValidation()));
        planEntity.type(this.planTypeToPlanType2(plan.getType()));
        planEntity.selectionRule(plan.getSelectionRule());
        Set<String> set = plan.getTags();
        if (set != null) {
            planEntity.tags(new LinkedHashSet<String>(set));
        }
        planEntity.apiId(plan.getApiId());
        planEntity.environmentId(plan.getEnvironmentId());
        planEntity.order(plan.getOrder());
        List<String> list = plan.getCharacteristics();
        if (list != null) {
            planEntity.characteristics(new ArrayList<String>(list));
        }
        if ((list1 = plan.getExcludedGroups()) != null) {
            planEntity.excludedGroups(new ArrayList<String>(list1));
        }
        planEntity.commentRequired(plan.isCommentRequired());
        planEntity.commentMessage(plan.getCommentMessage());
        planEntity.generalConditions(plan.getGeneralConditions());
        planEntity.apiType(plan.getApiType());
        return planEntity.build();
    }

    @Override
    public NativePlanEntity toNativePlanEntityV4(io.gravitee.apim.core.plan.model.Plan plan) {
        List<String> list1;
        if (plan == null) {
            return null;
        }
        NativePlanEntity.NativePlanEntityBuilder nativePlanEntity = NativePlanEntity.builder();
        nativePlanEntity.status(plan.getPlanStatus());
        nativePlanEntity.security(plan.getPlanSecurity());
        nativePlanEntity.mode(plan.getPlanMode());
        nativePlanEntity.id(plan.getId());
        nativePlanEntity.definitionVersion(plan.getDefinitionVersion());
        nativePlanEntity.crossId(plan.getCrossId());
        nativePlanEntity.name(plan.getName());
        nativePlanEntity.description(plan.getDescription());
        if (plan.getCreatedAt() != null) {
            nativePlanEntity.createdAt(Date.from(plan.getCreatedAt().toInstant()));
        }
        if (plan.getUpdatedAt() != null) {
            nativePlanEntity.updatedAt(Date.from(plan.getUpdatedAt().toInstant()));
        }
        if (plan.getPublishedAt() != null) {
            nativePlanEntity.publishedAt(Date.from(plan.getPublishedAt().toInstant()));
        }
        if (plan.getClosedAt() != null) {
            nativePlanEntity.closedAt(Date.from(plan.getClosedAt().toInstant()));
        }
        nativePlanEntity.needRedeployAt(plan.getNeedRedeployAt());
        nativePlanEntity.validation(this.planValidationTypeToPlanValidationType2(plan.getValidation()));
        nativePlanEntity.type(this.planTypeToPlanType2(plan.getType()));
        nativePlanEntity.selectionRule(plan.getSelectionRule());
        Set<String> set = plan.getTags();
        if (set != null) {
            nativePlanEntity.tags(new LinkedHashSet<String>(set));
        }
        nativePlanEntity.apiId(plan.getApiId());
        nativePlanEntity.environmentId(plan.getEnvironmentId());
        nativePlanEntity.order(plan.getOrder());
        List<String> list = plan.getCharacteristics();
        if (list != null) {
            nativePlanEntity.characteristics(new ArrayList<String>(list));
        }
        if ((list1 = plan.getExcludedGroups()) != null) {
            nativePlanEntity.excludedGroups(new ArrayList<String>(list1));
        }
        nativePlanEntity.commentRequired(plan.isCommentRequired());
        nativePlanEntity.commentMessage(plan.getCommentMessage());
        nativePlanEntity.generalConditions(plan.getGeneralConditions());
        nativePlanEntity.apiType(plan.getApiType());
        return nativePlanEntity.build();
    }

    @Override
    public io.gravitee.rest.api.model.PlanEntity toEntityV2(io.gravitee.apim.core.plan.model.Plan source) {
        List<String> list1;
        List<String> list;
        if (source == null) {
            return null;
        }
        PlanEntity.PlanEntityBuilder planEntity = io.gravitee.rest.api.model.PlanEntity.builder();
        planEntity.api(source.getApiId());
        planEntity.status(this.planStatusToPlanStatus(source.getPlanStatus()));
        planEntity.security(this.mapPlanSecurityTypeV2(source.getPlanSecurity()));
        planEntity.securityDefinition(this.sourcePlanSecurityConfiguration(source));
        planEntity.id(source.getId());
        planEntity.definitionVersion(source.getDefinitionVersion());
        planEntity.crossId(source.getCrossId());
        planEntity.name(source.getName());
        planEntity.description(source.getDescription());
        planEntity.validation(this.planValidationTypeToPlanValidationType3(source.getValidation()));
        planEntity.type(this.planTypeToPlanType3(source.getType()));
        planEntity.environmentId(source.getEnvironmentId());
        planEntity.order(source.getOrder());
        if (source.getCreatedAt() != null) {
            planEntity.createdAt(Date.from(source.getCreatedAt().toInstant()));
        }
        if (source.getUpdatedAt() != null) {
            planEntity.updatedAt(Date.from(source.getUpdatedAt().toInstant()));
        }
        if (source.getPublishedAt() != null) {
            planEntity.publishedAt(Date.from(source.getPublishedAt().toInstant()));
        }
        if (source.getClosedAt() != null) {
            planEntity.closedAt(Date.from(source.getClosedAt().toInstant()));
        }
        if ((list = source.getCharacteristics()) != null) {
            planEntity.characteristics(new ArrayList<String>(list));
        }
        if ((list1 = source.getExcludedGroups()) != null) {
            planEntity.excludedGroups(new ArrayList<String>(list1));
        }
        planEntity.needRedeployAt(source.getNeedRedeployAt());
        planEntity.commentRequired(source.isCommentRequired());
        planEntity.commentMessage(source.getCommentMessage());
        planEntity.generalConditions(source.getGeneralConditions());
        Set<String> set = source.getTags();
        if (set != null) {
            planEntity.tags(new LinkedHashSet<String>(set));
        }
        planEntity.selectionRule(source.getSelectionRule());
        return planEntity.build();
    }

    @Override
    public NewPlanEntity entityToNewPlanEntity(PlanEntity entity) {
        List list2;
        List list1;
        if (entity == null) {
            return null;
        }
        NewPlanEntity newPlanEntity = new NewPlanEntity();
        newPlanEntity.setName(entity.getName());
        newPlanEntity.setDescription(entity.getDescription());
        newPlanEntity.setId(entity.getId());
        newPlanEntity.setCrossId(entity.getCrossId());
        newPlanEntity.setApiId(entity.getApiId());
        newPlanEntity.setValidation(entity.getValidation());
        newPlanEntity.setSecurity(entity.getSecurity());
        newPlanEntity.setType(entity.getType());
        newPlanEntity.setMode(entity.getMode());
        newPlanEntity.setStatus(entity.getStatus());
        List list = entity.getFlows();
        if (list != null) {
            newPlanEntity.setFlows(new ArrayList(list));
        }
        if ((list1 = entity.getCharacteristics()) != null) {
            newPlanEntity.setCharacteristics(new ArrayList(list1));
        }
        if ((list2 = entity.getExcludedGroups()) != null) {
            newPlanEntity.setExcludedGroups(new ArrayList(list2));
        }
        newPlanEntity.setCommentRequired(entity.isCommentRequired());
        newPlanEntity.setCommentMessage(entity.getCommentMessage());
        Set set = entity.getTags();
        if (set != null) {
            newPlanEntity.setTags(new LinkedHashSet(set));
        }
        newPlanEntity.setSelectionRule(entity.getSelectionRule());
        newPlanEntity.setGeneralConditions(entity.getGeneralConditions());
        newPlanEntity.setOrder(entity.getOrder());
        return newPlanEntity;
    }

    @Override
    public PlanCRD toCRD(io.gravitee.apim.core.plan.model.Plan source) {
        List<String> list1;
        if (source == null) {
            return null;
        }
        PlanCRD.PlanCRDBuilder planCRD = PlanCRD.builder();
        planCRD.security(source.getPlanSecurity());
        planCRD.mode(source.getPlanMode());
        planCRD.status(source.getPlanStatus());
        planCRD.id(source.getId());
        planCRD.crossId(source.getCrossId());
        planCRD.name(source.getName());
        planCRD.description(source.getDescription());
        List<String> list = source.getCharacteristics();
        if (list != null) {
            planCRD.characteristics(new ArrayList<String>(list));
        }
        if ((list1 = source.getExcludedGroups()) != null) {
            planCRD.excludedGroups(new ArrayList<String>(list1));
        }
        planCRD.generalConditions(source.getGeneralConditions());
        planCRD.order(source.getOrder());
        planCRD.type(source.getType());
        planCRD.validation(source.getValidation());
        planCRD.selectionRule(this.serializeSelectionRule(source));
        planCRD.tags(this.serializeTags(source));
        return planCRD.build();
    }

    @Override
    public PlanEntity toEntityV4(PlanCRD source) {
        List<String> list1;
        if (source == null) {
            return null;
        }
        PlanEntity.PlanEntityBuilder planEntity = PlanEntity.builder();
        planEntity.id(source.getId());
        planEntity.crossId(source.getCrossId());
        planEntity.name(source.getName());
        planEntity.description(source.getDescription());
        planEntity.validation(this.planValidationTypeToPlanValidationType2(source.getValidation()));
        planEntity.type(this.planTypeToPlanType2(source.getType()));
        planEntity.mode(source.getMode());
        planEntity.security(source.getSecurity());
        planEntity.selectionRule(source.getSelectionRule());
        Set<String> set = source.getTags();
        if (set != null) {
            planEntity.tags(new LinkedHashSet<String>(set));
        }
        planEntity.status(source.getStatus());
        planEntity.order(source.getOrder());
        List<String> list = source.getCharacteristics();
        if (list != null) {
            planEntity.characteristics(new ArrayList<String>(list));
        }
        if ((list1 = source.getExcludedGroups()) != null) {
            planEntity.excludedGroups(new ArrayList<String>(list1));
        }
        planEntity.generalConditions(source.getGeneralConditions());
        planEntity.flows(this.abstractFlowListToFlowList(source.getFlows()));
        return planEntity.build();
    }

    @Override
    public io.gravitee.definition.model.v4.plan.Plan toApiDefinition(PlanCRD source) {
        if (source == null) {
            return null;
        }
        Plan.PlanBuilder plan = io.gravitee.definition.model.v4.plan.Plan.builder();
        plan.id(source.getId());
        plan.name(source.getName());
        plan.security(source.getSecurity());
        plan.mode(source.getMode());
        plan.selectionRule(source.getSelectionRule());
        Set<String> set = source.getTags();
        if (set != null) {
            plan.tags(new LinkedHashSet<String>(set));
        }
        plan.status(source.getStatus());
        plan.flows(this.abstractFlowListToFlowList1(source.getFlows()));
        return plan.build();
    }

    @Override
    public io.gravitee.definition.model.v4.plan.Plan toPlanDefinitionHttpV4(io.gravitee.repository.management.model.Plan source) {
        if (source == null) {
            return null;
        }
        Plan.PlanBuilder plan = io.gravitee.definition.model.v4.plan.Plan.builder();
        plan.id(source.getId());
        plan.name(source.getName());
        plan.mode(this.planModeToPlanMode1(source.getMode()));
        plan.selectionRule(source.getSelectionRule());
        Set set = source.getTags();
        if (set != null) {
            plan.tags(new LinkedHashSet(set));
        }
        plan.status(this.statusToPlanStatus(source.getStatus()));
        plan.security(this.computeBasePlanEntitySecurityV4(source));
        return plan.build();
    }

    @Override
    public NativePlan toPlanDefinitionNativeV4(io.gravitee.repository.management.model.Plan source) {
        if (source == null) {
            return null;
        }
        NativePlan.NativePlanBuilder nativePlan = NativePlan.builder();
        nativePlan.id(source.getId());
        nativePlan.name(source.getName());
        nativePlan.mode(this.planModeToPlanMode1(source.getMode()));
        nativePlan.selectionRule(source.getSelectionRule());
        Set set = source.getTags();
        if (set != null) {
            nativePlan.tags(new LinkedHashSet(set));
        }
        nativePlan.status(this.statusToPlanStatus(source.getStatus()));
        nativePlan.security(this.computeBasePlanEntitySecurityV4(source));
        return nativePlan.build();
    }

    @Override
    public Plan toPlanDefinitionV2(io.gravitee.repository.management.model.Plan source) {
        if (source == null) {
            return null;
        }
        Plan.PlanBuilder plan = Plan.builder();
        plan.security(this.serializeV2PlanSecurityType(source.getSecurity()));
        plan.id(source.getId());
        plan.name(source.getName());
        plan.securityDefinition(source.getSecurityDefinition());
        plan.api(source.getApi());
        plan.selectionRule(source.getSelectionRule());
        Set set = source.getTags();
        if (set != null) {
            plan.tags(new LinkedHashSet(set));
        }
        if (source.getStatus() != null) {
            plan.status(source.getStatus().name());
        }
        plan.paths(this.computeBasePlanEntityPaths(source));
        return plan.build();
    }

    protected Plan.PlanValidationType planValidationTypeToPlanValidationType(Plan.PlanValidationType planValidationType) {
        if (planValidationType == null) {
            return null;
        }
        return switch (planValidationType) {
            case Plan.PlanValidationType.AUTO -> Plan.PlanValidationType.AUTO;
            case Plan.PlanValidationType.MANUAL -> Plan.PlanValidationType.MANUAL;
            default -> throw new IllegalArgumentException("Unexpected enum constant: " + planValidationType);
        };
    }

    protected Plan.PlanType planTypeToPlanType(Plan.PlanType planType) {
        if (planType == null) {
            return null;
        }
        return switch (planType) {
            case Plan.PlanType.API -> Plan.PlanType.API;
            case Plan.PlanType.CATALOG -> Plan.PlanType.CATALOG;
            default -> throw new IllegalArgumentException("Unexpected enum constant: " + planType);
        };
    }

    private String sourcePlanSecurityConfiguration(io.gravitee.apim.core.plan.model.Plan plan) {
        PlanSecurity planSecurity = plan.getPlanSecurity();
        if (planSecurity == null) {
            return null;
        }
        return planSecurity.getConfiguration();
    }

    protected Plan.PlanMode planModeToPlanMode(PlanMode planMode) {
        if (planMode == null) {
            return null;
        }
        return switch (planMode) {
            case PlanMode.STANDARD -> Plan.PlanMode.STANDARD;
            case PlanMode.PUSH -> Plan.PlanMode.PUSH;
            default -> throw new IllegalArgumentException("Unexpected enum constant: " + planMode);
        };
    }

    protected Plan.Status planStatusToStatus(PlanStatus planStatus) {
        if (planStatus == null) {
            return null;
        }
        return switch (planStatus) {
            case PlanStatus.STAGING -> Plan.Status.STAGING;
            case PlanStatus.PUBLISHED -> Plan.Status.PUBLISHED;
            case PlanStatus.DEPRECATED -> Plan.Status.DEPRECATED;
            case PlanStatus.CLOSED -> Plan.Status.CLOSED;
            default -> throw new IllegalArgumentException("Unexpected enum constant: " + planStatus);
        };
    }

    protected Plan.PlanValidationType planValidationTypeToPlanValidationType1(Plan.PlanValidationType planValidationType) {
        if (planValidationType == null) {
            return null;
        }
        return switch (planValidationType) {
            case Plan.PlanValidationType.AUTO -> Plan.PlanValidationType.AUTO;
            case Plan.PlanValidationType.MANUAL -> Plan.PlanValidationType.MANUAL;
            default -> throw new IllegalArgumentException("Unexpected enum constant: " + planValidationType);
        };
    }

    protected Plan.PlanType planTypeToPlanType1(Plan.PlanType planType) {
        if (planType == null) {
            return null;
        }
        return switch (planType) {
            case Plan.PlanType.API -> Plan.PlanType.API;
            case Plan.PlanType.CATALOG -> Plan.PlanType.CATALOG;
            default -> throw new IllegalArgumentException("Unexpected enum constant: " + planType);
        };
    }

    protected PlanValidationType planValidationTypeToPlanValidationType2(Plan.PlanValidationType planValidationType) {
        if (planValidationType == null) {
            return null;
        }
        return switch (planValidationType) {
            case Plan.PlanValidationType.AUTO -> PlanValidationType.AUTO;
            case Plan.PlanValidationType.MANUAL -> PlanValidationType.MANUAL;
            default -> throw new IllegalArgumentException("Unexpected enum constant: " + planValidationType);
        };
    }

    protected PlanType planTypeToPlanType2(Plan.PlanType planType) {
        if (planType == null) {
            return null;
        }
        return switch (planType) {
            case Plan.PlanType.API -> PlanType.API;
            case Plan.PlanType.CATALOG -> PlanType.CATALOG;
            default -> throw new IllegalArgumentException("Unexpected enum constant: " + planType);
        };
    }

    protected io.gravitee.rest.api.model.PlanStatus planStatusToPlanStatus(PlanStatus planStatus) {
        if (planStatus == null) {
            return null;
        }
        return switch (planStatus) {
            case PlanStatus.STAGING -> io.gravitee.rest.api.model.PlanStatus.STAGING;
            case PlanStatus.PUBLISHED -> io.gravitee.rest.api.model.PlanStatus.PUBLISHED;
            case PlanStatus.DEPRECATED -> io.gravitee.rest.api.model.PlanStatus.DEPRECATED;
            case PlanStatus.CLOSED -> io.gravitee.rest.api.model.PlanStatus.CLOSED;
            default -> throw new IllegalArgumentException("Unexpected enum constant: " + planStatus);
        };
    }

    protected io.gravitee.rest.api.model.PlanValidationType planValidationTypeToPlanValidationType3(Plan.PlanValidationType planValidationType) {
        if (planValidationType == null) {
            return null;
        }
        return switch (planValidationType) {
            case Plan.PlanValidationType.AUTO -> io.gravitee.rest.api.model.PlanValidationType.AUTO;
            case Plan.PlanValidationType.MANUAL -> io.gravitee.rest.api.model.PlanValidationType.MANUAL;
            default -> throw new IllegalArgumentException("Unexpected enum constant: " + planValidationType);
        };
    }

    protected io.gravitee.rest.api.model.PlanType planTypeToPlanType3(Plan.PlanType planType) {
        if (planType == null) {
            return null;
        }
        return switch (planType) {
            case Plan.PlanType.API -> io.gravitee.rest.api.model.PlanType.API;
            case Plan.PlanType.CATALOG -> io.gravitee.rest.api.model.PlanType.CATALOG;
            default -> throw new IllegalArgumentException("Unexpected enum constant: " + planType);
        };
    }

    protected Flow abstractFlowToFlow(AbstractFlow abstractFlow) {
        if (abstractFlow == null) {
            return null;
        }
        Flow.FlowBuilder flow = Flow.builder();
        flow.id(abstractFlow.getId());
        flow.name(abstractFlow.getName());
        flow.enabled(abstractFlow.isEnabled());
        Set set = abstractFlow.getTags();
        if (set != null) {
            flow.tags(new LinkedHashSet(set));
        }
        return flow.build();
    }

    protected List<Flow> abstractFlowListToFlowList(List<? extends AbstractFlow> list) {
        if (list == null) {
            return null;
        }
        ArrayList<Flow> list1 = new ArrayList<Flow>(list.size());
        for (AbstractFlow abstractFlow : list) {
            list1.add(this.abstractFlowToFlow(abstractFlow));
        }
        return list1;
    }

    protected List<Flow> abstractFlowListToFlowList1(List<? extends AbstractFlow> list) {
        if (list == null) {
            return null;
        }
        ArrayList<Flow> list1 = new ArrayList<Flow>(list.size());
        for (AbstractFlow abstractFlow : list) {
            list1.add(this.abstractFlowToFlow(abstractFlow));
        }
        return list1;
    }

    protected PlanMode planModeToPlanMode1(Plan.PlanMode planMode) {
        if (planMode == null) {
            return null;
        }
        return switch (planMode) {
            case Plan.PlanMode.STANDARD -> PlanMode.STANDARD;
            case Plan.PlanMode.PUSH -> PlanMode.PUSH;
            default -> throw new IllegalArgumentException("Unexpected enum constant: " + planMode);
        };
    }

    protected PlanStatus statusToPlanStatus(Plan.Status status) {
        if (status == null) {
            return null;
        }
        return switch (status) {
            case Plan.Status.STAGING -> PlanStatus.STAGING;
            case Plan.Status.PUBLISHED -> PlanStatus.PUBLISHED;
            case Plan.Status.CLOSED -> PlanStatus.CLOSED;
            case Plan.Status.DEPRECATED -> PlanStatus.DEPRECATED;
            default -> throw new IllegalArgumentException("Unexpected enum constant: " + status);
        };
    }
}

