/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.rest.api.service.sanitizer;

import io.gravitee.rest.api.service.exceptions.CustomUserFieldException;
import java.util.regex.Pattern;

public class CustomFieldSanitizer {
    private static final Pattern FIELD_KEY_PATTERN = Pattern.compile("[a-z0-9_\\-]{1,64}");

    public static String formatKeyValue(String key) {
        if (key != null) {
            String lowerCaseKey = key.toLowerCase();
            if (FIELD_KEY_PATTERN.matcher(lowerCaseKey).matches()) {
                return lowerCaseKey;
            }
            throw new CustomUserFieldException(key, "", "Invalid property key");
        }
        return null;
    }
}

