/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.rest.api.service.jackson.ser.api;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.SerializerProvider;
import io.gravitee.rest.api.model.api.ApiEntity;
import io.gravitee.rest.api.service.jackson.ser.api.ApiSerializer;
import java.io.IOException;
import java.util.Collections;
import java.util.List;
import java.util.Map;

public class ApiDefaultSerializer
extends ApiSerializer {
    public ApiDefaultSerializer() {
        super(ApiEntity.class);
    }

    @Override
    public void serialize(ApiEntity apiEntity, JsonGenerator jsonGenerator, SerializerProvider serializerProvider) throws IOException {
        super.serialize(apiEntity, jsonGenerator, serializerProvider);
        List filteredFieldsList = apiEntity.getMetadata().getOrDefault(METADATA_FILTERED_FIELDS_LIST, Collections.emptyList());
        if (apiEntity.getId() != null && !filteredFieldsList.contains("id")) {
            jsonGenerator.writeStringField("id", apiEntity.getId());
        }
        if (apiEntity.getPathMappings() != null) {
            jsonGenerator.writeArrayFieldStart("path_mappings");
            apiEntity.getPathMappings().forEach(pathMapping -> {
                try {
                    jsonGenerator.writeObject(pathMapping);
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            });
            jsonGenerator.writeEndArray();
        }
        if (apiEntity.getProxy() != null) {
            jsonGenerator.writeObjectField("proxy", (Object)apiEntity.getProxy());
        }
        if (apiEntity.getResponseTemplates() != null) {
            jsonGenerator.writeObjectFieldStart("response_templates");
            for (Map.Entry rt : apiEntity.getResponseTemplates().entrySet()) {
                jsonGenerator.writeObjectFieldStart((String)rt.getKey());
                for (Map.Entry entry : ((Map)rt.getValue()).entrySet()) {
                    jsonGenerator.writeObjectField((String)entry.getKey(), entry.getValue());
                }
                jsonGenerator.writeEndObject();
            }
            jsonGenerator.writeEndObject();
        }
        if (apiEntity.getPrimaryOwner() != null) {
            jsonGenerator.writeObjectField("primaryOwner", (Object)apiEntity.getPrimaryOwner());
        }
        jsonGenerator.writeObjectField("disable_membership_notifications", (Object)apiEntity.isDisableMembershipNotifications());
        jsonGenerator.writeEndObject();
    }

    @Override
    public ApiSerializer.Version version() {
        return ApiSerializer.Version.DEFAULT;
    }
}

