/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.rest.api.service.cockpit.command.handler;

import io.gravitee.exchange.api.command.CommandHandler;
import io.gravitee.exchange.api.command.goodbye.GoodByeCommand;
import io.gravitee.exchange.api.command.goodbye.GoodByeCommandPayload;
import io.gravitee.exchange.api.command.goodbye.GoodByeReply;
import io.gravitee.exchange.api.command.goodbye.GoodByeReplyPayload;
import io.gravitee.rest.api.model.promotion.PromotionEntity;
import io.gravitee.rest.api.model.promotion.PromotionEntityStatus;
import io.gravitee.rest.api.model.promotion.PromotionQuery;
import io.gravitee.rest.api.service.InstallationService;
import io.gravitee.rest.api.service.promotion.PromotionService;
import io.reactivex.rxjava3.core.Single;
import java.util.List;
import java.util.Map;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class GoodByeCommandHandler
implements CommandHandler<GoodByeCommand, GoodByeReply> {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(GoodByeCommandHandler.class);
    static final String DELETED_STATUS = "DELETED";
    private final InstallationService installationService;
    private final PromotionService promotionService;

    public String supportType() {
        return "GOOD_BYE";
    }

    public Single<GoodByeReply> handle(GoodByeCommand command) {
        try {
            if (!((GoodByeCommandPayload)command.getPayload()).isReconnect()) {
                Map additionalInformation = this.installationService.getOrInitialize().getAdditionalInformation();
                additionalInformation.put("COCKPIT_INSTALLATION_STATUS", DELETED_STATUS);
                this.rejectAllPromotionToValidate();
                this.installationService.setAdditionalInformation(additionalInformation);
                log.info("Installation status is [{}].", (Object)DELETED_STATUS);
            }
            return Single.just((Object)new GoodByeReply(command.getId(), new GoodByeReplyPayload()));
        }
        catch (Exception ex) {
            String errorDetails = "Error occurred when deleting installation.";
            log.info(errorDetails, (Throwable)ex);
            return Single.just((Object)new GoodByeReply(command.getId(), errorDetails));
        }
    }

    private void rejectAllPromotionToValidate() {
        PromotionQuery promotionQuery = new PromotionQuery();
        promotionQuery.setStatuses(List.of(PromotionEntityStatus.TO_BE_VALIDATED));
        this.promotionService.search(promotionQuery, null, null).getContent().forEach(promotionEntity -> {
            promotionEntity.setStatus(PromotionEntityStatus.REJECTED);
            this.promotionService.createOrUpdate((PromotionEntity)promotionEntity);
        });
    }

    @Generated
    public GoodByeCommandHandler(InstallationService installationService, PromotionService promotionService) {
        this.installationService = installationService;
        this.promotionService = promotionService;
    }
}

