/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.apim.infra.adapter;

import io.gravitee.apim.core.api.model.NewApiMetadata;
import io.gravitee.apim.core.api.model.import_definition.ApiExport;
import io.gravitee.apim.core.api.model.import_definition.ApiMember;
import io.gravitee.apim.core.api.model.import_definition.GraviteeDefinition;
import io.gravitee.apim.core.api.model.import_definition.PageExport;
import io.gravitee.apim.core.api.model.import_definition.PlanExport;
import io.gravitee.apim.core.documentation.model.AccessControl;
import io.gravitee.apim.core.documentation.model.Page;
import io.gravitee.apim.core.documentation.model.PageMedia;
import io.gravitee.apim.core.documentation.model.PageSource;
import io.gravitee.apim.core.media.model.Media;
import io.gravitee.apim.core.metadata.model.Metadata;
import io.gravitee.apim.infra.adapter.GraviteeDefinitionAdapter;
import io.gravitee.apim.infra.adapter.MemberAdapter;
import io.gravitee.rest.api.model.AccessControlEntity;
import io.gravitee.rest.api.model.ApiMetadataEntity;
import io.gravitee.rest.api.model.MediaEntity;
import io.gravitee.rest.api.model.MemberEntity;
import io.gravitee.rest.api.model.MetadataFormat;
import io.gravitee.rest.api.model.PageEntity;
import io.gravitee.rest.api.model.PageMediaEntity;
import io.gravitee.rest.api.model.PageSourceEntity;
import io.gravitee.rest.api.model.Visibility;
import io.gravitee.rest.api.model.v4.api.ExportApiEntity;
import io.gravitee.rest.api.model.v4.api.GenericApiEntity;
import io.gravitee.rest.api.model.v4.plan.GenericPlanEntity;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class GraviteeDefinitionAdapterImpl
implements GraviteeDefinitionAdapter {
    private final MemberAdapter memberAdapter = MemberAdapter.INSTANCE;

    @Override
    public GraviteeDefinition map(ExportApiEntity source) {
        if (source == null) {
            return null;
        }
        GraviteeDefinition.GraviteeDefinitionBuilder graviteeDefinition = GraviteeDefinition.builder();
        graviteeDefinition.api(this.genericApiEntityToApiExport(source.getApiEntity()));
        graviteeDefinition.members(this.memberEntitySetToApiMemberSet(source.getMembers()));
        graviteeDefinition.metadata(this.apiMetadataEntitySetToNewApiMetadataSet(source.getMetadata()));
        graviteeDefinition.pages(this.pageEntityListToPageExportList(source.getPages()));
        graviteeDefinition.plans(this.genericPlanEntitySetToPlanExportSet(source.getPlans()));
        graviteeDefinition.apiMedia(this.mediaEntityListToMediaList(source.getApiMedia()));
        return graviteeDefinition.build();
    }

    protected ApiExport genericApiEntityToApiExport(GenericApiEntity genericApiEntity) {
        List list;
        Set set1;
        if (genericApiEntity == null) {
            return null;
        }
        ApiExport.ApiExportBuilder apiExport = ApiExport.builder();
        apiExport.id(genericApiEntity.getId());
        apiExport.name(genericApiEntity.getName());
        apiExport.apiVersion(genericApiEntity.getApiVersion());
        apiExport.definitionVersion(genericApiEntity.getDefinitionVersion());
        apiExport.description(genericApiEntity.getDescription());
        Set set = genericApiEntity.getTags();
        if (set != null) {
            apiExport.tags(new LinkedHashSet<String>(set));
        }
        if ((set1 = genericApiEntity.getGroups()) != null) {
            apiExport.groups(new LinkedHashSet<String>(set1));
        }
        apiExport.visibility(genericApiEntity.getVisibility());
        apiExport.state(genericApiEntity.getState());
        apiExport.picture(genericApiEntity.getPicture());
        Set set2 = genericApiEntity.getCategories();
        if (set2 != null) {
            apiExport.categories(new LinkedHashSet<String>(set2));
        }
        if ((list = genericApiEntity.getLabels()) != null) {
            apiExport.labels(new ArrayList<String>(list));
        }
        apiExport.originContext(genericApiEntity.getOriginContext());
        apiExport.lifecycleState(genericApiEntity.getLifecycleState());
        apiExport.workflowState(genericApiEntity.getWorkflowState());
        apiExport.disableMembershipNotifications(genericApiEntity.isDisableMembershipNotifications());
        apiExport.background(genericApiEntity.getBackground());
        if (genericApiEntity.getCreatedAt() != null) {
            apiExport.createdAt(genericApiEntity.getCreatedAt().toInstant());
        }
        if (genericApiEntity.getDeployedAt() != null) {
            apiExport.deployedAt(genericApiEntity.getDeployedAt().toInstant());
        }
        if (genericApiEntity.getUpdatedAt() != null) {
            apiExport.updatedAt(genericApiEntity.getUpdatedAt().toInstant());
        }
        return apiExport.build();
    }

    protected Set<ApiMember> memberEntitySetToApiMemberSet(Set<MemberEntity> set) {
        if (set == null) {
            return null;
        }
        LinkedHashSet<ApiMember> set1 = new LinkedHashSet<ApiMember>(Math.max((int)((float)set.size() / 0.75f) + 1, 16));
        for (MemberEntity memberEntity : set) {
            set1.add(this.memberAdapter.toApiMember(memberEntity));
        }
        return set1;
    }

    protected Metadata.MetadataFormat metadataFormatToMetadataFormat(MetadataFormat metadataFormat) {
        if (metadataFormat == null) {
            return null;
        }
        return switch (metadataFormat) {
            case MetadataFormat.STRING -> Metadata.MetadataFormat.STRING;
            case MetadataFormat.NUMERIC -> Metadata.MetadataFormat.NUMERIC;
            case MetadataFormat.BOOLEAN -> Metadata.MetadataFormat.BOOLEAN;
            case MetadataFormat.DATE -> Metadata.MetadataFormat.DATE;
            case MetadataFormat.MAIL -> Metadata.MetadataFormat.MAIL;
            case MetadataFormat.URL -> Metadata.MetadataFormat.URL;
            default -> throw new IllegalArgumentException("Unexpected enum constant: " + metadataFormat);
        };
    }

    protected NewApiMetadata apiMetadataEntityToNewApiMetadata(ApiMetadataEntity apiMetadataEntity) {
        if (apiMetadataEntity == null) {
            return null;
        }
        NewApiMetadata.NewApiMetadataBuilder newApiMetadata = NewApiMetadata.builder();
        newApiMetadata.apiId(apiMetadataEntity.getApiId());
        newApiMetadata.key(apiMetadataEntity.getKey());
        newApiMetadata.name(apiMetadataEntity.getName());
        newApiMetadata.format(this.metadataFormatToMetadataFormat(apiMetadataEntity.getFormat()));
        newApiMetadata.value(apiMetadataEntity.getValue());
        return newApiMetadata.build();
    }

    protected Set<NewApiMetadata> apiMetadataEntitySetToNewApiMetadataSet(Set<ApiMetadataEntity> set) {
        if (set == null) {
            return null;
        }
        LinkedHashSet<NewApiMetadata> set1 = new LinkedHashSet<NewApiMetadata>(Math.max((int)((float)set.size() / 0.75f) + 1, 16));
        for (ApiMetadataEntity apiMetadataEntity : set) {
            set1.add(this.apiMetadataEntityToNewApiMetadata(apiMetadataEntity));
        }
        return set1;
    }

    protected Page.Visibility visibilityToVisibility(Visibility visibility) {
        if (visibility == null) {
            return null;
        }
        return switch (visibility) {
            case Visibility.PUBLIC -> Page.Visibility.PUBLIC;
            case Visibility.PRIVATE -> Page.Visibility.PRIVATE;
            default -> throw new IllegalArgumentException("Unexpected enum constant: " + visibility);
        };
    }

    protected AccessControl accessControlEntityToAccessControl(AccessControlEntity accessControlEntity) {
        if (accessControlEntity == null) {
            return null;
        }
        AccessControl.AccessControlBuilder accessControl = AccessControl.builder();
        accessControl.referenceId(accessControlEntity.getReferenceId());
        accessControl.referenceType(accessControlEntity.getReferenceType());
        return accessControl.build();
    }

    protected Set<AccessControl> accessControlEntitySetToAccessControlSet(Set<AccessControlEntity> set) {
        if (set == null) {
            return null;
        }
        LinkedHashSet<AccessControl> set1 = new LinkedHashSet<AccessControl>(Math.max((int)((float)set.size() / 0.75f) + 1, 16));
        for (AccessControlEntity accessControlEntity : set) {
            set1.add(this.accessControlEntityToAccessControl(accessControlEntity));
        }
        return set1;
    }

    protected PageSource pageSourceEntityToPageSource(PageSourceEntity pageSourceEntity) {
        if (pageSourceEntity == null) {
            return null;
        }
        PageSource.PageSourceBuilder pageSource = PageSource.builder();
        pageSource.type(pageSourceEntity.getType());
        pageSource.configuration(pageSourceEntity.getConfiguration());
        return pageSource.build();
    }

    protected PageMedia pageMediaEntityToPageMedia(PageMediaEntity pageMediaEntity) {
        if (pageMediaEntity == null) {
            return null;
        }
        PageMedia.PageMediaBuilder pageMedia = PageMedia.builder();
        pageMedia.mediaHash(pageMediaEntity.getMediaHash());
        pageMedia.mediaName(pageMediaEntity.getMediaName());
        pageMedia.attachedAt(pageMediaEntity.getAttachedAt());
        return pageMedia.build();
    }

    protected List<PageMedia> pageMediaEntityListToPageMediaList(List<PageMediaEntity> list) {
        if (list == null) {
            return null;
        }
        ArrayList<PageMedia> list1 = new ArrayList<PageMedia>(list.size());
        for (PageMediaEntity pageMediaEntity : list) {
            list1.add(this.pageMediaEntityToPageMedia(pageMediaEntity));
        }
        return list1;
    }

    protected PageExport pageEntityToPageExport(PageEntity pageEntity) {
        Map map1;
        if (pageEntity == null) {
            return null;
        }
        PageExport.PageExportBuilder pageExport = PageExport.builder();
        pageExport.id(pageEntity.getId());
        pageExport.crossId(pageEntity.getCrossId());
        pageExport.referenceId(pageEntity.getReferenceId());
        if (pageEntity.getReferenceType() != null) {
            pageExport.referenceType(Enum.valueOf(Page.ReferenceType.class, pageEntity.getReferenceType()));
        }
        pageExport.name(pageEntity.getName());
        if (pageEntity.getType() != null) {
            pageExport.type(Enum.valueOf(Page.Type.class, pageEntity.getType()));
        }
        pageExport.lastContributor(pageEntity.getLastContributor());
        pageExport.order(pageEntity.getOrder());
        pageExport.published(pageEntity.isPublished());
        pageExport.visibility(this.visibilityToVisibility(pageEntity.getVisibility()));
        pageExport.parentId(pageEntity.getParentId());
        pageExport.excludedAccessControls(pageEntity.isExcludedAccessControls());
        pageExport.accessControls(this.accessControlEntitySetToAccessControlSet(pageEntity.getAccessControls()));
        pageExport.content(pageEntity.getContent());
        pageExport.homepage(pageEntity.isHomepage());
        pageExport.generalConditions(pageEntity.isGeneralConditions());
        pageExport.source(this.pageSourceEntityToPageSource(pageEntity.getSource()));
        Map map = pageEntity.getConfiguration();
        if (map != null) {
            pageExport.configuration(new LinkedHashMap<String, String>(map));
        }
        if ((map1 = pageEntity.getMetadata()) != null) {
            pageExport.metadata(new LinkedHashMap<String, String>(map1));
        }
        pageExport.attachedMedia(this.pageMediaEntityListToPageMediaList(pageEntity.getAttachedMedia()));
        return pageExport.build();
    }

    protected List<PageExport> pageEntityListToPageExportList(List<PageEntity> list) {
        if (list == null) {
            return null;
        }
        ArrayList<PageExport> list1 = new ArrayList<PageExport>(list.size());
        for (PageEntity pageEntity : list) {
            list1.add(this.pageEntityToPageExport(pageEntity));
        }
        return list1;
    }

    protected PlanExport genericPlanEntityToPlanExport(GenericPlanEntity genericPlanEntity) {
        List list1;
        if (genericPlanEntity == null) {
            return null;
        }
        PlanExport.PlanExportBuilder planExport = PlanExport.builder();
        planExport.id(genericPlanEntity.getId());
        planExport.name(genericPlanEntity.getName());
        planExport.definitionVersion(genericPlanEntity.getDefinitionVersion());
        planExport.description(genericPlanEntity.getDescription());
        planExport.apiId(genericPlanEntity.getApiId());
        planExport.environmentId(genericPlanEntity.getEnvironmentId());
        planExport.order(genericPlanEntity.getOrder());
        List list = genericPlanEntity.getCharacteristics();
        if (list != null) {
            planExport.characteristics(new ArrayList<String>(list));
        }
        if ((list1 = genericPlanEntity.getExcludedGroups()) != null) {
            planExport.excludedGroups(new ArrayList<String>(list1));
        }
        planExport.commentRequired(genericPlanEntity.isCommentRequired());
        planExport.commentMessage(genericPlanEntity.getCommentMessage());
        planExport.generalConditions(genericPlanEntity.getGeneralConditions());
        return planExport.build();
    }

    protected Set<PlanExport> genericPlanEntitySetToPlanExportSet(Set<? extends GenericPlanEntity> set) {
        if (set == null) {
            return null;
        }
        LinkedHashSet<PlanExport> set1 = new LinkedHashSet<PlanExport>(Math.max((int)((float)set.size() / 0.75f) + 1, 16));
        for (GenericPlanEntity genericPlanEntity : set) {
            set1.add(this.genericPlanEntityToPlanExport(genericPlanEntity));
        }
        return set1;
    }

    protected Media mediaEntityToMedia(MediaEntity mediaEntity) {
        if (mediaEntity == null) {
            return null;
        }
        Media.MediaBuilder media = Media.builder();
        media.id(mediaEntity.getId());
        media.hash(mediaEntity.getHash());
        media.type(mediaEntity.getType());
        media.subType(mediaEntity.getSubType());
        media.fileName(mediaEntity.getFileName());
        media.size(mediaEntity.getSize());
        byte[] data = mediaEntity.getData();
        if (data != null) {
            media.data(Arrays.copyOf(data, data.length));
        }
        return media.build();
    }

    protected List<Media> mediaEntityListToMediaList(List<MediaEntity> list) {
        if (list == null) {
            return null;
        }
        ArrayList<Media> list1 = new ArrayList<Media>(list.size());
        for (MediaEntity mediaEntity : list) {
            list1.add(this.mediaEntityToMedia(mediaEntity));
        }
        return list1;
    }
}

