/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.apim.core.portal_menu_link.use_case;

import io.gravitee.apim.core.UseCase;
import io.gravitee.apim.core.portal_menu_link.crud_service.PortalMenuLinkCrudService;
import io.gravitee.apim.core.portal_menu_link.model.PortalMenuLink;
import io.gravitee.apim.core.portal_menu_link.model.UpdatePortalMenuLink;
import io.gravitee.apim.core.portal_menu_link.query_service.PortalMenuLinkQueryService;
import io.gravitee.rest.api.service.exceptions.InvalidDataException;
import java.util.Objects;
import lombok.Generated;

@UseCase
public class UpdatePortalMenuLinkUseCase {
    private final PortalMenuLinkCrudService portalMenuLinkCrudService;
    private final PortalMenuLinkQueryService portalMenuLinkQueryService;

    public Output execute(Input input) {
        PortalMenuLink existingPortalMenuLink = this.portalMenuLinkCrudService.getByIdAndEnvironmentId(input.portalMenuLinkId(), input.environmentId());
        PortalMenuLink portalMenuLinkToUpdate = existingPortalMenuLink.update(input.portalMenuLinkToUpdate());
        this.validatePortalMenuLinkToUpdate(portalMenuLinkToUpdate);
        PortalMenuLink updatedPortalMenuLink = this.portalMenuLinkCrudService.update(portalMenuLinkToUpdate);
        if (existingPortalMenuLink.getOrder() != updatedPortalMenuLink.getOrder()) {
            this.updatePortalMenuLinkOrder(existingPortalMenuLink.getOrder(), updatedPortalMenuLink);
        }
        return new Output(updatedPortalMenuLink);
    }

    private void updatePortalMenuLinkOrder(int oldOrder, PortalMenuLink updatedPortalMenuLink) {
        int newOrder = updatedPortalMenuLink.getOrder();
        boolean shouldMoveDown = newOrder < oldOrder;
        int orderIncrement = shouldMoveDown ? 1 : -1;
        this.portalMenuLinkQueryService.findByEnvironmentIdSortByOrder(updatedPortalMenuLink.getEnvironmentId()).stream().filter(menuLink -> !Objects.equals(menuLink.getId(), updatedPortalMenuLink.getId())).filter(menuLink -> shouldMoveDown ? this.toBeMovedDown(oldOrder, newOrder, menuLink.getOrder()) : this.toBeMovedUp(oldOrder, newOrder, menuLink.getOrder())).forEach(menuLink -> {
            int updatedOrder = menuLink.getOrder() + orderIncrement;
            this.portalMenuLinkCrudService.update(menuLink.toBuilder().order(updatedOrder).build());
        });
    }

    private boolean toBeMovedUp(int oldOrder, int newOrder, int portalMenuLinkOrder) {
        return oldOrder < portalMenuLinkOrder && portalMenuLinkOrder <= newOrder;
    }

    private boolean toBeMovedDown(int oldOrder, int newOrder, int portalMenuLinkOrder) {
        return newOrder <= portalMenuLinkOrder && portalMenuLinkOrder < oldOrder;
    }

    private void validatePortalMenuLinkToUpdate(PortalMenuLink portalMenuLinkToUpdate) {
        if (portalMenuLinkToUpdate.getName() == null || portalMenuLinkToUpdate.getName().isEmpty()) {
            throw new InvalidDataException("Name is required.");
        }
    }

    @Generated
    public UpdatePortalMenuLinkUseCase(PortalMenuLinkCrudService portalMenuLinkCrudService, PortalMenuLinkQueryService portalMenuLinkQueryService) {
        this.portalMenuLinkCrudService = portalMenuLinkCrudService;
        this.portalMenuLinkQueryService = portalMenuLinkQueryService;
    }

    public record Input(String portalMenuLinkId, String environmentId, UpdatePortalMenuLink portalMenuLinkToUpdate) {
        @Generated
        public static InputBuilder builder() {
            return new InputBuilder();
        }

        @Generated
        public static class InputBuilder {
            @Generated
            private String portalMenuLinkId;
            @Generated
            private String environmentId;
            @Generated
            private UpdatePortalMenuLink portalMenuLinkToUpdate;

            @Generated
            InputBuilder() {
            }

            @Generated
            public InputBuilder portalMenuLinkId(String portalMenuLinkId) {
                this.portalMenuLinkId = portalMenuLinkId;
                return this;
            }

            @Generated
            public InputBuilder environmentId(String environmentId) {
                this.environmentId = environmentId;
                return this;
            }

            @Generated
            public InputBuilder portalMenuLinkToUpdate(UpdatePortalMenuLink portalMenuLinkToUpdate) {
                this.portalMenuLinkToUpdate = portalMenuLinkToUpdate;
                return this;
            }

            @Generated
            public Input build() {
                return new Input(this.portalMenuLinkId, this.environmentId, this.portalMenuLinkToUpdate);
            }

            @Generated
            public String toString() {
                return "UpdatePortalMenuLinkUseCase.Input.InputBuilder(portalMenuLinkId=" + this.portalMenuLinkId + ", environmentId=" + this.environmentId + ", portalMenuLinkToUpdate=" + this.portalMenuLinkToUpdate + ")";
            }
        }
    }

    public record Output(PortalMenuLink portalMenuLinkEntity) {
    }
}

