/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.apim.core.analytics.use_case;

import io.gravitee.apim.core.UseCase;
import io.gravitee.apim.core.analytics.model.AnalyticsQueryParameters;
import io.gravitee.apim.core.analytics.query_service.AnalyticsQueryService;
import io.gravitee.apim.core.api.model.Api;
import io.gravitee.apim.core.api.model.ApiFieldFilter;
import io.gravitee.apim.core.api.model.ApiSearchCriteria;
import io.gravitee.apim.core.api.query_service.ApiQueryService;
import io.gravitee.definition.model.DefinitionVersion;
import io.gravitee.rest.api.model.v4.analytics.RequestResponseTime;
import io.gravitee.rest.api.service.common.ExecutionContext;
import java.util.List;
import java.util.Optional;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@UseCase
public class SearchEnvironmentRequestResponseTimeUseCase {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(SearchEnvironmentRequestResponseTimeUseCase.class);
    private final ApiQueryService apiQueryService;
    private final AnalyticsQueryService analyticsQueryService;

    public Output execute(Input input) {
        String envId = input.executionContext().getEnvironmentId();
        List<String> v4Apis = this.getAllV4ApisIdsForEnv(envId);
        log.info("Searching Request Response Time, found: {} v4 APIs for env: {}", (Object)v4Apis.size(), (Object)envId);
        RequestResponseTime requestResponseTime = this.analyticsQueryService.searchRequestResponseTime(input.executionContext(), input.parameters().withApiIds(v4Apis));
        return new Output(requestResponseTime);
    }

    private List<String> getAllV4ApisIdsForEnv(String envId) {
        return this.apiQueryService.search(ApiSearchCriteria.builder().environmentId(envId).definitionVersion(List.of(DefinitionVersion.V4)).build(), null, ApiFieldFilter.builder().pictureExcluded(true).definitionExcluded(true).build()).map(Api::getId).toList();
    }

    @Generated
    public SearchEnvironmentRequestResponseTimeUseCase(ApiQueryService apiQueryService, AnalyticsQueryService analyticsQueryService) {
        this.apiQueryService = apiQueryService;
        this.analyticsQueryService = analyticsQueryService;
    }

    public record Input(ExecutionContext executionContext, AnalyticsQueryParameters parameters) {
        @Generated
        public static InputBuilder builder() {
            return new InputBuilder();
        }

        @Generated
        public static class InputBuilder {
            @Generated
            private ExecutionContext executionContext;
            @Generated
            private AnalyticsQueryParameters parameters;

            @Generated
            InputBuilder() {
            }

            @Generated
            public InputBuilder executionContext(ExecutionContext executionContext) {
                this.executionContext = executionContext;
                return this;
            }

            @Generated
            public InputBuilder parameters(AnalyticsQueryParameters parameters) {
                this.parameters = parameters;
                return this;
            }

            @Generated
            public Input build() {
                return new Input(this.executionContext, this.parameters);
            }

            @Generated
            public String toString() {
                return "SearchEnvironmentRequestResponseTimeUseCase.Input.InputBuilder(executionContext=" + this.executionContext + ", parameters=" + this.parameters + ")";
            }
        }
    }

    public record Output(Optional<RequestResponseTime> requestResponseTime) {
        Output(RequestResponseTime requestResponseTime) {
            this(Optional.of(requestResponseTime));
        }
    }
}

