/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.apim.core.documentation.domain_service;

import io.gravitee.apim.core.DomainService;
import io.gravitee.apim.core.api.model.Api;
import io.gravitee.apim.core.documentation.exception.ApiPageNotAssociatedException;
import io.gravitee.apim.core.documentation.model.Page;
import io.gravitee.apim.core.documentation.query_service.PageQueryService;
import io.gravitee.apim.core.exception.ValidationDomainException;
import io.gravitee.apim.core.plan.model.Plan;
import io.gravitee.apim.core.plan.query_service.PlanQueryService;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import lombok.Generated;

@DomainService
public class ApiDocumentationDomainService {
    private static final String ROOT = "ROOT";
    private final PageQueryService pageQueryService;
    private final PlanQueryService planQueryService;

    public List<Page> getApiPages(String apiId, String parentId) {
        if (Objects.nonNull(parentId) && !parentId.isEmpty()) {
            String parentIdParam = ROOT.equals(parentId) ? null : parentId;
            return this.pageQueryService.searchByApiIdAndParentId(apiId, parentIdParam);
        }
        return this.pageQueryService.searchByApiId(apiId);
    }

    public void validatePageAssociatedToApi(Page page, String apiId) {
        if (!Objects.equals(page.getReferenceId(), apiId) || !Page.ReferenceType.API.equals((Object)page.getReferenceType())) {
            throw new ApiPageNotAssociatedException(apiId, page.getId());
        }
    }

    public void validateNameIsUnique(String apiId, String parentId, String name, Page.Type type) {
        Optional<Page> foundPage = this.pageQueryService.findByApiIdAndParentIdAndNameAndType(apiId, parentId, name, type);
        if (foundPage.isPresent()) {
            throw new ValidationDomainException("Name already exists with the same parent and type: " + name);
        }
    }

    public Boolean pageIsHidden(Page page) {
        if (page.isFolder()) {
            long publishedChildren = this.pageQueryService.countByParentIdAndIsPublished(page.getId());
            return publishedChildren <= 0L;
        }
        return null;
    }

    public Boolean pageIsUsedAsGeneralConditions(Page page, Api api) {
        if (page.isFolder()) {
            return null;
        }
        List<Plan> results = this.planQueryService.findAllByApiIdAndGeneralConditionsAndIsActive(api.getId(), api.getDefinitionVersion(), page.getId());
        return !results.isEmpty();
    }

    @Generated
    public ApiDocumentationDomainService(PageQueryService pageQueryService, PlanQueryService planQueryService) {
        this.pageQueryService = pageQueryService;
        this.planQueryService = planQueryService;
    }
}

