/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.rest.api.service.impl.upgrade.upgrader;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ObjectNode;
import io.gravitee.definition.model.DefinitionVersion;
import io.gravitee.definition.model.v4.Api;
import io.gravitee.definition.model.v4.endpointgroup.Endpoint;
import io.gravitee.definition.model.v4.endpointgroup.EndpointGroup;
import io.gravitee.node.api.upgrader.Upgrader;
import io.gravitee.repository.management.api.ApiRepository;
import io.gravitee.repository.management.api.EnvironmentRepository;
import io.gravitee.repository.management.api.search.ApiCriteria;
import io.gravitee.repository.management.api.search.ApiFieldFilter;
import io.gravitee.repository.management.model.Environment;
import io.gravitee.rest.api.service.common.ExecutionContext;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Component;

@Component
public class ApiEndpointWeightUpgrader
implements Upgrader {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ApiEndpointWeightUpgrader.class);
    @Lazy
    @Autowired
    private ApiRepository apiRepository;
    @Lazy
    @Autowired
    private EnvironmentRepository environmentRepository;
    @Autowired
    private ObjectMapper objectMapper;
    private final List<String> apisUpdated = new ArrayList<String>();

    public int getOrder() {
        return 560;
    }

    public boolean upgrade() {
        try {
            for (Environment env : this.environmentRepository.findAll()) {
                this.fixApiEndpointWeights(new ExecutionContext(env));
            }
            if (!this.apisUpdated.isEmpty()) {
                log.info("{} updated {} APIs: {}", new Object[]{this.getClass().getSimpleName(), this.apisUpdated.size(), this.apisUpdated});
            }
            return true;
        }
        catch (Exception e) {
            log.error("Error applying {}", (Object)this.getClass().getSimpleName(), (Object)e);
            return false;
        }
    }

    private void fixApiEndpointWeights(ExecutionContext ctx) {
        this.apiRepository.search(this.getDefaultApiCriteriaBuilder().environmentId(ctx.getEnvironmentId()).build(), null, new ApiFieldFilter.Builder().excludePicture().build()).forEach(api -> {
            try {
                JsonNode rootNode;
                DefinitionVersion defVersion = api.getDefinitionVersion();
                if (defVersion == DefinitionVersion.V1) {
                    return;
                }
                if (defVersion == null) {
                    defVersion = DefinitionVersion.V2;
                }
                String definition = api.getDefinition();
                boolean updated = false;
                if (defVersion == DefinitionVersion.V4) {
                    Api v4Api = (Api)this.objectMapper.readValue(definition, Api.class);
                    updated = this.fixEndpointWeightsV4(v4Api);
                    if (updated) {
                        api.setDefinition(this.objectMapper.writeValueAsString((Object)v4Api));
                    }
                } else if (defVersion != DefinitionVersion.FEDERATED && (updated = this.fixEndpointWeightsV2(rootNode = this.objectMapper.readTree(definition)))) {
                    api.setDefinition(this.objectMapper.writeValueAsString((Object)rootNode));
                }
                if (updated) {
                    api.setUpdatedAt(new Date());
                    this.apiRepository.update(api);
                    this.apisUpdated.add(api.getId());
                }
            }
            catch (Exception e) {
                log.warn("Skipping API [{}] due to error: {}", new Object[]{api.getId(), e.getMessage(), e});
            }
        });
    }

    private boolean fixEndpointWeightsV2(JsonNode root) {
        boolean updated = false;
        for (JsonNode group : root.at("/proxy/groups")) {
            JsonNode endpoints = group.get("endpoints");
            if (endpoints == null || !endpoints.isArray()) continue;
            for (JsonNode endpoint : endpoints) {
                JsonNode weightNode = endpoint.get("weight");
                if (weightNode == null || !weightNode.isInt() || weightNode.intValue() >= 1) continue;
                ((ObjectNode)endpoint).put("weight", 1);
                updated = true;
            }
        }
        return updated;
    }

    private boolean fixEndpointWeightsV4(Api v4Api) {
        boolean updated = false;
        if (v4Api.getEndpointGroups() == null) {
            return false;
        }
        for (EndpointGroup group : v4Api.getEndpointGroups()) {
            for (Endpoint ep : group.getEndpoints()) {
                int weight = ep.getWeight();
                if (weight >= 1) continue;
                ep.setWeight(1);
                updated = true;
            }
        }
        return updated;
    }

    private ApiCriteria.Builder getDefaultApiCriteriaBuilder() {
        return new ApiCriteria.Builder().definitionVersion(Arrays.asList(null, DefinitionVersion.V1, DefinitionVersion.V2, DefinitionVersion.V4));
    }
}

