/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.rest.api.service.impl;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.google.common.base.Strings;
import io.gravitee.apim.core.api.domain_service.VerifyApiPathDomainService;
import io.gravitee.apim.core.api.exception.InvalidPathsException;
import io.gravitee.apim.core.api.model.Path;
import io.gravitee.apim.core.validation.Validator;
import io.gravitee.common.data.domain.Page;
import io.gravitee.common.util.DataEncryptor;
import io.gravitee.definition.model.Api;
import io.gravitee.definition.model.DefinitionContext;
import io.gravitee.definition.model.DefinitionVersion;
import io.gravitee.definition.model.Endpoint;
import io.gravitee.definition.model.EndpointGroup;
import io.gravitee.definition.model.Logging;
import io.gravitee.definition.model.LoggingMode;
import io.gravitee.definition.model.Origin;
import io.gravitee.definition.model.Policy;
import io.gravitee.definition.model.Proxy;
import io.gravitee.definition.model.Rule;
import io.gravitee.definition.model.VirtualHost;
import io.gravitee.definition.model.flow.Flow;
import io.gravitee.definition.model.flow.Step;
import io.gravitee.definition.model.plugins.resources.Resource;
import io.gravitee.definition.model.services.discovery.EndpointDiscoveryService;
import io.gravitee.definition.model.services.healthcheck.HealthCheckService;
import io.gravitee.repository.exceptions.TechnicalException;
import io.gravitee.repository.management.api.ApiQualityRuleRepository;
import io.gravitee.repository.management.api.ApiRepository;
import io.gravitee.repository.management.api.EventLatestRepository;
import io.gravitee.repository.management.api.search.ApiCriteria;
import io.gravitee.repository.management.api.search.ApiFieldFilter;
import io.gravitee.repository.management.api.search.EventCriteria;
import io.gravitee.repository.management.api.search.builder.PageableBuilder;
import io.gravitee.repository.management.model.Api;
import io.gravitee.repository.management.model.ApiLifecycleState;
import io.gravitee.repository.management.model.Audit;
import io.gravitee.repository.management.model.Event;
import io.gravitee.repository.management.model.EventType;
import io.gravitee.repository.management.model.GroupEvent;
import io.gravitee.repository.management.model.LifecycleState;
import io.gravitee.repository.management.model.NotificationReferenceType;
import io.gravitee.repository.management.model.Visibility;
import io.gravitee.repository.management.model.Workflow;
import io.gravitee.repository.management.model.flow.FlowReferenceType;
import io.gravitee.rest.api.model.ApiMetadataEntity;
import io.gravitee.rest.api.model.BasePlanEntity;
import io.gravitee.rest.api.model.EventEntity;
import io.gravitee.rest.api.model.EventQuery;
import io.gravitee.rest.api.model.GroupEntity;
import io.gravitee.rest.api.model.ImportSwaggerDescriptorEntity;
import io.gravitee.rest.api.model.InlinePictureEntity;
import io.gravitee.rest.api.model.MembershipEntity;
import io.gravitee.rest.api.model.MembershipMemberType;
import io.gravitee.rest.api.model.MembershipReferenceType;
import io.gravitee.rest.api.model.MetadataFormat;
import io.gravitee.rest.api.model.NewApiMetadataEntity;
import io.gravitee.rest.api.model.PageEntity;
import io.gravitee.rest.api.model.PageType;
import io.gravitee.rest.api.model.PlanEntity;
import io.gravitee.rest.api.model.PlanStatus;
import io.gravitee.rest.api.model.PolicyEntity;
import io.gravitee.rest.api.model.PrimaryOwnerEntity;
import io.gravitee.rest.api.model.PropertiesEntity;
import io.gravitee.rest.api.model.PropertyEntity;
import io.gravitee.rest.api.model.ReviewEntity;
import io.gravitee.rest.api.model.SubscriptionEntity;
import io.gravitee.rest.api.model.TagReferenceType;
import io.gravitee.rest.api.model.UpdateApiMetadataEntity;
import io.gravitee.rest.api.model.UserEntity;
import io.gravitee.rest.api.model.WorkflowReferenceType;
import io.gravitee.rest.api.model.WorkflowState;
import io.gravitee.rest.api.model.WorkflowType;
import io.gravitee.rest.api.model.alert.AlertReferenceType;
import io.gravitee.rest.api.model.alert.AlertTriggerEntity;
import io.gravitee.rest.api.model.api.ApiDeploymentEntity;
import io.gravitee.rest.api.model.api.ApiEntity;
import io.gravitee.rest.api.model.api.ApiEntrypointEntity;
import io.gravitee.rest.api.model.api.ApiQuery;
import io.gravitee.rest.api.model.api.NewApiEntity;
import io.gravitee.rest.api.model.api.RollbackApiEntity;
import io.gravitee.rest.api.model.api.SwaggerApiEntity;
import io.gravitee.rest.api.model.api.UpdateApiEntity;
import io.gravitee.rest.api.model.api.header.ApiHeaderEntity;
import io.gravitee.rest.api.model.common.Pageable;
import io.gravitee.rest.api.model.common.PageableImpl;
import io.gravitee.rest.api.model.common.Sortable;
import io.gravitee.rest.api.model.notification.GenericNotificationConfigEntity;
import io.gravitee.rest.api.model.parameters.Key;
import io.gravitee.rest.api.model.parameters.ParameterReferenceType;
import io.gravitee.rest.api.model.permissions.ApiPermission;
import io.gravitee.rest.api.model.permissions.Permission;
import io.gravitee.rest.api.model.permissions.RolePermissionAction;
import io.gravitee.rest.api.model.permissions.RoleScope;
import io.gravitee.rest.api.model.permissions.SystemRole;
import io.gravitee.rest.api.model.search.Indexable;
import io.gravitee.rest.api.model.settings.ApiPrimaryOwnerMode;
import io.gravitee.rest.api.model.v4.api.GenericApiEntity;
import io.gravitee.rest.api.model.v4.api.GenericApiModel;
import io.gravitee.rest.api.service.AlertService;
import io.gravitee.rest.api.service.ApiDuplicatorService;
import io.gravitee.rest.api.service.ApiHeaderService;
import io.gravitee.rest.api.service.ApiMetadataService;
import io.gravitee.rest.api.service.ApiService;
import io.gravitee.rest.api.service.AuditService;
import io.gravitee.rest.api.service.CategoryService;
import io.gravitee.rest.api.service.ConnectorService;
import io.gravitee.rest.api.service.EmailRecipientsService;
import io.gravitee.rest.api.service.EmailService;
import io.gravitee.rest.api.service.EnvironmentService;
import io.gravitee.rest.api.service.EventService;
import io.gravitee.rest.api.service.GenericNotificationConfigService;
import io.gravitee.rest.api.service.GroupService;
import io.gravitee.rest.api.service.MediaService;
import io.gravitee.rest.api.service.MembershipService;
import io.gravitee.rest.api.service.NotifierService;
import io.gravitee.rest.api.service.PageService;
import io.gravitee.rest.api.service.ParameterService;
import io.gravitee.rest.api.service.PlanService;
import io.gravitee.rest.api.service.PolicyService;
import io.gravitee.rest.api.service.PortalNotificationConfigService;
import io.gravitee.rest.api.service.ResourceService;
import io.gravitee.rest.api.service.RoleService;
import io.gravitee.rest.api.service.SubscriptionService;
import io.gravitee.rest.api.service.SwaggerService;
import io.gravitee.rest.api.service.TagService;
import io.gravitee.rest.api.service.TopApiService;
import io.gravitee.rest.api.service.UserService;
import io.gravitee.rest.api.service.V4EmulationEngineService;
import io.gravitee.rest.api.service.WorkflowService;
import io.gravitee.rest.api.service.builder.EmailNotificationBuilder;
import io.gravitee.rest.api.service.common.ExecutionContext;
import io.gravitee.rest.api.service.common.UuidString;
import io.gravitee.rest.api.service.configuration.flow.FlowService;
import io.gravitee.rest.api.service.converter.ApiConverter;
import io.gravitee.rest.api.service.converter.CategoryMapper;
import io.gravitee.rest.api.service.exceptions.ApiAlreadyExistsException;
import io.gravitee.rest.api.service.exceptions.ApiDefinitionVersionNotSupportedException;
import io.gravitee.rest.api.service.exceptions.ApiMetadataNotFoundException;
import io.gravitee.rest.api.service.exceptions.ApiNotDeletableException;
import io.gravitee.rest.api.service.exceptions.ApiNotFoundException;
import io.gravitee.rest.api.service.exceptions.ApiRunningStateException;
import io.gravitee.rest.api.service.exceptions.DefinitionVersionException;
import io.gravitee.rest.api.service.exceptions.EndpointGroupNameAlreadyExistsException;
import io.gravitee.rest.api.service.exceptions.EndpointMissingException;
import io.gravitee.rest.api.service.exceptions.EndpointNameAlreadyExistsException;
import io.gravitee.rest.api.service.exceptions.EndpointNameInvalidException;
import io.gravitee.rest.api.service.exceptions.GroupsNotFoundException;
import io.gravitee.rest.api.service.exceptions.InvalidDataException;
import io.gravitee.rest.api.service.exceptions.LifecycleStateChangeNotAllowedException;
import io.gravitee.rest.api.service.exceptions.PaginationInvalidException;
import io.gravitee.rest.api.service.exceptions.TagNotAllowedException;
import io.gravitee.rest.api.service.exceptions.TechnicalManagementException;
import io.gravitee.rest.api.service.impl.AbstractService;
import io.gravitee.rest.api.service.impl.search.SearchResult;
import io.gravitee.rest.api.service.jackson.ser.api.ApiSerializer;
import io.gravitee.rest.api.service.migration.APIV1toAPIV2Converter;
import io.gravitee.rest.api.service.notification.ApiHook;
import io.gravitee.rest.api.service.notification.HookScope;
import io.gravitee.rest.api.service.notification.NotificationParamsBuilder;
import io.gravitee.rest.api.service.notification.NotificationTemplateService;
import io.gravitee.rest.api.service.processor.SynchronizationService;
import io.gravitee.rest.api.service.search.SearchEngineService;
import io.gravitee.rest.api.service.search.query.Query;
import io.gravitee.rest.api.service.search.query.QueryBuilder;
import io.gravitee.rest.api.service.v4.ApiAuthorizationService;
import io.gravitee.rest.api.service.v4.ApiCategoryService;
import io.gravitee.rest.api.service.v4.ApiEntrypointService;
import io.gravitee.rest.api.service.v4.ApiNotificationService;
import io.gravitee.rest.api.service.v4.ApiSearchService;
import io.gravitee.rest.api.service.v4.ApiTemplateService;
import io.gravitee.rest.api.service.v4.PrimaryOwnerService;
import io.gravitee.rest.api.service.v4.exception.InvalidPathException;
import io.gravitee.rest.api.service.v4.validation.AnalyticsValidationService;
import io.gravitee.rest.api.service.v4.validation.CorsValidationService;
import io.gravitee.rest.api.service.v4.validation.TagsValidationService;
import jakarta.xml.bind.DatatypeConverter;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.security.GeneralSecurityException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.function.Predicate;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import lombok.Generated;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Lazy;
import org.springframework.scheduling.support.CronTrigger;
import org.springframework.stereotype.Component;

@Component
public class ApiServiceImpl
extends AbstractService
implements ApiService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ApiServiceImpl.class);
    public static final String API_DEFINITION_CONTEXT_FIELD = "definition_context";
    public static final String API_DEFINITION_CONTEXT_FIELD_ORIGIN = "origin";
    public static final String API_DEFINITION_CONTEXT_FIELD_MODE = "mode";
    public static final String API_DEFINITION_CONTEXT_FIELD_SYNC_FROM = "syncFrom";
    private static final String ENDPOINTS_DELIMITER = "\n";
    @Lazy
    @Autowired
    private ApiRepository apiRepository;
    @Lazy
    @Autowired
    private ApiQualityRuleRepository apiQualityRuleRepository;
    @Autowired
    private ObjectMapper objectMapper;
    @Autowired
    private EventService eventService;
    @Lazy
    @Autowired
    private EventLatestRepository eventLatestRepository;
    @Autowired
    private UserService userService;
    @Autowired
    private PageService pageService;
    @Autowired
    private MembershipService membershipService;
    @Autowired
    private GroupService groupService;
    @Autowired
    private PlanService planService;
    @Autowired
    private SynchronizationService synchronizationService;
    @Autowired
    private ApiMetadataService apiMetadataService;
    @Autowired
    private SubscriptionService subscriptionService;
    @Autowired
    private AuditService auditService;
    @Autowired
    private TopApiService topApiService;
    @Autowired
    private GenericNotificationConfigService genericNotificationConfigService;
    @Autowired
    private PortalNotificationConfigService portalNotificationConfigService;
    @Autowired
    private NotifierService notifierService;
    @Autowired
    private SwaggerService swaggerService;
    @Autowired
    private SearchEngineService searchEngineService;
    @Autowired
    private ApiHeaderService apiHeaderService;
    @Autowired
    private NotificationTemplateService notificationTemplateService;
    @Autowired
    private ParameterService parameterService;
    @Autowired
    private TagService tagService;
    @Autowired
    private WorkflowService workflowService;
    @Autowired
    private VerifyApiPathDomainService verifyApiPathDomainService;
    @Autowired
    private AlertService alertService;
    @Autowired
    private RoleService roleService;
    @Autowired
    private CategoryService categoryService;
    @Autowired
    private ApiCategoryService apiCategoryService;
    @Autowired
    private PolicyService policyService;
    @Autowired
    private MediaService mediaService;
    @Autowired
    private EmailService emailService;
    @Autowired
    private APIV1toAPIV2Converter apiv1toAPIV2Converter;
    @Autowired
    private DataEncryptor dataEncryptor;
    @Autowired
    @Lazy
    private ApiDuplicatorService apiDuplicatorService;
    @Autowired
    private ConnectorService connectorService;
    @Autowired
    private EnvironmentService environmentService;
    @Autowired
    private ApiConverter apiConverter;
    @Autowired
    private ResourceService resourceService;
    @Autowired
    private FlowService flowService;
    @Autowired
    private V4EmulationEngineService v4EmulationEngine;
    @Value(value="${configuration.default-api-icon:}")
    private String defaultApiIcon;
    @Autowired
    private PrimaryOwnerService primaryOwnerService;
    @Autowired
    private ApiNotificationService apiNotificationService;
    @Autowired
    private AnalyticsValidationService loggingValidationService;
    @Autowired
    private CorsValidationService corsValidationService;
    @Autowired
    private ApiEntrypointService apiEntrypointService;
    @Autowired
    private ApiTemplateService apiTemplateService;
    @Autowired
    private ApiAuthorizationService apiAuthorizationService;
    @Autowired
    private TagsValidationService tagsValidationService;
    @Lazy
    @Autowired
    private ApiSearchService apiSearchService;
    @Autowired
    private EmailRecipientsService emailRecipientsService;
    @Autowired
    private CategoryMapper categoryMapper;

    @Override
    public ApiEntity createFromSwagger(ExecutionContext executionContext, SwaggerApiEntity swaggerApiEntity, String userId, ImportSwaggerDescriptorEntity swaggerDescriptor) throws ApiAlreadyExistsException {
        ApiEntity createdApi = this.createFromUpdateApiEntity(executionContext, (UpdateApiEntity)swaggerApiEntity, userId, swaggerDescriptor);
        this.apiMetadataService.create(executionContext, swaggerApiEntity.getMetadata(), createdApi.getId());
        return createdApi;
    }

    private void checkGroupExistence(Set<String> groups) {
        log.debug("Checking if groups {} exist", groups);
        if (groups != null && !groups.isEmpty()) {
            try {
                this.groupService.findByIds(new HashSet<String>(groups));
            }
            catch (GroupsNotFoundException gnfe) {
                throw new InvalidDataException(String.format("These groups [%s] do not exist", gnfe.getParameters().get("groups")), gnfe);
            }
        }
    }

    private Set<String> removePOGroups(ExecutionContext executionContext, Set<String> groups, String apiId) {
        MembershipEntity primaryOwner;
        Stream<Object> groupEntityStream = this.groupService.findByIds(groups).stream();
        groupEntityStream = apiId != null ? ((primaryOwner = this.membershipService.getPrimaryOwner(executionContext.getOrganizationId(), MembershipReferenceType.API, apiId)).getMemberType() == MembershipMemberType.GROUP ? groupEntityStream.filter(group -> StringUtils.isEmpty((CharSequence)group.getApiPrimaryOwner()) || group.getId().equals(primaryOwner.getMemberId())) : groupEntityStream.filter(group -> StringUtils.isEmpty((CharSequence)group.getApiPrimaryOwner()) || group.getApiPrimaryOwner().equals(primaryOwner.getMemberId()))) : groupEntityStream.filter(group -> StringUtils.isEmpty((CharSequence)group.getApiPrimaryOwner()));
        return groupEntityStream.map(GroupEntity::getId).collect(Collectors.toCollection(HashSet::new));
    }

    @Override
    public ApiEntity create(ExecutionContext executionContext, NewApiEntity newApiEntity, String userId) throws ApiAlreadyExistsException, ApiDefinitionVersionNotSupportedException {
        List declaredPaths;
        if (DefinitionVersion.V1.equals((Object)DefinitionVersion.valueOfLabel((String)newApiEntity.getGraviteeDefinitionVersion()))) {
            throw new ApiDefinitionVersionNotSupportedException(newApiEntity.getGraviteeDefinitionVersion());
        }
        UpdateApiEntity apiEntity = new UpdateApiEntity();
        apiEntity.setName(newApiEntity.getName());
        apiEntity.setDescription(newApiEntity.getDescription());
        apiEntity.setVersion(newApiEntity.getVersion());
        apiEntity.setGraviteeDefinitionVersion(newApiEntity.getGraviteeDefinitionVersion());
        apiEntity.setFlows(newApiEntity.getFlows());
        apiEntity.setFlowMode(newApiEntity.getFlowMode());
        Set<String> groups = newApiEntity.getGroups();
        if (groups != null && !groups.isEmpty()) {
            this.checkGroupExistence(groups);
            groups = this.removePOGroups(executionContext, groups, null);
            newApiEntity.setGroups(groups);
        }
        apiEntity.setGroups((Set)groups);
        Proxy proxy = new Proxy();
        proxy.setVirtualHosts(Collections.singletonList(new VirtualHost(newApiEntity.getContextPath())));
        EndpointGroup group = new EndpointGroup();
        group.setName("default-group");
        String[] endpoints = null;
        if (newApiEntity.getEndpoint() != null) {
            endpoints = newApiEntity.getEndpoint().split(ENDPOINTS_DELIMITER);
        }
        if (endpoints == null) {
            group.setEndpoints(Collections.singleton(Endpoint.builder().name("default").build()));
        } else if (endpoints.length == 1) {
            group.setEndpoints(Collections.singleton(Endpoint.builder().name("default").target(endpoints[0]).build()));
        } else {
            group.setEndpoints(new HashSet());
            for (int i = 0; i < endpoints.length; ++i) {
                group.getEndpoints().add(Endpoint.builder().name("server" + (i + 1)).target(endpoints[i]).build());
            }
        }
        proxy.setGroups(Collections.singleton(group));
        apiEntity.setProxy(proxy);
        List list = declaredPaths = newApiEntity.getPaths() != null ? newApiEntity.getPaths() : new ArrayList();
        if (!declaredPaths.contains("/")) {
            declaredPaths.add(0, "/");
        }
        apiEntity.setPathMappings(new HashSet(declaredPaths));
        return this.createFromUpdateApiEntity(executionContext, apiEntity, userId, null);
    }

    @Override
    public ApiEntity createWithApiDefinition(ExecutionContext executionContext, UpdateApiEntity api, String userId, JsonNode apiDefinition) throws ApiAlreadyExistsException {
        log.debug("Creating ApiEntity {} based on ApiDefinition ", (Object)api);
        if (DefinitionVersion.V1.equals((Object)DefinitionVersion.valueOfLabel((String)api.getGraviteeDefinitionVersion()))) {
            throw new ApiDefinitionVersionNotSupportedException(api.getGraviteeDefinitionVersion());
        }
        try {
            log.debug("Create {} for user {}", (Object)api, (Object)userId);
            String apiId = apiDefinition != null && apiDefinition.has("id") ? apiDefinition.get("id").asText() : null;
            String id = apiId != null && UUID.fromString(apiId) != null ? apiId : UuidString.generateRandom();
            log.debug("Trying to find API with id {} in ApiRepository", (Object)id);
            Optional checkApi = this.apiRepository.findById((Object)id);
            log.debug("API found: {}", (Object)checkApi.isPresent());
            if (checkApi.isPresent()) {
                throw new ApiAlreadyExistsException(id);
            }
            this.checkShardingTags(api, null, executionContext);
            Validator.Result<VerifyApiPathDomainService.Input> validationResult = this.verifyApiPathDomainService.validateAndSanitize(new VerifyApiPathDomainService.Input(executionContext.getEnvironmentId(), apiId, api.getProxy().getVirtualHosts().stream().map(vh -> Path.builder().host(vh.getHost()).path(vh.getPath()).overrideAccess(vh.isOverrideEntrypoint()).build()).toList()));
            validationResult.severe().ifPresent(errors -> {
                throw new InvalidPathsException(((Validator.Error)errors.iterator().next()).getMessage());
            });
            List sanitizedVirtualHosts = validationResult.map(VerifyApiPathDomainService.Input::paths).map(paths -> paths.stream().map(sanitized -> new VirtualHost(sanitized.getHost(), sanitized.getPath(), sanitized.isOverrideAccess())).toList()).value().stream().flatMap(Collection::stream).toList();
            api.getProxy().setVirtualHosts(new ArrayList(sanitizedVirtualHosts));
            this.checkEndpointsConfiguration(api);
            this.corsValidationService.validateAndSanitize(api.getProxy().getCors());
            api.getProxy().setLogging(this.loggingValidationService.validateAndSanitize(executionContext, api.getProxy().getLogging()));
            this.validateRegexfields(api);
            this.checkPolicyConfigurations(api);
            this.checkResourceConfigurations(api);
            PrimaryOwnerEntity primaryOwner = this.findPrimaryOwner(executionContext, apiDefinition, userId);
            if (apiDefinition != null) {
                apiDefinition = ((ObjectNode)apiDefinition).put("id", id);
            }
            if (api.getExecutionMode() == null) {
                api.setExecutionMode(this.v4EmulationEngine.getExecutionModeFor(apiDefinition));
            }
            io.gravitee.repository.management.model.Api repoApi = this.convert(executionContext, id, api, apiDefinition != null ? apiDefinition.toString() : null);
            repoApi.setId(id);
            repoApi.setEnvironmentId(executionContext.getEnvironmentId());
            log.debug("Set date fields for API {}", (Object)api);
            repoApi.setCreatedAt(new Date());
            repoApi.setUpdatedAt(repoApi.getCreatedAt());
            log.debug("Set definition context for API {}", (Object)api);
            DefinitionContext definitionContext = new DefinitionContext();
            if (apiDefinition != null && apiDefinition.hasNonNull(API_DEFINITION_CONTEXT_FIELD)) {
                JsonNode definitionContextNode = apiDefinition.get(API_DEFINITION_CONTEXT_FIELD);
                String origin = definitionContextNode.get(API_DEFINITION_CONTEXT_FIELD_ORIGIN).asText();
                String mode = definitionContextNode.get(API_DEFINITION_CONTEXT_FIELD_MODE).asText();
                String syncFrom = definitionContextNode.get(API_DEFINITION_CONTEXT_FIELD_SYNC_FROM).asText();
                definitionContext = new DefinitionContext(origin, mode, syncFrom);
            }
            repoApi.setOrigin(definitionContext.getOrigin());
            repoApi.setMode(definitionContext.getMode());
            repoApi.setSyncFrom(definitionContext.getSyncFrom().toUpperCase());
            if (DefinitionContext.isKubernetes((String)repoApi.getOrigin())) {
                log.debug("Using a Kubernetes context...");
                if (api.getState() == null) {
                    log.debug("Set repoApi lifecycle state to STARTED by default");
                    repoApi.setLifecycleState(LifecycleState.STARTED);
                } else {
                    log.debug("Set repoApi lifecycle state to {}", (Object)api.getState());
                    repoApi.setLifecycleState(LifecycleState.valueOf((String)api.getState().toString()));
                }
                if (api.getLifecycleState() == null) {
                    log.debug("Set api lifecycle state to CREATED by default");
                    repoApi.setApiLifecycleState(ApiLifecycleState.CREATED);
                } else {
                    log.debug("Set api lifecycle state to {}", (Object)api.getLifecycleState().name());
                    repoApi.setApiLifecycleState(ApiLifecycleState.valueOf((String)api.getLifecycleState().name()));
                }
            } else {
                log.debug("Using a none-Kubernetes context...");
                log.debug("Set repoApi lifecycle state to STOPPED and repoApi api lifecycle state to CREATED");
                repoApi.setLifecycleState(LifecycleState.STOPPED);
                repoApi.setApiLifecycleState(ApiLifecycleState.CREATED);
            }
            log.debug("Set visibility to PRIVATE by default if not set for API {} (currently: {})", (Object)api, (Object)api.getVisibility());
            repoApi.setVisibility(api.getVisibility() == null ? Visibility.PRIVATE : Visibility.valueOf((String)api.getVisibility().toString()));
            log.debug("Add default groups");
            Set<GroupEntity> defaultGroupEntities = this.groupService.findByEvent(executionContext.getEnvironmentId(), GroupEvent.API_CREATE);
            Set defaultGroups = defaultGroupEntities.stream().filter(group -> StringUtils.isEmpty((CharSequence)group.getApiPrimaryOwner())).map(GroupEntity::getId).collect(Collectors.toSet());
            if (repoApi.getGroups() == null) {
                repoApi.setGroups(defaultGroups.isEmpty() ? null : defaultGroups);
            } else {
                repoApi.getGroups().addAll(defaultGroups);
            }
            if (ApiPrimaryOwnerMode.GROUP.name().equals(primaryOwner.getType())) {
                log.debug("Adding PO (group) {} as a member of the API {}", (Object)primaryOwner, (Object)api);
                if (repoApi.getGroups() == null) {
                    repoApi.setGroups(new HashSet());
                }
                repoApi.getGroups().add(primaryOwner.getId());
            }
            if (this.parameterService.findAsBoolean(executionContext, Key.API_REVIEW_ENABLED, ParameterReferenceType.ENVIRONMENT)) {
                this.workflowService.create(WorkflowReferenceType.API, id, WorkflowType.REVIEW, userId, WorkflowState.DRAFT, "");
            }
            io.gravitee.repository.management.model.Api createdApi = (io.gravitee.repository.management.model.Api)this.apiRepository.create((Object)repoApi);
            this.auditService.createApiAuditLog(executionContext, createdApi.getId(), Collections.emptyMap(), (Audit.AuditEvent)Api.AuditEvent.API_CREATED, createdApi.getCreatedAt(), null, createdApi);
            log.debug("Add primary owner {} to API {}", (Object)primaryOwner, (Object)createdApi.getId());
            this.membershipService.addRoleToMemberOnReference(executionContext, new MembershipService.MembershipReference(MembershipReferenceType.API, createdApi.getId()), new MembershipService.MembershipMember(primaryOwner.getId(), null, MembershipMemberType.valueOf((String)primaryOwner.getType())), new MembershipService.MembershipRole(RoleScope.API, SystemRole.PRIMARY_OWNER.name()));
            log.debug("Create default mail notification for API {}", (Object)createdApi.getId());
            String emailMetadataValue = "${(api.primaryOwner.email)!''}";
            GenericNotificationConfigEntity notificationConfigEntity = new GenericNotificationConfigEntity();
            notificationConfigEntity.setName("Default Mail Notifications");
            notificationConfigEntity.setReferenceType(HookScope.API.name());
            notificationConfigEntity.setReferenceId(createdApi.getId());
            notificationConfigEntity.setHooks(Arrays.stream(ApiHook.values()).map(Enum::name).collect(Collectors.toList()));
            notificationConfigEntity.setNotifier("default-email");
            notificationConfigEntity.setConfig("${(api.primaryOwner.email)!''}");
            this.genericNotificationConfigService.create(notificationConfigEntity);
            log.debug("Create default mail support metadata for API {}", (Object)createdApi.getId());
            NewApiMetadataEntity newApiMetadataEntity = new NewApiMetadataEntity();
            newApiMetadataEntity.setFormat(MetadataFormat.MAIL);
            newApiMetadataEntity.setName("email-support");
            newApiMetadataEntity.setDefaultValue("${(api.primaryOwner.email)!''}");
            newApiMetadataEntity.setValue("${(api.primaryOwner.email)!''}");
            newApiMetadataEntity.setApiId(createdApi.getId());
            this.apiMetadataService.create(executionContext, newApiMetadataEntity);
            log.debug("Create API flows for API {}", (Object)createdApi.getId());
            this.flowService.save(FlowReferenceType.API, createdApi.getId(), api.getFlows());
            log.debug("Create API category order entries for API {}", (Object)createdApi.getId());
            this.apiCategoryService.addApiToCategories(createdApi.getId(), createdApi.getCategories());
            ApiEntity apiEntity = this.convert(executionContext, createdApi, primaryOwner);
            GenericApiEntity apiWithMetadata = this.apiMetadataService.fetchMetadataForApi(executionContext, (GenericApiEntity)apiEntity);
            this.alertService.createDefaults(executionContext, AlertReferenceType.API, createdApi.getId());
            this.searchEngineService.index(executionContext, (Indexable)apiWithMetadata, false);
            return apiEntity;
        }
        catch (InvalidPathsException ex) {
            throw new InvalidPathException(String.format("API paths are invalid for API %s", api), ex);
        }
        catch (TechnicalException | IllegalStateException ex) {
            throw new TechnicalManagementException(String.format("An error occurs while trying create %s for user %s", api, userId), ex);
        }
    }

    private ApiEntity createFromUpdateApiEntity(ExecutionContext executionContext, UpdateApiEntity apiEntity, String userId, ImportSwaggerDescriptorEntity swaggerDescriptor) {
        ApiEntity createdApi = this.createWithApiDefinition(executionContext, apiEntity, userId, null);
        this.pageService.createAsideFolder(executionContext, createdApi.getId());
        this.pageService.createOrUpdateSwaggerPage(executionContext, createdApi.getId(), swaggerDescriptor, true);
        return createdApi;
    }

    public PrimaryOwnerEntity findPrimaryOwner(ExecutionContext executionContext, JsonNode apiDefinition, String userId) {
        log.debug("Searching primary owner for API...");
        PrimaryOwnerEntity primaryOwnerFromDefinition = this.findPrimaryOwnerFromApiDefinition(apiDefinition);
        return this.primaryOwnerService.getPrimaryOwner(executionContext, userId, primaryOwnerFromDefinition);
    }

    private PrimaryOwnerEntity findPrimaryOwnerFromApiDefinition(JsonNode apiDefinition) {
        PrimaryOwnerEntity primaryOwnerEntity = null;
        if (apiDefinition != null && apiDefinition.has("primaryOwner")) {
            try {
                primaryOwnerEntity = (PrimaryOwnerEntity)this.objectMapper.readValue(apiDefinition.get("primaryOwner").toString(), PrimaryOwnerEntity.class);
            }
            catch (JsonProcessingException e) {
                log.warn("Cannot parse primary owner from definition, continue with current user", (Throwable)e);
            }
        }
        return primaryOwnerEntity;
    }

    private void checkEndpointsConfiguration(UpdateApiEntity api) {
        log.debug("Check endpoints configuration for API {}", (Object)api);
        if (api.getProxy() != null && api.getProxy().getGroups() != null) {
            HashSet<String> names = new HashSet<String>();
            for (EndpointGroup group : api.getProxy().getGroups()) {
                String endpointGroupName = group.getName();
                this.assertEndpointNameNotContainsInvalidCharacters(endpointGroupName);
                if (names.contains(endpointGroupName)) {
                    throw new EndpointGroupNameAlreadyExistsException(endpointGroupName);
                }
                names.add(endpointGroupName);
                if (group.getEndpoints() == null) continue;
                for (Endpoint endpoint : group.getEndpoints()) {
                    String endpointName = endpoint.getName();
                    this.assertEndpointNameNotContainsInvalidCharacters(endpointName);
                    if (names.contains(endpointName)) {
                        throw new EndpointNameAlreadyExistsException(endpointName);
                    }
                    names.add(endpointName);
                }
            }
        }
    }

    private void checkEndpointsExists(UpdateApiEntity api) {
        EndpointDiscoveryService endpointDiscoveryService;
        if (api.getProxy().getGroups() == null || api.getProxy().getGroups().isEmpty()) {
            throw new EndpointMissingException();
        }
        EndpointGroup endpointGroup = (EndpointGroup)api.getProxy().getGroups().iterator().next();
        EndpointDiscoveryService endpointDiscoveryService2 = endpointDiscoveryService = endpointGroup.getServices() == null ? null : (EndpointDiscoveryService)endpointGroup.getServices().get(EndpointDiscoveryService.class);
        if (!(endpointDiscoveryService != null && endpointDiscoveryService.isEnabled() || endpointGroup.getEndpoints() != null && !endpointGroup.getEndpoints().isEmpty())) {
            throw new EndpointMissingException();
        }
    }

    private void validateHealtcheckSchedule(UpdateApiEntity api) {
        String schedule;
        HealthCheckService healthCheckService;
        if (api.getServices() != null && (healthCheckService = (HealthCheckService)api.getServices().get(HealthCheckService.class)) != null && (schedule = healthCheckService.getSchedule()) != null) {
            try {
                new CronTrigger(schedule);
            }
            catch (IllegalArgumentException e) {
                throw new InvalidDataException(e);
            }
        }
    }

    private boolean isHttpEndpoint(Endpoint endpoint) {
        return "grpc".equalsIgnoreCase(endpoint.getType()) || "http".equalsIgnoreCase(endpoint.getType());
    }

    private void assertEndpointNameNotContainsInvalidCharacters(String name) {
        if (name != null && name.contains(":")) {
            throw new EndpointNameInvalidException(name);
        }
    }

    @Override
    public ApiEntity findById(ExecutionContext executionContext, String apiId) {
        io.gravitee.repository.management.model.Api api = this.findApiById(executionContext, apiId);
        ApiEntity apiEntity = this.convert(executionContext, api, this.getPrimaryOwner(executionContext, api));
        List<ApiEntrypointEntity> apiEntrypoints = this.apiEntrypointService.getApiEntrypoints(executionContext, (GenericApiEntity)apiEntity);
        apiEntity.setEntrypoints(apiEntrypoints);
        return apiEntity;
    }

    @Override
    public Optional<ApiEntity> findByEnvironmentIdAndCrossId(String environment, String crossId) {
        try {
            return this.apiRepository.findByEnvironmentIdAndCrossId(environment, crossId).map(api -> this.apiConverter.toApiEntity((io.gravitee.repository.management.model.Api)api, null));
        }
        catch (TechnicalException e) {
            throw new TechnicalManagementException("An error occurred while finding API by environment " + environment + " and crossId " + crossId, e);
        }
    }

    private PrimaryOwnerEntity getPrimaryOwner(ExecutionContext executionContext, io.gravitee.repository.management.model.Api api) throws TechnicalManagementException {
        return this.primaryOwnerService.getPrimaryOwner(executionContext.getOrganizationId(), api.getId());
    }

    @Override
    public Map<String, Object> findByIdAsMap(String id) throws TechnicalException {
        io.gravitee.repository.management.model.Api api = (io.gravitee.repository.management.model.Api)this.apiRepository.findById((Object)id).orElseThrow(() -> new ApiNotFoundException(id));
        ExecutionContext executionContext = new ExecutionContext(this.environmentService.findById(api.getEnvironmentId()));
        ApiEntity apiEntity = this.convert(executionContext, api, this.getPrimaryOwner(executionContext, api));
        Map dataAsMap = (Map)this.objectMapper.convertValue((Object)apiEntity, Map.class);
        dataAsMap.put("id", id);
        dataAsMap.put("primaryOwner", this.objectMapper.convertValue((Object)apiEntity.getPrimaryOwner(), Map.class));
        dataAsMap.remove("picture");
        dataAsMap.remove("proxy");
        dataAsMap.remove("paths");
        dataAsMap.remove("properties");
        dataAsMap.remove("services");
        dataAsMap.remove("resources");
        dataAsMap.remove("response_templates");
        dataAsMap.remove("path_mappings");
        List<ApiMetadataEntity> metadataList = this.apiMetadataService.findAllByApi(executionContext, id);
        HashMap mapMetadata = new HashMap(metadataList.size());
        metadataList.forEach(m -> mapMetadata.put(m.getKey(), m.getValue() == null ? m.getDefaultValue() : m.getValue()));
        dataAsMap.put("metadata", this.objectMapper.convertValue(mapMetadata, Map.class));
        return dataAsMap;
    }

    private String getScheme(String defaultEntrypoint) {
        String scheme = "https";
        if (defaultEntrypoint != null) {
            try {
                scheme = new URL(defaultEntrypoint).getProtocol();
            }
            catch (MalformedURLException malformedURLException) {
                // empty catch block
            }
        }
        return scheme;
    }

    @Override
    public Set<ApiEntity> findByUser(ExecutionContext executionContext, String userId, ApiQuery apiQuery, boolean manageOnly) {
        return new HashSet<ApiEntity>(this.findByUser(executionContext, userId, apiQuery, null, null, manageOnly).getContent());
    }

    @Override
    public Page<ApiEntity> findByUser(ExecutionContext executionContext, String userId, ApiQuery apiQuery, Sortable sortable, Pageable pageable, boolean manageOnly) {
        try {
            log.debug("Find APIs page by user {}", (Object)userId);
            if (apiQuery == null) {
                apiQuery = new ApiQuery();
            }
            apiQuery.setDefinitionVersions(ApiServiceImpl.getAllowedDefinitionVersion());
            Set<String> apiIds = this.apiAuthorizationService.findIdsByUser(executionContext, userId, apiQuery, sortable, manageOnly);
            return this.loadPage(executionContext, apiIds, pageable);
        }
        catch (TechnicalException ex) {
            throw new TechnicalManagementException("An error occurs while trying to find APIs for user " + userId, ex);
        }
    }

    private io.gravitee.repository.management.model.Api findApiById(ExecutionContext executionContext, String apiId) {
        try {
            log.debug("Find API by ID: {}", (Object)apiId);
            Optional<io.gravitee.repository.management.model.Api> optApi = this.apiRepository.findById((Object)apiId);
            if (executionContext.hasEnvironmentId()) {
                optApi = optApi.filter(result -> result.getEnvironmentId().equals(executionContext.getEnvironmentId()));
            }
            return (io.gravitee.repository.management.model.Api)optApi.orElseThrow(() -> new ApiNotFoundException(apiId));
        }
        catch (TechnicalException ex) {
            throw new TechnicalManagementException(String.format("An error occurs while trying to find an API using its ID: %s", apiId), ex);
        }
    }

    private Set merge(List originSet, Collection setToAdd) {
        if (originSet == null) {
            return this.merge(Collections.emptySet(), setToAdd);
        }
        return this.merge(new HashSet(originSet), setToAdd);
    }

    private Set merge(Set originSet, Collection setToAdd) {
        if (setToAdd != null && !setToAdd.isEmpty()) {
            if (originSet == null) {
                originSet = new HashSet();
            }
            originSet.addAll(setToAdd);
        }
        return originSet;
    }

    @Override
    public ApiEntity updateFromSwagger(ExecutionContext executionContext, String apiId, SwaggerApiEntity swaggerApiEntity, ImportSwaggerDescriptorEntity swaggerDescriptor) {
        ApiEntity apiEntityToUpdate = this.findById(executionContext, apiId);
        if (DefinitionVersion.V1.equals((Object)DefinitionVersion.valueOfLabel((String)apiEntityToUpdate.getGraviteeDefinitionVersion()))) {
            throw new ApiDefinitionVersionNotSupportedException(apiEntityToUpdate.getGraviteeDefinitionVersion());
        }
        UpdateApiEntity updateApiEntity = this.apiConverter.toUpdateApiEntity(apiEntityToUpdate);
        updateApiEntity.setVersion(swaggerApiEntity.getVersion());
        updateApiEntity.setName(swaggerApiEntity.getName());
        updateApiEntity.setDescription(swaggerApiEntity.getDescription());
        Set mergedCategories = this.merge(updateApiEntity.getCategories(), (Collection)swaggerApiEntity.getCategories());
        updateApiEntity.setCategories(this.categoryMapper.toCategoryKey(executionContext.getEnvironmentId(), mergedCategories));
        if (swaggerApiEntity.getProxy() != null) {
            Proxy proxy = updateApiEntity.getProxy();
            if (proxy == null) {
                proxy = new Proxy();
            }
            proxy.setGroups(this.merge(proxy.getGroups(), (Collection)swaggerApiEntity.getProxy().getGroups()));
            List virtualHostsToAdd = swaggerApiEntity.getProxy().getVirtualHosts().stream().map(v -> new VirtualHost(v.getHost(), Path.sanitizePath(v.getPath()), v.isOverrideEntrypoint())).collect(Collectors.toList());
            if (virtualHostsToAdd != null && !virtualHostsToAdd.isEmpty()) {
                proxy.setVirtualHosts(new ArrayList(this.merge(proxy.getVirtualHosts().stream().map(v -> new VirtualHost(v.getHost(), Path.sanitizePath(v.getPath()), v.isOverrideEntrypoint())).collect(Collectors.toSet()), virtualHostsToAdd)));
            }
            updateApiEntity.setProxy(proxy);
        }
        updateApiEntity.setGroups(this.merge(updateApiEntity.getGroups(), (Collection)swaggerApiEntity.getGroups()));
        updateApiEntity.setLabels(new ArrayList(this.merge(updateApiEntity.getLabels(), (Collection)swaggerApiEntity.getLabels())));
        if (swaggerApiEntity.getPicture() != null) {
            updateApiEntity.setPicture(swaggerApiEntity.getPicture());
        }
        updateApiEntity.setTags(this.merge(updateApiEntity.getTags(), (Collection)swaggerApiEntity.getTags()));
        if (swaggerApiEntity.getVisibility() != null) {
            updateApiEntity.setVisibility(swaggerApiEntity.getVisibility());
        }
        if (swaggerApiEntity.getProperties() != null) {
            PropertiesEntity properties = updateApiEntity.getProperties();
            if (properties == null) {
                properties = new PropertiesEntity();
            }
            properties.setProperties(new ArrayList(this.merge(properties.getProperties(), (Collection)swaggerApiEntity.getProperties().getProperties())));
            updateApiEntity.setProperties(properties);
        }
        if (swaggerDescriptor != null) {
            if (swaggerDescriptor.isWithPathMapping()) {
                updateApiEntity.setPathMappings(swaggerApiEntity.getPathMappings());
            }
            if (swaggerDescriptor.isWithPolicyPaths()) {
                if (DefinitionVersion.V2.getLabel().equals(updateApiEntity.getGraviteeDefinitionVersion())) {
                    updateApiEntity.setFlows(swaggerApiEntity.getFlows());
                } else {
                    updateApiEntity.setPaths(swaggerApiEntity.getPaths());
                }
            }
        }
        this.pageService.createOrUpdateSwaggerPage(executionContext, apiEntityToUpdate.getId(), swaggerDescriptor, false);
        ApiEntity updatedApi = this.update(executionContext, apiId, updateApiEntity);
        if (swaggerApiEntity.getMetadata() != null && !swaggerApiEntity.getMetadata().isEmpty()) {
            swaggerApiEntity.getMetadata().forEach(data -> {
                try {
                    ApiMetadataEntity apiMetadataEntity = this.apiMetadataService.findByIdAndApi(executionContext, data.getKey(), apiId);
                    UpdateApiMetadataEntity updateApiMetadataEntity = new UpdateApiMetadataEntity();
                    updateApiMetadataEntity.setApiId(apiId);
                    updateApiMetadataEntity.setFormat(data.getFormat());
                    updateApiMetadataEntity.setKey(apiMetadataEntity.getKey());
                    updateApiMetadataEntity.setName(data.getName());
                    updateApiMetadataEntity.setValue(data.getValue());
                    ApiMetadataEntity metadata = this.apiMetadataService.update(executionContext, updateApiMetadataEntity);
                    updatedApi.getMetadata().put(metadata.getKey(), metadata.getValue());
                }
                catch (ApiMetadataNotFoundException amnfe) {
                    NewApiMetadataEntity newMD = new NewApiMetadataEntity();
                    newMD.setApiId(apiId);
                    newMD.setFormat(data.getFormat());
                    newMD.setName(data.getName());
                    newMD.setValue(data.getValue());
                    ApiMetadataEntity metadata = this.apiMetadataService.create(executionContext, newMD);
                    updatedApi.getMetadata().put(metadata.getKey(), metadata.getValue());
                }
            });
        }
        this.searchEngineService.index(executionContext, (Indexable)updatedApi, false);
        return updatedApi;
    }

    @Override
    public ApiEntity update(ExecutionContext executionContext, String apiId, UpdateApiEntity updateApiEntity) {
        return this.update(executionContext, apiId, updateApiEntity, false);
    }

    @Override
    public ApiEntity update(ExecutionContext executionContext, String apiId, UpdateApiEntity updateApiEntity, boolean checkPlans) {
        return this.update(executionContext, apiId, updateApiEntity, checkPlans, true);
    }

    @Override
    public ApiEntity update(ExecutionContext executionContext, String apiId, UpdateApiEntity updateApiEntity, boolean checkPlans, boolean updatePlansAndFlows) {
        try {
            log.debug("Update API {}", (Object)apiId);
            io.gravitee.repository.management.model.Api apiToUpdate = (io.gravitee.repository.management.model.Api)this.apiRepository.findById((Object)apiId).orElseThrow(() -> new ApiNotFoundException(apiId));
            if (DefinitionVersion.V1.equals((Object)apiToUpdate.getDefinitionVersion())) {
                throw new ApiDefinitionVersionNotSupportedException(apiToUpdate.getDefinitionVersion().getLabel());
            }
            Validator.Result<VerifyApiPathDomainService.Input> validationResult = this.verifyApiPathDomainService.validateAndSanitize(new VerifyApiPathDomainService.Input(executionContext.getEnvironmentId(), apiId, updateApiEntity.getProxy().getVirtualHosts().stream().map(h -> Path.builder().host(h.getHost()).path(h.getPath()).overrideAccess(h.isOverrideEntrypoint()).build()).collect(Collectors.toList())));
            validationResult.severe().ifPresent(errors -> {
                throw new InvalidPathsException(((Validator.Error)errors.iterator().next()).getMessage());
            });
            List sanitizedVirtualHosts = validationResult.map(VerifyApiPathDomainService.Input::paths).map(paths -> paths.stream().map(sanitized -> new VirtualHost(sanitized.getHost(), sanitized.getPath(), sanitized.isOverrideAccess())).toList()).value().stream().flatMap(Collection::stream).toList();
            updateApiEntity.getProxy().setVirtualHosts(new ArrayList(sanitizedVirtualHosts));
            this.checkEndpointsExists(updateApiEntity);
            this.checkEndpointsConfiguration(updateApiEntity);
            this.validateHealtcheckSchedule(updateApiEntity);
            updateApiEntity.getProxy().setCors(this.corsValidationService.validateAndSanitize(updateApiEntity.getProxy().getCors()));
            updateApiEntity.getProxy().setLogging(this.loggingValidationService.validateAndSanitize(executionContext, updateApiEntity.getProxy().getLogging()));
            this.validateRegexfields(updateApiEntity);
            this.checkPolicyConfigurations(updateApiEntity);
            this.checkResourceConfigurations(updateApiEntity);
            ApiEntity apiToCheck = this.convert(executionContext, apiToUpdate);
            this.checkDefinitionVersion(updateApiEntity, apiToCheck);
            this.checkShardingTags(updateApiEntity, apiToCheck, executionContext);
            if (updateApiEntity.getLifecycleState() == null) {
                updateApiEntity.setLifecycleState(apiToCheck.getLifecycleState());
            }
            this.checkLifecycleState(updateApiEntity, apiToCheck);
            Set<String> groups = updateApiEntity.getGroups();
            if (groups != null && !groups.isEmpty()) {
                this.checkGroupExistence(groups);
                groups = this.removePOGroups(executionContext, groups, apiId);
                updateApiEntity.setGroups(groups);
            }
            PrimaryOwnerEntity primaryOwner = this.getPrimaryOwner(executionContext, apiToUpdate);
            if (ApiPrimaryOwnerMode.GROUP.name().equals(primaryOwner.getType())) {
                if (updateApiEntity.getGroups() == null) {
                    updateApiEntity.setGroups(new HashSet());
                }
                updateApiEntity.getGroups().add(primaryOwner.getId());
            }
            if (Objects.equals(updateApiEntity.getGraviteeDefinitionVersion(), DefinitionVersion.V1.getLabel()) && (updateApiEntity.getPaths() == null || updateApiEntity.getPaths().isEmpty())) {
                updateApiEntity.setPaths(Collections.singletonMap("/", new ArrayList()));
            }
            if (updateApiEntity.getPlans() == null) {
                updateApiEntity.setPlans(new HashSet());
            } else if (checkPlans) {
                Set existingPlans = apiToCheck.getPlans();
                HashMap<String, PlanStatus> planStatuses = new HashMap<String, PlanStatus>();
                if (existingPlans != null && !existingPlans.isEmpty()) {
                    planStatuses.putAll(existingPlans.stream().collect(Collectors.toMap(BasePlanEntity::getId, BasePlanEntity::getStatus)));
                }
                updateApiEntity.getPlans().forEach(planToUpdate -> {
                    if (!planStatuses.containsKey(planToUpdate.getId()) || planStatuses.containsKey(planToUpdate.getId()) && planStatuses.get(planToUpdate.getId()) == PlanStatus.CLOSED && planStatuses.get(planToUpdate.getId()) != planToUpdate.getStatus()) {
                        throw new InvalidDataException("Invalid status for plan '" + planToUpdate.getName() + "'");
                    }
                    try {
                        this.tagsValidationService.validatePlanTagsAgainstApiTags((Set<String>)planToUpdate.getTags(), updateApiEntity.getTags());
                    }
                    catch (TagNotAllowedException e) {
                        List missingTags = planToUpdate.getTags().stream().filter(tag -> !updateApiEntity.getTags().contains(tag)).collect(Collectors.toList());
                        throw new InvalidDataException("Sharding tags " + missingTags + " used by plan '" + planToUpdate.getName() + "'");
                    }
                });
            }
            this.encryptProperties(updateApiEntity.getPropertyList());
            if (io.gravitee.rest.api.model.api.ApiLifecycleState.DEPRECATED.equals((Object)updateApiEntity.getLifecycleState())) {
                this.planService.findByApi(executionContext, apiId).forEach(plan -> {
                    if (PlanStatus.PUBLISHED.equals((Object)plan.getStatus()) || PlanStatus.STAGING.equals((Object)plan.getStatus())) {
                        this.planService.deprecate(executionContext, plan.getId(), true);
                        updateApiEntity.getPlans().stream().filter(p -> p.getId().equals(plan.getId())).forEach(p -> p.setStatus(PlanStatus.DEPRECATED));
                    }
                });
            }
            io.gravitee.repository.management.model.Api api = this.convert(executionContext, apiId, updateApiEntity, apiToUpdate.getDefinition());
            api.setUpdatedAt(new Date());
            api.setEnvironmentId(apiToUpdate.getEnvironmentId());
            api.setDeployedAt(apiToUpdate.getDeployedAt());
            api.setCreatedAt(apiToUpdate.getCreatedAt());
            api.setOrigin(apiToUpdate.getOrigin());
            api.setMode(apiToUpdate.getMode());
            if (DefinitionContext.isKubernetes((String)api.getOrigin())) {
                api.setLifecycleState(updateApiEntity.getState() == null ? LifecycleState.STARTED : LifecycleState.valueOf((String)updateApiEntity.getState().toString()));
                if (updateApiEntity.getLifecycleState() != null) {
                    api.setApiLifecycleState(ApiLifecycleState.valueOf((String)updateApiEntity.getLifecycleState().name()));
                }
            } else {
                api.setLifecycleState(apiToUpdate.getLifecycleState());
            }
            if (updateApiEntity.getCrossId() == null) {
                api.setCrossId(apiToUpdate.getCrossId());
            }
            api.setBackground(updateApiEntity.getBackground() == null || updateApiEntity.getBackground().isEmpty() ? apiToUpdate.getBackground() : updateApiEntity.getBackground());
            api.setPicture(updateApiEntity.getPicture() == null || updateApiEntity.getPicture().isEmpty() ? apiToUpdate.getPicture() : updateApiEntity.getPicture());
            if (updateApiEntity.getGroups() == null) {
                api.setGroups((Collection)apiToUpdate.getGroups());
            }
            if (updateApiEntity.getLabels() == null && apiToUpdate.getLabels() != null) {
                api.setLabels(new ArrayList(new HashSet(apiToUpdate.getLabels())));
            }
            if (updateApiEntity.getCategories() == null) {
                api.setCategories(apiToUpdate.getCategories());
            }
            if (ApiLifecycleState.DEPRECATED.equals((Object)api.getApiLifecycleState())) {
                GenericApiEntity apiWithMetadata = this.apiMetadataService.fetchMetadataForApi(executionContext, (GenericApiEntity)apiToCheck);
                this.apiNotificationService.triggerDeprecatedNotification(executionContext, apiWithMetadata);
            }
            io.gravitee.repository.management.model.Api updatedApi = (io.gravitee.repository.management.model.Api)this.apiRepository.update((Object)api);
            if (updatePlansAndFlows) {
                this.flowService.save(FlowReferenceType.API, api.getId(), updateApiEntity.getFlows());
                log.debug("Update API plans");
                updateApiEntity.getPlans().forEach(plan -> {
                    plan.setApi(api.getId());
                    this.planService.createOrUpdatePlan(executionContext, (PlanEntity)plan);
                });
            }
            this.apiCategoryService.updateApiCategories(api.getId(), api.getCategories());
            log.debug("Creating API audit log for API %s", (Object)api.getId());
            this.auditService.createApiAuditLog(executionContext, updatedApi.getId(), Collections.emptyMap(), (Audit.AuditEvent)Api.AuditEvent.API_UPDATED, updatedApi.getUpdatedAt(), apiToUpdate, updatedApi);
            log.debug("Check if Audit API logging option is enabled");
            if (this.parameterService.findAsBoolean(executionContext, Key.LOGGING_AUDIT_TRAIL_ENABLED, ParameterReferenceType.ENVIRONMENT)) {
                this.auditApiLogging(executionContext, apiToUpdate, updatedApi);
            }
            ApiEntity apiEntity = this.convert(executionContext, updatedApi, primaryOwner);
            GenericApiEntity apiWithMetadata = this.apiMetadataService.fetchMetadataForApi(executionContext, (GenericApiEntity)apiEntity);
            this.apiNotificationService.triggerUpdateNotification(executionContext, apiWithMetadata);
            this.searchEngineService.index(executionContext, (Indexable)apiWithMetadata, false);
            return apiEntity;
        }
        catch (InvalidPathsException ex) {
            throw new InvalidPathException(String.format("API paths are invalid for API %s", apiId), ex);
        }
        catch (TechnicalException ex) {
            throw new TechnicalManagementException(String.format("An error occurs while trying to update API %s", apiId), ex);
        }
    }

    private String buildApiDefinition(String apiId, String apiDefinition, UpdateApiEntity updateApiEntity) {
        try {
            Api updateApiDefinition;
            if (apiDefinition == null || apiDefinition.isEmpty()) {
                updateApiDefinition = new Api();
                updateApiDefinition.setDefinitionVersion(DefinitionVersion.valueOfLabel((String)updateApiEntity.getGraviteeDefinitionVersion()));
            } else {
                updateApiDefinition = (Api)this.objectMapper.readValue(apiDefinition, Api.class);
                updateApiDefinition.setPlans(Collections.emptyList());
                updateApiDefinition.setFlows(Collections.emptyList());
            }
            updateApiDefinition.setId(apiId);
            updateApiDefinition.setName(updateApiEntity.getName());
            updateApiDefinition.setVersion(updateApiEntity.getVersion());
            updateApiDefinition.setProxy(updateApiEntity.getProxy());
            if (updateApiEntity.getExecutionMode() != null) {
                updateApiDefinition.setExecutionMode(updateApiEntity.getExecutionMode());
            }
            if (StringUtils.isNotEmpty((CharSequence)updateApiEntity.getGraviteeDefinitionVersion())) {
                updateApiDefinition.setDefinitionVersion(DefinitionVersion.valueOfLabel((String)updateApiEntity.getGraviteeDefinitionVersion()));
            }
            if (updateApiEntity.getFlowMode() != null) {
                updateApiDefinition.setFlowMode(updateApiEntity.getFlowMode());
            }
            if (updateApiEntity.getPaths() != null) {
                updateApiDefinition.setPaths(updateApiEntity.getPaths());
            }
            if (updateApiEntity.getPathMappings() != null) {
                updateApiDefinition.setPathMappings(updateApiEntity.getPathMappings().stream().collect(Collectors.toMap(pathMapping -> pathMapping, pathMapping -> Pattern.compile(""))));
            }
            updateApiDefinition.setServices(updateApiEntity.getServices());
            updateApiDefinition.setResources(updateApiEntity.getResources());
            if (updateApiEntity.getProperties() != null) {
                updateApiDefinition.setProperties(updateApiEntity.getProperties().toDefinition());
            }
            updateApiDefinition.setTags(updateApiEntity.getTags());
            updateApiDefinition.setResponseTemplates(updateApiEntity.getResponseTemplates());
            return this.objectMapper.writeValueAsString((Object)updateApiDefinition);
        }
        catch (JsonProcessingException jse) {
            throw new TechnicalManagementException(String.format("An error occurs while trying to parse API definition for API %s", apiId), jse);
        }
    }

    private void checkDefinitionVersion(UpdateApiEntity updateApiEntity, ApiEntity existingAPI) {
        if (existingAPI != null && updateApiEntity.getGraviteeDefinitionVersion() != null) {
            DefinitionVersion updateDefinitionVersion = DefinitionVersion.valueOfLabel((String)updateApiEntity.getGraviteeDefinitionVersion());
            if (updateDefinitionVersion == null) {
                throw new InvalidDataException(String.format("Invalid definition version for api '%s'", existingAPI.getId()));
            }
            DefinitionVersion existingDefinitionVersion = DefinitionVersion.valueOfLabel((String)existingAPI.getGraviteeDefinitionVersion());
            if (updateDefinitionVersion.asInteger() < existingDefinitionVersion.asInteger()) {
                throw new DefinitionVersionException();
            }
        }
    }

    private void checkShardingTags(UpdateApiEntity updateApiEntity, ApiEntity existingAPI, ExecutionContext executionContext) throws TechnicalException {
        Set<Object> updatedTags;
        Set<String> tagsToUpdate;
        log.debug("Checking sharding tags...");
        Set set = tagsToUpdate = updateApiEntity.getTags() == null ? new HashSet() : updateApiEntity.getTags();
        if (existingAPI == null) {
            updatedTags = tagsToUpdate;
        } else {
            Set existingAPITags = existingAPI.getTags() == null ? new HashSet() : existingAPI.getTags();
            updatedTags = existingAPITags.stream().filter(tag -> !tagsToUpdate.contains(tag)).collect(Collectors.toSet());
            updatedTags.addAll(tagsToUpdate.stream().filter(tag -> !existingAPITags.contains(tag)).collect(Collectors.toSet()));
        }
        log.debug("Sharding tags to update: {}", (Object)updatedTags.size());
        if (!updatedTags.isEmpty()) {
            this.tagService.checkTagsExist(updatedTags, executionContext.getOrganizationId(), TagReferenceType.ORGANIZATION);
            log.debug("Check if user {} has permissions to update sharding tags", (Object)this.getAuthenticatedUser());
            Set<String> userTags = this.tagService.findByUser(this.getAuthenticatedUsername(), executionContext.getOrganizationId(), TagReferenceType.ORGANIZATION);
            if (!userTags.containsAll(updatedTags)) {
                String[] notAllowedTags = (String[])updatedTags.stream().filter(tag -> !userTags.contains(tag)).toArray(String[]::new);
                throw new TagNotAllowedException(notAllowedTags);
            }
            log.debug("User {} has permissions to update sharding tags", (Object)this.getAuthenticatedUser());
        }
    }

    private void checkResourceConfigurations(UpdateApiEntity updateApiEntity) {
        log.debug("Check resource configurations for API {}", (Object)updateApiEntity);
        List resources = updateApiEntity.getResources();
        if (resources != null) {
            resources.stream().filter(Resource::isEnabled).forEach(resource -> this.resourceService.validateResourceConfiguration((Resource)resource));
        }
    }

    private void checkPolicyConfigurations(UpdateApiEntity updateApiEntity) {
        log.debug("Check policy configurations for API {}", (Object)updateApiEntity);
        this.checkPolicyConfigurations(updateApiEntity.getPaths(), updateApiEntity.getFlows(), updateApiEntity.getPlans());
    }

    @Override
    public void checkPolicyConfigurations(Map<String, List<Rule>> paths, List<Flow> flows, Set<PlanEntity> plans) {
        this.checkPathsPolicyConfiguration(paths);
        this.checkFlowsPolicyConfiguration(flows);
        if (plans != null) {
            plans.stream().forEach(plan -> {
                this.checkPathsPolicyConfiguration(plan.getPaths());
                this.checkFlowsPolicyConfiguration(plan.getFlows());
            });
        }
    }

    private void checkPathsPolicyConfiguration(Map<String, List<Rule>> paths) {
        if (paths != null) {
            paths.forEach((s, rules) -> rules.stream().filter(Rule::isEnabled).map(Rule::getPolicy).forEach(policy -> this.policyService.validatePolicyConfiguration((Policy)policy)));
        }
    }

    private void checkFlowsPolicyConfiguration(List<Flow> flows) {
        if (flows != null) {
            flows.stream().filter(flow -> flow.getPre() != null).forEach(flow -> flow.getPre().stream().filter(Step::isEnabled).forEach(step -> this.policyService.validatePolicyConfiguration((Step)step)));
            flows.stream().filter(flow -> flow.getPost() != null).forEach(flow -> flow.getPost().stream().filter(Step::isEnabled).forEach(step -> this.policyService.validatePolicyConfiguration((Step)step)));
        }
    }

    private void validateRegexfields(UpdateApiEntity updateApiEntity) {
        log.debug("Check regex on paths for API {}", (Object)updateApiEntity);
        if (updateApiEntity.getPaths() != null) {
            updateApiEntity.getPaths().forEach((path, v) -> {
                try {
                    Pattern.compile(path);
                }
                catch (PatternSyntaxException pse) {
                    throw new TechnicalManagementException(String.format("An error occurs while trying to parse the path %s", path), pse);
                }
            });
        }
        if (updateApiEntity.getPathMappings() != null) {
            updateApiEntity.getPathMappings().forEach(pathMapping -> {
                try {
                    Pattern.compile(pathMapping);
                }
                catch (PatternSyntaxException pse) {
                    throw new TechnicalManagementException(String.format("An error occurs while trying to parse the path mapping %s", pathMapping), pse);
                }
            });
        }
    }

    private void checkLifecycleState(UpdateApiEntity updateApiEntity, ApiEntity existingAPI) {
        if (io.gravitee.rest.api.model.api.ApiLifecycleState.DEPRECATED.equals((Object)existingAPI.getLifecycleState()) && (updateApiEntity.getGraviteeDefinitionVersion().equals(existingAPI.getGraviteeDefinitionVersion()) || updateApiEntity.getLifecycleState() != existingAPI.getLifecycleState())) {
            throw new LifecycleStateChangeNotAllowedException(updateApiEntity.getLifecycleState().name());
        }
        if (existingAPI.getLifecycleState().name().equals(updateApiEntity.getLifecycleState().name())) {
            return;
        }
        if (io.gravitee.rest.api.model.api.ApiLifecycleState.ARCHIVED.equals((Object)existingAPI.getLifecycleState()) ? !io.gravitee.rest.api.model.api.ApiLifecycleState.ARCHIVED.equals((Object)updateApiEntity.getLifecycleState()) : (io.gravitee.rest.api.model.api.ApiLifecycleState.UNPUBLISHED.equals((Object)existingAPI.getLifecycleState()) ? io.gravitee.rest.api.model.api.ApiLifecycleState.CREATED.equals((Object)updateApiEntity.getLifecycleState()) : io.gravitee.rest.api.model.api.ApiLifecycleState.CREATED.equals((Object)existingAPI.getLifecycleState()) && WorkflowState.IN_REVIEW.equals((Object)existingAPI.getWorkflowState()))) {
            throw new LifecycleStateChangeNotAllowedException(updateApiEntity.getLifecycleState().name());
        }
    }

    @Override
    public void delete(ExecutionContext executionContext, String apiId, boolean closePlans) {
        try {
            Set<String> plansNotClosed;
            log.debug("Delete API {}", (Object)apiId);
            io.gravitee.repository.management.model.Api api = (io.gravitee.repository.management.model.Api)this.apiRepository.findById((Object)apiId).orElseThrow(() -> new ApiNotFoundException(apiId));
            if (DefinitionContext.isManagement((String)api.getOrigin()) && api.getLifecycleState() == LifecycleState.STARTED) {
                throw new ApiRunningStateException(apiId);
            }
            Set<Object> plans = this.planService.findByApi(executionContext, apiId);
            if (closePlans) {
                plans = plans.stream().filter(plan -> plan.getStatus() != PlanStatus.CLOSED).map(plan -> this.planService.close(executionContext, plan.getId())).collect(Collectors.toSet());
            }
            if (!(plansNotClosed = plans.stream().filter(plan -> plan.getStatus() == PlanStatus.PUBLISHED).map(BasePlanEntity::getName).collect(Collectors.toSet())).isEmpty()) {
                throw new ApiNotDeletableException(plansNotClosed);
            }
            Collection<SubscriptionEntity> subscriptions = this.subscriptionService.findByApi(executionContext, apiId);
            subscriptions.forEach(sub -> this.subscriptionService.delete(executionContext, sub.getId()));
            log.debug("Delete {} plans for API {}", (Object)plans.size(), (Object)apiId);
            plans.forEach(plan -> this.planService.delete(executionContext, plan.getId()));
            log.debug("Delete flows for API {}", (Object)apiId);
            this.flowService.save(FlowReferenceType.API, apiId, null);
            log.debug("Delete events for API {}", (Object)apiId);
            this.eventService.deleteApiEvents(apiId);
            HashMap<String, String> properties = new HashMap<String, String>(2);
            if (this.getAuthenticatedUser() != null) {
                properties.put(Event.EventProperties.USER.getValue(), this.getAuthenticatedUser().getUsername());
            }
            if (!Origin.KUBERNETES.name().equalsIgnoreCase(api.getSyncFrom())) {
                this.eventService.createApiEvent(executionContext, Collections.singleton(executionContext.getEnvironmentId()), executionContext.getOrganizationId(), io.gravitee.rest.api.model.EventType.UNPUBLISH_API, apiId, properties);
            }
            log.debug("Delete pages for API {}", (Object)apiId);
            this.pageService.deleteAllByApi(executionContext, apiId);
            log.debug("Delete top API {}", (Object)apiId);
            this.topApiService.delete(executionContext, apiId);
            log.debug("Delete API {}", (Object)apiId);
            this.apiRepository.delete((Object)apiId);
            log.debug("Delete memberships for API {}", (Object)apiId);
            this.membershipService.deleteReference(executionContext, MembershipReferenceType.API, apiId);
            log.debug("Delete notifications for API {}", (Object)apiId);
            this.genericNotificationConfigService.deleteReference(NotificationReferenceType.API, apiId);
            this.portalNotificationConfigService.deleteReference(NotificationReferenceType.API, apiId);
            log.debug("Delete alerts for API {}", (Object)apiId);
            List<AlertTriggerEntity> alerts = this.alertService.findByReference(AlertReferenceType.API, apiId);
            alerts.forEach(alert -> this.alertService.delete(alert.getId(), alert.getReferenceId()));
            log.debug("Delete quality rules for API {}", (Object)apiId);
            this.apiQualityRuleRepository.deleteByApi(apiId);
            log.debug("Delete API categories order entries for API {}", (Object)apiId);
            this.apiCategoryService.deleteApiFromCategories(apiId);
            log.debug("Auditing deletion for API {}", (Object)apiId);
            this.auditService.createApiAuditLog(executionContext, apiId, Collections.emptyMap(), (Audit.AuditEvent)Api.AuditEvent.API_DELETED, new Date(), api, null);
            log.debug("Removing API {} from search engine", (Object)apiId);
            this.searchEngineService.delete(executionContext, (Indexable)this.convert(executionContext, api));
            log.info("Delete media for API {}", (Object)apiId);
            this.mediaService.deleteAllByApi(apiId);
            log.info("Delete API metadata for API {}", (Object)apiId);
            this.apiMetadataService.deleteAllByApi(executionContext, apiId);
        }
        catch (TechnicalException ex) {
            throw new TechnicalManagementException("An error occurs while trying to delete API " + apiId, ex);
        }
    }

    @Override
    public ApiEntity start(ExecutionContext executionContext, String apiId, String userId) {
        try {
            log.debug("Start API {}", (Object)apiId);
            ApiEntity apiEntity = this.updateLifecycle(executionContext, apiId, LifecycleState.STARTED, userId);
            GenericApiEntity apiWithMetadata = this.apiMetadataService.fetchMetadataForApi(executionContext, (GenericApiEntity)apiEntity);
            this.notifierService.trigger(executionContext, ApiHook.API_STARTED, apiId, new NotificationParamsBuilder().api(apiWithMetadata).user(this.userService.findById(executionContext, userId)).build());
            return apiEntity;
        }
        catch (TechnicalException ex) {
            throw new TechnicalManagementException(String.format("An error occurs while trying to start API %s", apiId), ex);
        }
    }

    @Override
    public ApiEntity stop(ExecutionContext executionContext, String apiId, String userId) {
        try {
            log.debug("Stop API {}", (Object)apiId);
            ApiEntity apiEntity = this.updateLifecycle(executionContext, apiId, LifecycleState.STOPPED, userId);
            GenericApiEntity apiWithMetadata = this.apiMetadataService.fetchMetadataForApi(executionContext, (GenericApiEntity)apiEntity);
            this.notifierService.trigger(executionContext, ApiHook.API_STOPPED, apiId, new NotificationParamsBuilder().api(apiWithMetadata).user(this.userService.findById(executionContext, userId)).build());
            return apiEntity;
        }
        catch (TechnicalException ex) {
            throw new TechnicalManagementException(String.format("An error occurs while trying to stop API %s", apiId), ex);
        }
    }

    @Override
    public boolean isSynchronized(ExecutionContext executionContext, String apiId) {
        try {
            log.debug("Check API {} state", (Object)apiId);
            ApiEntity api = this.findById(executionContext, apiId);
            if (api.getDefinitionContext().isOriginKubernetes()) {
                log.debug("API {} is managed by kubernetes. No synchronization allowed.", (Object)apiId);
                return true;
            }
            List events = this.eventLatestRepository.search(EventCriteria.builder().types(List.of(EventType.PUBLISH_API, EventType.START_API, EventType.STOP_API, EventType.UNPUBLISH_API)).properties(Map.of(Event.EventProperties.API_ID.getValue(), apiId)).build(), Event.EventProperties.API_ID, Long.valueOf(0L), Long.valueOf(1L));
            if (!events.isEmpty()) {
                Event lastEvent = (Event)events.get(0);
                boolean sync = false;
                if (EventType.PUBLISH_API.equals((Object)lastEvent.getType()) || EventType.STOP_API.equals((Object)lastEvent.getType()) || EventType.START_API.equals((Object)lastEvent.getType())) {
                    io.gravitee.repository.management.model.Api payloadEntity = (io.gravitee.repository.management.model.Api)this.objectMapper.readValue(lastEvent.getPayload(), io.gravitee.repository.management.model.Api.class);
                    ApiEntity deployedApi = this.convert(executionContext, payloadEntity, false);
                    log.debug("Remove policy description from sync check");
                    this.removeDescriptionFromPolicies(api);
                    this.removeDescriptionFromPolicies(deployedApi);
                    this.removeIdsFromFlows(api);
                    this.removeIdsFromFlows(deployedApi);
                    sync = this.synchronizationService.checkSynchronization(ApiEntity.class, deployedApi, api);
                    log.debug("API definition is {} synchronized.", (Object)(sync ? "" : "not "));
                    if (sync) {
                        log.debug("Check if there is any modification for API's plans (only for published or closed plan). API id: {}", (Object)apiId);
                        Set<PlanEntity> plans = this.planService.findByApi(executionContext, api.getId());
                        sync = plans.stream().noneMatch(plan -> plan.getStatus() != PlanStatus.STAGING && plan.getNeedRedeployAt().after(api.getDeployedAt()));
                    }
                }
                return sync;
            }
        }
        catch (Exception e) {
            log.error("An error occurs while trying to check API synchronization state {}", (Object)apiId, (Object)e);
        }
        return false;
    }

    private void removeIdsFromFlows(ApiEntity api) {
        api.getFlows().forEach(flow -> flow.setId(null));
        api.getPlans().forEach(plan -> plan.getFlows().forEach(flow -> flow.setId(null)));
    }

    private void removeDescriptionFromPolicies(ApiEntity api) {
        if (api.getPaths() != null) {
            api.getPaths().forEach((s, rules) -> {
                if (rules != null) {
                    rules.forEach(rule -> rule.setDescription(""));
                }
            });
        }
    }

    @Override
    public ApiEntity deploy(ExecutionContext executionContext, String apiId, String userId, io.gravitee.rest.api.model.EventType eventType, ApiDeploymentEntity apiDeploymentEntity) {
        try {
            log.debug("Deploy API : {}", (Object)apiId);
            return this.deployCurrentAPI(executionContext, apiId, userId, eventType, apiDeploymentEntity);
        }
        catch (Exception ex) {
            throw new TechnicalManagementException(String.format("An error occurs while trying to deploy API: %s", apiId), ex);
        }
    }

    @Override
    public ApiEntity rollback(ExecutionContext executionContext, String apiId, RollbackApiEntity rollbackApiEntity) {
        log.debug("Rollback API : {}", (Object)apiId);
        try {
            log.debug("Auditing rollback for API {}", (Object)apiId);
            this.auditService.createApiAuditLog(executionContext, apiId, Collections.emptyMap(), (Audit.AuditEvent)Api.AuditEvent.API_ROLLBACKED, new Date(), null, null);
            return this.apiDuplicatorService.updateWithImportedDefinition(executionContext, apiId, this.objectMapper.writeValueAsString((Object)rollbackApiEntity));
        }
        catch (Exception ex) {
            throw new TechnicalManagementException(String.format("An error occurs while trying to rollback API: %s", apiId), ex);
        }
    }

    private ApiEntity deployCurrentAPI(ExecutionContext executionContext, String apiId, String userId, io.gravitee.rest.api.model.EventType eventType, ApiDeploymentEntity apiDeploymentEntity) throws Exception {
        io.gravitee.repository.management.model.Api api = (io.gravitee.repository.management.model.Api)this.apiRepository.findById((Object)apiId).orElseThrow(() -> new ApiNotFoundException(apiId));
        log.debug("Add deployment date for API {}", (Object)apiId);
        api.setUpdatedAt(new Date());
        api.setDeployedAt(api.getUpdatedAt());
        api = (io.gravitee.repository.management.model.Api)this.apiRepository.update((Object)api);
        HashMap<String, String> properties = new HashMap<String, String>();
        properties.put(Event.EventProperties.USER.getValue(), userId);
        log.debug("Clear useless field for history");
        api.setPicture(null);
        this.addDeploymentLabelToProperties(executionContext, apiId, eventType, properties, apiDeploymentEntity);
        log.debug("Create API event for deployment");
        this.eventService.createApiEvent(executionContext, Collections.singleton(executionContext.getEnvironmentId()), executionContext.getOrganizationId(), eventType, api, properties);
        ApiEntity deployed = this.convert(executionContext, Collections.singletonList(api)).iterator().next();
        if (this.getAuthenticatedUser() != null && !this.getAuthenticatedUser().isSystem()) {
            GenericApiEntity apiWithMetadata = this.apiMetadataService.fetchMetadataForApi(executionContext, (GenericApiEntity)deployed);
            this.apiNotificationService.triggerDeployNotification(executionContext, apiWithMetadata);
        }
        return deployed;
    }

    private void addDeploymentLabelToProperties(ExecutionContext executionContext, String apiId, io.gravitee.rest.api.model.EventType eventType, Map<String, String> properties, ApiDeploymentEntity apiDeploymentEntity) {
        if (io.gravitee.rest.api.model.EventType.PUBLISH_API.equals((Object)eventType)) {
            EventCriteria criteria = EventCriteria.builder().types(Set.of(EventType.PUBLISH_API, EventType.STOP_API, EventType.START_API, EventType.UNPUBLISH_API)).property(Event.EventProperties.API_ID.getValue(), (Object)apiId).build();
            String lastDeployNumber = this.eventLatestRepository.search(criteria, Event.EventProperties.API_ID, Long.valueOf(0L), Long.valueOf(1L)).stream().findFirst().map(eventEntity -> eventEntity.getProperties().getOrDefault(Event.EventProperties.DEPLOYMENT_NUMBER.getValue(), "0")).orElse("0");
            String newDeployNumber = Long.toString(Long.parseLong(lastDeployNumber) + 1L);
            properties.put(Event.EventProperties.DEPLOYMENT_NUMBER.getValue(), newDeployNumber);
            if (apiDeploymentEntity != null && StringUtils.isNotEmpty((CharSequence)apiDeploymentEntity.getDeploymentLabel())) {
                properties.put(Event.EventProperties.DEPLOYMENT_LABEL.getValue(), apiDeploymentEntity.getDeploymentLabel());
            }
        }
    }

    private ApiEntity deployLastPublishedAPI(ExecutionContext executionContext, String apiId, String userId, io.gravitee.rest.api.model.EventType eventType) throws TechnicalException {
        EventQuery query = new EventQuery();
        query.setApi(apiId);
        query.setTypes(Collections.singleton(io.gravitee.rest.api.model.EventType.PUBLISH_API));
        if (executionContext.hasOrganizationId()) {
            query.setOrganizationIds(Set.of(executionContext.getOrganizationId()));
        }
        if (executionContext.hasEnvironmentId()) {
            query.setEnvironmentIds(Set.of(executionContext.getEnvironmentId()));
        }
        Optional<EventEntity> optEvent = this.eventService.search(executionContext, query).stream().max(Comparator.comparing(EventEntity::getCreatedAt));
        try {
            if (optEvent.isPresent()) {
                EventEntity event = optEvent.get();
                JsonNode node = this.objectMapper.readTree(event.getPayload());
                io.gravitee.repository.management.model.Api lastPublishedAPI = (io.gravitee.repository.management.model.Api)this.objectMapper.convertValue((Object)node, io.gravitee.repository.management.model.Api.class);
                lastPublishedAPI.setLifecycleState(this.convert(eventType));
                lastPublishedAPI.setUpdatedAt(new Date());
                lastPublishedAPI.setDeployedAt(new Date());
                HashMap<String, String> properties = new HashMap<String, String>();
                properties.put(Event.EventProperties.USER.getValue(), userId);
                properties.put(Event.EventProperties.DEPLOYMENT_NUMBER.getValue(), event.getProperties().getOrDefault(Event.EventProperties.DEPLOYMENT_NUMBER.getValue(), "0"));
                log.debug("Clear useless field for history");
                lastPublishedAPI.setPicture(null);
                log.debug("Creating event...");
                this.eventService.createApiEvent(executionContext, Collections.singleton(executionContext.getEnvironmentId()), executionContext.getOrganizationId(), eventType, lastPublishedAPI, properties);
                log.debug("Event created!");
                return null;
            }
            log.debug("Starting the API {} without previous deployment...", (Object)apiId);
            return this.deploy(executionContext, apiId, userId, io.gravitee.rest.api.model.EventType.PUBLISH_API, new ApiDeploymentEntity());
        }
        catch (Exception e) {
            throw new TechnicalException(String.format("An error occurs while trying to deploy last published API %s", apiId), (Throwable)e);
        }
    }

    @Override
    public String exportAsJson(ExecutionContext executionContext, String apiId, String exportVersion, String ... filteredFields) {
        ApiEntity apiEntity = this.findById(executionContext, apiId);
        log.debug("Set metadata for serialize process. API id:{}", (Object)apiId);
        HashMap<String, Object> metadata = new HashMap<String, Object>();
        metadata.put(ApiSerializer.METADATA_EXPORT_VERSION, exportVersion);
        metadata.put(ApiSerializer.METADATA_FILTERED_FIELDS_LIST, Arrays.asList(filteredFields));
        apiEntity.setMetadata(metadata);
        try {
            return this.objectMapper.writerWithDefaultPrettyPrinter().writeValueAsString((Object)apiEntity);
        }
        catch (Exception e) {
            log.error("An error occurs while trying to JSON serialize the API {}", (Object)apiEntity, (Object)e);
            return "";
        }
    }

    @Override
    public InlinePictureEntity getPicture(ExecutionContext executionContext, String apiId) {
        io.gravitee.repository.management.model.Api api = this.findApiById(executionContext, apiId);
        InlinePictureEntity imageEntity = new InlinePictureEntity();
        if (api.getPicture() != null) {
            String[] parts = api.getPicture().split(";", 2);
            imageEntity.setType(parts[0].split(":")[1]);
            String base64Content = api.getPicture().split(",", 2)[1];
            imageEntity.setContent(DatatypeConverter.parseBase64Binary((String)base64Content));
        } else {
            this.getDefaultPicture().ifPresent(content -> {
                imageEntity.setType("image/png");
                imageEntity.setContent(content);
            });
        }
        return imageEntity;
    }

    private Optional<byte[]> getDefaultPicture() {
        Optional<byte[]> content = Optional.empty();
        if (!Strings.isNullOrEmpty((String)this.defaultApiIcon)) {
            try {
                content = Optional.of(IOUtils.toByteArray((InputStream)new FileInputStream(this.defaultApiIcon)));
            }
            catch (IOException ioe) {
                log.error("Default icon for API does not exist", (Throwable)ioe);
            }
        }
        return content;
    }

    @Override
    public InlinePictureEntity getBackground(ExecutionContext executionContext, String apiId) {
        io.gravitee.repository.management.model.Api api = this.findApiById(executionContext, apiId);
        InlinePictureEntity imageEntity = new InlinePictureEntity();
        if (api.getBackground() != null) {
            String[] parts = api.getBackground().split(";", 2);
            imageEntity.setType(parts[0].split(":")[1]);
            String base64Content = api.getBackground().split(",", 2)[1];
            imageEntity.setContent(DatatypeConverter.parseBase64Binary((String)base64Content));
        }
        return imageEntity;
    }

    @Override
    public ApiEntity migrate(ExecutionContext executionContext, String apiId) {
        ApiEntity apiEntity = this.findById(executionContext, apiId);
        Set<PolicyEntity> policies = this.policyService.findAll();
        Set<PlanEntity> plans = this.planService.findByApi(executionContext, apiId);
        ApiEntity migratedApi = this.apiv1toAPIV2Converter.migrateToV2(apiEntity, policies, plans);
        return this.update(executionContext, apiId, this.apiConverter.toUpdateApiEntity(migratedApi));
    }

    @Override
    public ApiEntity importPathMappingsFromPage(ExecutionContext executionContext, ApiEntity apiEntity, String page, DefinitionVersion definitionVersion) {
        PageEntity pageEntity = this.pageService.findById(page);
        if (PageType.SWAGGER.name().equals(pageEntity.getType())) {
            ImportSwaggerDescriptorEntity importSwaggerDescriptorEntity = new ImportSwaggerDescriptorEntity();
            importSwaggerDescriptorEntity.setPayload(pageEntity.getContent());
            importSwaggerDescriptorEntity.setWithPathMapping(true);
            SwaggerApiEntity swaggerApiEntity = this.swaggerService.createAPI(executionContext, importSwaggerDescriptorEntity, definitionVersion);
            apiEntity.getPathMappings().addAll(swaggerApiEntity.getPathMappings());
        }
        return this.update(executionContext, apiEntity.getId(), this.apiConverter.toUpdateApiEntity(apiEntity));
    }

    @Override
    public Page<ApiEntity> search(ExecutionContext executionContext, ApiQuery query, Sortable sortable, Pageable pageable) {
        try {
            log.debug("Search paginated APIs by {}", (Object)query);
            Optional<Collection<String>> optionalTargetIds = this.searchInDefinition(executionContext, query);
            if (optionalTargetIds.isPresent()) {
                Collection<String> targetIds = optionalTargetIds.get();
                if (targetIds.isEmpty()) {
                    return new Page(Collections.emptyList(), 0, 0, 0L);
                }
                query.setIds(targetIds);
            }
            return this.convert(executionContext, (Page<io.gravitee.repository.management.model.Api>)this.apiRepository.search(this.queryToCriteria(executionContext, query).build(), ApiServiceImpl.convert(sortable), ApiServiceImpl.convert(pageable), new ApiFieldFilter.Builder().excludePicture().build()));
        }
        catch (TechnicalException ex) {
            throw new TechnicalManagementException(String.format("An error occurs while trying to search for paginated APIs: %s ", query), ex);
        }
    }

    private Page<ApiEntity> convert(ExecutionContext executionContext, Page<io.gravitee.repository.management.model.Api> page) throws TechnicalException {
        return new Page(this.convert(executionContext, page.getContent()), page.getPageNumber(), (int)page.getPageElements(), page.getTotalElements());
    }

    @Override
    public Collection<ApiEntity> search(ExecutionContext executionContext, ApiQuery query) {
        return this.apiSearchService.search(executionContext, query, true).stream().filter(ApiEntity.class::isInstance).map(c -> (ApiEntity)c).collect(Collectors.toList());
    }

    @Override
    public Page<String> searchIds(ExecutionContext executionContext, ApiQuery query, Pageable pageable, Sortable sortable) {
        try {
            log.debug("Search API ids by {}", (Object)query);
            ApiCriteria apiCriteria = this.queryToCriteria(executionContext, query).build();
            return this.apiRepository.searchIds(List.of(apiCriteria), ApiServiceImpl.convert(pageable), ApiServiceImpl.convert(sortable));
        }
        catch (Exception ex) {
            throw new TechnicalManagementException(String.format("An error occurs while trying to search for API ids: %s", query), ex);
        }
    }

    @Override
    public Page<ApiEntity> search(ExecutionContext executionContext, String query, Map<String, Object> filters, Sortable sortable, Pageable pageable) {
        try {
            log.debug("Search paged APIs by {}", (Object)query);
            Collection<String> apiIds = this.apiSearchService.searchIds(executionContext, query, filters, sortable, true);
            if (apiIds.isEmpty()) {
                return new Page(Collections.emptyList(), 0, 0, 0L);
            }
            return this.loadPage(executionContext, apiIds, pageable);
        }
        catch (TechnicalException ex) {
            throw new TechnicalManagementException("An error occurs while trying to search paged apis", ex);
        }
    }

    @Override
    public Collection<ApiEntity> search(ExecutionContext executionContext, String query, Map<String, Object> filters) {
        return this.searchInDefinition(executionContext, query, filters).getDocuments().stream().map(apiId -> this.findById(executionContext, (String)apiId)).collect(Collectors.toList());
    }

    private Optional<Collection<String>> searchInDefinition(ExecutionContext executionContext, ApiQuery apiQuery) {
        if (apiQuery == null) {
            return Optional.empty();
        }
        Query<ApiEntity> searchEngineQuery = this.convert(apiQuery).build();
        if (StringUtils.isBlank((CharSequence)searchEngineQuery.getQuery())) {
            return Optional.empty();
        }
        SearchResult matchApis = this.searchEngineService.search(executionContext, this.addDefaultExcludedFilters(searchEngineQuery));
        return Optional.of(matchApis.getDocuments());
    }

    private SearchResult searchInDefinition(ExecutionContext executionContext, String query, Map<String, Object> filters) {
        return this.searchInDefinition(executionContext, query, filters, null);
    }

    private SearchResult searchInDefinition(ExecutionContext executionContext, String query, Map<String, Object> filters, Sortable sortable) {
        Query<ApiEntity> searchEngineQuery = this.addDefaultExcludedFilters(QueryBuilder.create(ApiEntity.class).setQuery(query).setSort(sortable).setFilters(filters).build());
        return this.searchEngineService.search(executionContext, searchEngineQuery);
    }

    private QueryBuilder<ApiEntity> convert(ApiQuery query) {
        QueryBuilder<ApiEntity> searchEngineQuery = QueryBuilder.create(ApiEntity.class);
        if (query.getIds() != null && !query.getIds().isEmpty()) {
            HashMap<String, Object> filters = new HashMap<String, Object>();
            filters.put("api", query.getIds());
            searchEngineQuery.setFilters(filters);
        }
        if (!StringUtils.isBlank((CharSequence)query.getContextPath())) {
            searchEngineQuery.addExplicitFilter("paths", query.getContextPath());
        }
        if (!StringUtils.isBlank((CharSequence)query.getTag())) {
            searchEngineQuery.addExplicitFilter("tag", query.getTag());
        }
        return searchEngineQuery;
    }

    @Override
    public Collection<String> searchIds(ExecutionContext executionContext, String query, Map<String, Object> filters, Sortable sortable) {
        return this.apiSearchService.searchIds(executionContext, query, filters, sortable, true);
    }

    @Override
    public List<ApiHeaderEntity> getPortalHeaders(ExecutionContext executionContext, String apiId) {
        List<ApiHeaderEntity> entities = this.apiHeaderService.findAll(executionContext.getEnvironmentId());
        GenericApiModel genericApiModel = this.apiTemplateService.findByIdForTemplates(executionContext, apiId);
        HashMap<String, GenericApiModel> model = new HashMap<String, GenericApiModel>();
        model.put("api", genericApiModel);
        entities.forEach(entity -> {
            if (entity.getValue().contains("${")) {
                String entityValue = this.notificationTemplateService.resolveInlineTemplateWithParam(executionContext.getOrganizationId(), entity.getId() + entity.getUpdatedAt().toString(), entity.getValue(), (Object)model);
                entity.setValue(entityValue);
            }
        });
        return entities.stream().filter(apiHeaderEntity -> apiHeaderEntity.getValue() != null && !apiHeaderEntity.getValue().isEmpty()).collect(Collectors.toList());
    }

    @Override
    public ApiEntity askForReview(ExecutionContext executionContext, String apiId, String userId, ReviewEntity reviewEntity) {
        log.debug("Ask for review API {}", (Object)apiId);
        return this.updateWorkflowReview(executionContext, apiId, userId, ApiHook.ASK_FOR_REVIEW, WorkflowState.IN_REVIEW, reviewEntity.getMessage());
    }

    @Override
    public ApiEntity acceptReview(ExecutionContext executionContext, String apiId, String userId, ReviewEntity reviewEntity) {
        log.debug("Accept review API {}", (Object)apiId);
        return this.updateWorkflowReview(executionContext, apiId, userId, ApiHook.REVIEW_OK, WorkflowState.REVIEW_OK, reviewEntity.getMessage());
    }

    @Override
    public ApiEntity rejectReview(ExecutionContext executionContext, String apiId, String userId, ReviewEntity reviewEntity) {
        log.debug("Reject review API {}", (Object)apiId);
        return this.updateWorkflowReview(executionContext, apiId, userId, ApiHook.REQUEST_FOR_CHANGES, WorkflowState.REQUEST_FOR_CHANGES, reviewEntity.getMessage());
    }

    @Override
    public boolean hasHealthCheckEnabled(ApiEntity api, boolean mustBeEnabledOnAllEndpoints) {
        boolean globalHC;
        boolean bl = globalHC = api.getServices() != null && api.getServices().getAll() != null && api.getServices().getAll().stream().anyMatch(service -> service.isEnabled() && service instanceof HealthCheckService);
        if (globalHC) {
            return true;
        }
        Predicate<Endpoint> endpointHealthCheckEnabledPredicate = endpoint -> {
            if (this.isHttpEndpoint((Endpoint)endpoint)) {
                return endpoint.getHealthCheck() != null && endpoint.getHealthCheck().isEnabled();
            }
            return false;
        };
        if (mustBeEnabledOnAllEndpoints) {
            return api.getProxy().getGroups().stream().allMatch(group -> group.getEndpoints().stream().allMatch(endpointHealthCheckEnabledPredicate));
        }
        return api.getProxy() != null && api.getProxy().getGroups() != null && api.getProxy().getGroups().stream().anyMatch(group -> group.getEndpoints() != null && group.getEndpoints().stream().anyMatch(endpointHealthCheckEnabledPredicate));
    }

    private ApiEntity updateWorkflowReview(ExecutionContext executionContext, String apiId, String userId, ApiHook hook, WorkflowState workflowState, String workflowMessage) {
        Workflow workflow = this.workflowService.create(WorkflowReferenceType.API, apiId, WorkflowType.REVIEW, userId, workflowState, workflowMessage);
        ApiEntity apiEntity = this.findById(executionContext, apiId);
        apiEntity.setWorkflowState(workflowState);
        UserEntity user = this.userService.findById(executionContext, userId);
        GenericApiEntity apiWithMetadata = this.apiMetadataService.fetchMetadataForApi(executionContext, (GenericApiEntity)apiEntity);
        this.notifierService.trigger(executionContext, hook, apiId, new NotificationParamsBuilder().api(apiWithMetadata).user(user).build());
        if (hook.equals(ApiHook.ASK_FOR_REVIEW)) {
            List<String> reviewersEmail = this.findAllReviewersEmail(executionContext, apiId);
            this.emailService.sendAsyncEmailNotification(executionContext, new EmailNotificationBuilder().params(new NotificationParamsBuilder().api(apiEntity).user(user).build()).to(reviewersEmail.toArray(new String[reviewersEmail.size()])).template(EmailNotificationBuilder.EmailTemplate.API_ASK_FOR_REVIEW).build());
        }
        HashMap<Audit.AuditProperties, String> properties = new HashMap<Audit.AuditProperties, String>();
        properties.put(Audit.AuditProperties.USER, userId);
        properties.put(Audit.AuditProperties.API, apiId);
        Workflow.AuditEvent evtType = null;
        switch (workflowState) {
            case REQUEST_FOR_CHANGES: {
                evtType = Workflow.AuditEvent.API_REVIEW_REJECTED;
                break;
            }
            case REVIEW_OK: {
                evtType = Workflow.AuditEvent.API_REVIEW_ACCEPTED;
                break;
            }
            default: {
                evtType = Workflow.AuditEvent.API_REVIEW_ASKED;
            }
        }
        this.auditService.createApiAuditLog(executionContext, apiId, properties, (Audit.AuditEvent)evtType, new Date(), null, workflow);
        return apiEntity;
    }

    private List<String> findAllReviewersEmail(ExecutionContext executionContext, String apiId) {
        RolePermissionAction[] acls = new RolePermissionAction[]{RolePermissionAction.UPDATE};
        boolean isTrialInstance = this.parameterService.findAsBoolean(executionContext, Key.TRIAL_INSTANCE, ParameterReferenceType.SYSTEM);
        Predicate<UserEntity> excludeIfTrialAndNotOptedIn = userEntity -> !isTrialInstance || userEntity.optedIn();
        Set reviewerEmails = this.roleService.findByScope(RoleScope.API, executionContext.getOrganizationId()).stream().filter(role -> this.roleService.hasPermission(role.getPermissions(), (Permission)ApiPermission.REVIEWS, acls)).flatMap(role -> this.membershipService.getMembershipsByReferenceAndRole(MembershipReferenceType.API, apiId, role.getId()).stream()).filter(m -> m.getMemberType().equals((Object)MembershipMemberType.USER)).map(MembershipEntity::getMemberId).distinct().map(id -> this.userService.findById(executionContext, (String)id)).filter(excludeIfTrialAndNotOptedIn).map(UserEntity::getEmail).filter(Objects::nonNull).collect(Collectors.toSet());
        Set groups = this.findById(executionContext, apiId).getGroups();
        if (groups != null && !groups.isEmpty()) {
            groups.forEach(group -> reviewerEmails.addAll(this.roleService.findByScope(RoleScope.API, executionContext.getOrganizationId()).stream().filter(role -> this.roleService.hasPermission(role.getPermissions(), (Permission)ApiPermission.REVIEWS, acls)).flatMap(role -> this.membershipService.getMembershipsByReferenceAndRole(MembershipReferenceType.GROUP, (String)group, role.getId()).stream()).filter(m -> m.getMemberType().equals((Object)MembershipMemberType.USER)).map(MembershipEntity::getMemberId).distinct().map(id -> this.userService.findById(executionContext, (String)id)).filter(excludeIfTrialAndNotOptedIn).map(UserEntity::getEmail).filter(Objects::nonNull).collect(Collectors.toSet())));
        }
        return new ArrayList<String>(reviewerEmails);
    }

    private ApiCriteria.Builder queryToCriteria(ExecutionContext executionContext, ApiQuery query) {
        ApiCriteria.Builder builder = this.getDefaultApiCriteriaBuilder().environmentId(executionContext.getEnvironmentId());
        if (query == null) {
            return builder;
        }
        builder.label(query.getLabel()).name(query.getName()).version(query.getVersion());
        if (!StringUtils.isBlank((CharSequence)query.getCategory())) {
            builder.category(this.categoryService.findById(query.getCategory(), executionContext.getEnvironmentId()).getId());
        }
        if (query.getGroups() != null && !query.getGroups().isEmpty()) {
            builder.groups((Collection)query.getGroups());
        }
        if (!StringUtils.isBlank((CharSequence)query.getState())) {
            builder.state(LifecycleState.valueOf((String)query.getState()));
        }
        if (query.getVisibility() != null) {
            builder.visibility(Visibility.valueOf((String)query.getVisibility().name()));
        }
        if (query.getLifecycleStates() != null) {
            builder.lifecycleStates(query.getLifecycleStates().stream().map(apiLifecycleState -> ApiLifecycleState.valueOf((String)apiLifecycleState.name())).collect(Collectors.toList()));
        }
        if (query.getIds() != null && !query.getIds().isEmpty()) {
            builder.ids(query.getIds());
        }
        if (query.getCrossId() != null && !query.getCrossId().isEmpty()) {
            builder.crossId(query.getCrossId());
        }
        return builder;
    }

    private ApiEntity updateLifecycle(ExecutionContext executionContext, String apiId, LifecycleState lifecycleState, String username) throws TechnicalException {
        Optional optApi = this.apiRepository.findById((Object)apiId);
        if (optApi.isPresent()) {
            io.gravitee.repository.management.model.Api api = (io.gravitee.repository.management.model.Api)optApi.get();
            io.gravitee.repository.management.model.Api previousApi = new io.gravitee.repository.management.model.Api(api);
            api.setUpdatedAt(new Date());
            api.setLifecycleState(lifecycleState);
            ApiEntity apiEntity = this.convert(executionContext, (io.gravitee.repository.management.model.Api)this.apiRepository.update((Object)api), this.getPrimaryOwner(executionContext, api));
            this.auditService.createApiAuditLog(executionContext, apiId, Collections.emptyMap(), (Audit.AuditEvent)Api.AuditEvent.API_UPDATED, api.getUpdatedAt(), previousApi, api);
            io.gravitee.rest.api.model.EventType eventType = null;
            switch (lifecycleState) {
                case STARTED: {
                    eventType = io.gravitee.rest.api.model.EventType.START_API;
                    break;
                }
                case STOPPED: {
                    eventType = io.gravitee.rest.api.model.EventType.STOP_API;
                    break;
                }
            }
            ApiEntity deployedApi = this.deployLastPublishedAPI(executionContext, apiId, username, eventType);
            if (deployedApi != null) {
                return deployedApi;
            }
            return apiEntity;
        }
        throw new ApiNotFoundException(apiId);
    }

    private void auditApiLogging(ExecutionContext executionContext, io.gravitee.repository.management.model.Api apiToUpdate, io.gravitee.repository.management.model.Api apiUpdated) {
        log.debug("Logging Audit API...");
        try {
            Api apiToUpdateDefinition = (Api)this.objectMapper.readValue(apiToUpdate.getDefinition(), Api.class);
            Logging loggingToUpdate = apiToUpdateDefinition.getProxy().getLogging();
            Api apiUpdatedDefinition = (Api)this.objectMapper.readValue(apiUpdated.getDefinition(), Api.class);
            Logging loggingUpdated = apiUpdatedDefinition.getProxy().getLogging();
            if (loggingToUpdate == loggingUpdated || loggingToUpdate != null && loggingUpdated != null && Objects.equals(loggingToUpdate.getMode(), loggingUpdated.getMode()) && Objects.equals(loggingToUpdate.getCondition(), loggingUpdated.getCondition())) {
                return;
            }
            Api.AuditEvent auditEvent = (loggingToUpdate == null || loggingToUpdate.getMode().equals((Object)LoggingMode.NONE)) && loggingUpdated != null && !loggingUpdated.getMode().equals((Object)LoggingMode.NONE) ? Api.AuditEvent.API_LOGGING_ENABLED : (loggingToUpdate != null && !loggingToUpdate.getMode().equals((Object)LoggingMode.NONE) && (loggingUpdated == null || loggingUpdated.getMode().equals((Object)LoggingMode.NONE)) ? Api.AuditEvent.API_LOGGING_DISABLED : Api.AuditEvent.API_LOGGING_UPDATED);
            this.auditService.createApiAuditLog(executionContext, apiUpdated.getId(), Collections.emptyMap(), (Audit.AuditEvent)auditEvent, new Date(), loggingToUpdate, loggingUpdated);
        }
        catch (Exception ex) {
            throw new TechnicalManagementException(String.format("An error occurs while auditing API logging configuration for API: %s", apiUpdated.getId()), ex);
        }
    }

    private List<ApiEntity> convert(ExecutionContext executionContext, List<io.gravitee.repository.management.model.Api> apis) {
        if (apis == null || apis.isEmpty()) {
            return Collections.emptyList();
        }
        List<String> apiIds = apis.stream().map(io.gravitee.repository.management.model.Api::getId).collect(Collectors.toList());
        Map<String, PrimaryOwnerEntity> primaryOwners = this.primaryOwnerService.getPrimaryOwners(executionContext, apiIds);
        Set apiWithoutPo = apiIds.stream().filter(apiId -> !primaryOwners.containsKey(apiId)).collect(Collectors.toSet());
        Stream<Object> streamApis = apis.stream();
        if (!apiWithoutPo.isEmpty()) {
            String apisAsString = String.join((CharSequence)" / ", apiWithoutPo);
            log.error("{} apis has no identified primary owners in this list {}.", (Object)apiWithoutPo.size(), (Object)apisAsString);
            streamApis = streamApis.filter(api -> !apiIds.contains(api.getId()));
        }
        return streamApis.map(publicApi -> this.convert(executionContext, (io.gravitee.repository.management.model.Api)publicApi, (PrimaryOwnerEntity)primaryOwners.get(publicApi.getId()))).collect(Collectors.toList());
    }

    private ApiEntity convert(ExecutionContext executionContext, io.gravitee.repository.management.model.Api api) {
        return this.convert(executionContext, api, true);
    }

    public ApiEntity convert(ExecutionContext executionContext, io.gravitee.repository.management.model.Api api, boolean readDatabaseFlows) {
        return this.apiConverter.toApiEntity(executionContext, api, null, readDatabaseFlows);
    }

    public ApiEntity convert(ExecutionContext executionContext, io.gravitee.repository.management.model.Api api, PrimaryOwnerEntity primaryOwner) {
        return this.apiConverter.toApiEntity(executionContext, api, primaryOwner, true);
    }

    private io.gravitee.repository.management.model.Api convert(ExecutionContext executionContext, String apiId, UpdateApiEntity updateApiEntity, String apiDefinition) {
        io.gravitee.repository.management.model.Api api = new io.gravitee.repository.management.model.Api();
        api.setId(apiId.trim());
        api.setCrossId(updateApiEntity.getCrossId());
        if (updateApiEntity.getVisibility() != null) {
            api.setVisibility(Visibility.valueOf((String)updateApiEntity.getVisibility().toString()));
        }
        if (updateApiEntity.getDefinitionContext() != null) {
            api.setOrigin(updateApiEntity.getDefinitionContext().getOrigin());
            api.setMode(updateApiEntity.getDefinitionContext().getMode());
            api.setSyncFrom(updateApiEntity.getDefinitionContext().getSyncFrom());
        }
        api.setVersion(updateApiEntity.getVersion().trim());
        api.setName(updateApiEntity.getName().trim());
        api.setDescription(updateApiEntity.getDescription().trim());
        api.setPicture(updateApiEntity.getPicture());
        api.setBackground(updateApiEntity.getBackground());
        api.setDefinition(this.buildApiDefinition(apiId, apiDefinition, updateApiEntity));
        api.setCategories(this.categoryMapper.toCategoryId(executionContext.getEnvironmentId(), updateApiEntity.getCategories()));
        if (updateApiEntity.getLabels() != null) {
            api.setLabels(new ArrayList(new HashSet(updateApiEntity.getLabels())));
        }
        api.setGroups((Collection)updateApiEntity.getGroups());
        api.setDisableMembershipNotifications(updateApiEntity.isDisableMembershipNotifications());
        if (updateApiEntity.getLifecycleState() != null) {
            api.setApiLifecycleState(ApiLifecycleState.valueOf((String)updateApiEntity.getLifecycleState().name()));
        }
        api.setLifecycleState(updateApiEntity.getState() != null ? LifecycleState.valueOf((String)updateApiEntity.getState().name()) : LifecycleState.STOPPED);
        return api;
    }

    private LifecycleState convert(io.gravitee.rest.api.model.EventType eventType) {
        return switch (eventType) {
            case io.gravitee.rest.api.model.EventType.START_API -> LifecycleState.STARTED;
            case io.gravitee.rest.api.model.EventType.STOP_API -> LifecycleState.STOPPED;
            default -> throw new IllegalArgumentException("Unknown EventType " + eventType + " to convert EventType into Lifecycle");
        };
    }

    private Page<ApiEntity> loadPage(ExecutionContext executionContext, Collection<String> apiIds, Pageable pageable) throws TechnicalException {
        pageable = this.buildPageable(pageable);
        int totalCount = apiIds.size();
        int startIndex = (pageable.getPageNumber() - 1) * pageable.getPageSize();
        if (pageable.getPageNumber() < 1 || totalCount > 0 && startIndex >= totalCount) {
            throw new PaginationInvalidException();
        }
        List subsetApiIds = apiIds.stream().skip(startIndex).limit(pageable.getPageSize()).collect(Collectors.toList());
        Comparator<String> orderingComparator = Comparator.comparingInt(subsetApiIds::indexOf);
        List subsetApis = subsetApiIds.isEmpty() ? Collections.emptyList() : this.convert(executionContext, this.apiRepository.search(new ApiCriteria.Builder().environmentId(executionContext.getEnvironmentId()).ids(subsetApiIds).build(), null, new PageableBuilder().pageNumber(0).pageSize(subsetApiIds.size()).build(), ApiFieldFilter.allFields()).getContent());
        subsetApis.sort((o1, o2) -> orderingComparator.compare(o1.getId(), o2.getId()));
        return new Page(subsetApis, pageable.getPageNumber(), pageable.getPageSize(), (long)apiIds.size());
    }

    private Pageable buildPageable(Pageable pageable) {
        if (pageable == null) {
            return new PageableImpl(1, Integer.MAX_VALUE);
        }
        return pageable;
    }

    protected void encryptProperties(List<PropertyEntity> properties) {
        for (PropertyEntity property : properties) {
            if (!property.isEncryptable() || property.isEncrypted()) continue;
            try {
                property.setValue(this.dataEncryptor.encrypt(property.getValue()));
                property.setEncrypted(true);
            }
            catch (GeneralSecurityException e) {
                log.error("Error encrypting property value", (Throwable)e);
            }
        }
    }

    @Override
    public long countByCategoryForUser(ExecutionContext executionContext, String categoryId, String userId) {
        List<ApiCriteria> apiCriteriaList;
        if (this.isEnvironmentAdmin()) {
            apiCriteriaList = List.of(new ApiCriteria.Builder().category(categoryId).build());
        } else {
            ApiQuery apiQuery = new ApiQuery();
            apiQuery.setCategory(categoryId);
            apiCriteriaList = this.apiAuthorizationService.computeApiCriteriaForUser(executionContext, userId, apiQuery, true);
        }
        PageableImpl pageable = new PageableImpl(1, Integer.MAX_VALUE);
        List apiIds = this.apiRepository.searchIds(apiCriteriaList, ApiServiceImpl.convert((Pageable)pageable), null).getContent();
        return apiIds == null ? 0L : (long)apiIds.size();
    }

    @NotNull
    private ApiCriteria.Builder getDefaultApiCriteriaBuilder() {
        return new ApiCriteria.Builder().definitionVersion(ApiServiceImpl.getAllowedDefinitionVersion());
    }

    @NotNull
    private static List<DefinitionVersion> getAllowedDefinitionVersion() {
        ArrayList<DefinitionVersion> allowedDefinitionVersion = new ArrayList<DefinitionVersion>();
        allowedDefinitionVersion.add(null);
        allowedDefinitionVersion.add(DefinitionVersion.V1);
        allowedDefinitionVersion.add(DefinitionVersion.V2);
        return allowedDefinitionVersion;
    }

    private Query<ApiEntity> addDefaultExcludedFilters(Query<ApiEntity> searchEngineQuery) {
        searchEngineQuery.getExcludedFilters().put("definition_version", Collections.singletonList(DefinitionVersion.V4.getLabel()));
        return searchEngineQuery;
    }
}

