/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.apim.core.api.domain_service;

import io.gravitee.apim.core.DomainService;
import io.gravitee.apim.core.api.domain_service.ApiHostValidatorDomainService;
import io.gravitee.apim.core.api.exception.InvalidPathsException;
import io.gravitee.apim.core.api.model.Api;
import io.gravitee.apim.core.api.model.ApiFieldFilter;
import io.gravitee.apim.core.api.model.ApiSearchCriteria;
import io.gravitee.apim.core.api.model.Path;
import io.gravitee.apim.core.api.query_service.ApiQueryService;
import io.gravitee.apim.core.installation.model.RestrictedDomain;
import io.gravitee.apim.core.installation.query_service.InstallationAccessQueryService;
import io.gravitee.apim.core.utils.CollectionUtils;
import io.gravitee.apim.core.utils.StringUtils;
import io.gravitee.apim.core.validation.Validator;
import io.gravitee.definition.model.DefinitionVersion;
import io.gravitee.definition.model.v4.listener.http.HttpListener;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@DomainService
public class VerifyApiPathDomainService
implements Validator<Input> {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(VerifyApiPathDomainService.class);
    private final ApiQueryService apiSearchService;
    private final InstallationAccessQueryService installationAccessQueryService;
    private final ApiHostValidatorDomainService apiHostValidatorDomainService;

    public VerifyApiPathDomainService(ApiQueryService apiSearchService, InstallationAccessQueryService installationAccessQueryService, ApiHostValidatorDomainService apiHostValidatorDomainService) {
        this.apiSearchService = apiSearchService;
        this.installationAccessQueryService = installationAccessQueryService;
        this.apiHostValidatorDomainService = apiHostValidatorDomainService;
    }

    @Override
    public Validator.Result<Input> validateAndSanitize(Input input) {
        log.debug("Format context-path and check if context path is unique for API {}", (Object)input.apiId);
        if (CollectionUtils.isEmpty(input.paths)) {
            return Validator.Result.ofErrors(List.of(Validator.Error.severe("HTTP listener requires a minimum of one path", new Object[0])));
        }
        List<Path.PathBuilder> sanitizedBuilder = input.paths.stream().map(Path::toBuilder).toList();
        ArrayList<Validator.Error> errors = new ArrayList<Validator.Error>();
        errors.addAll(this.invalidPathErrors(sanitizedBuilder));
        errors.addAll(this.duplicatePathErrors(sanitizedBuilder));
        errors.addAll(this.invalidDomainErrors(input.environmentId, sanitizedBuilder));
        errors.addAll(this.unavailablePathErrors(input, sanitizedBuilder));
        List<Path> sanitized = sanitizedBuilder.stream().map(Path.PathBuilder::build).toList();
        return Validator.Result.ofBoth(new Input(input.environmentId, input.apiId, sanitized), errors);
    }

    private List<Validator.Error> invalidDomainErrors(String environmentId, List<Path.PathBuilder> sanitizedBuilder) throws InvalidPathsException {
        ArrayList<Validator.Error> errors = new ArrayList<Validator.Error>();
        List<RestrictedDomain> restrictedDomains = this.installationAccessQueryService.getGatewayRestrictedDomains(environmentId);
        if (CollectionUtils.isNotEmpty(restrictedDomains)) {
            for (Path.PathBuilder builder2 : sanitizedBuilder) {
                if (!builder2.build().hasHost()) continue;
                this.invalidDomainError(builder2.build(), restrictedDomains).ifPresent(errors::add);
            }
            if (sanitizedBuilder.stream().noneMatch(builder -> builder.build().isOverrideAccess())) {
                sanitizedBuilder.stream().findFirst().ifPresent(builder -> builder.overrideAccess(true));
            }
        }
        return errors;
    }

    private Optional<Validator.Error> invalidDomainError(Path path, List<RestrictedDomain> restrictedDomains) {
        String hostWithoutPort = VerifyApiPathDomainService.extractHost(path.getHost());
        String hostPort = VerifyApiPathDomainService.extractPort(path.getHost());
        List<String> restrictedDomainsWithoutPort = restrictedDomains.stream().map(restrictedDomainEntity -> VerifyApiPathDomainService.extractHost(restrictedDomainEntity.getDomain())).toList();
        boolean isValidDomain = this.apiHostValidatorDomainService.isValidDomainOrSubDomain(hostWithoutPort, restrictedDomainsWithoutPort);
        boolean isValidPort = VerifyApiPathDomainService.isValidPort(hostPort, restrictedDomains);
        if (!isValidDomain || !isValidPort) {
            return Optional.of(Validator.Error.severe("Domain [%s] is invalid", path.getHost()));
        }
        return Optional.empty();
    }

    private List<Validator.Error> unavailablePathErrors(Input input, List<Path.PathBuilder> sanitizedBuilder) {
        ArrayList<Validator.Error> errors = new ArrayList<Validator.Error>();
        this.apiSearchService.search(ApiSearchCriteria.builder().environmentId(input.environmentId).definitionVersion(List.of(DefinitionVersion.V2, DefinitionVersion.V4)).build(), null, ApiFieldFilter.builder().pictureExcluded(true).build()).filter(api -> !api.getId().equals(input.apiId)).map(VerifyApiPathDomainService::extractPaths).filter(CollectionUtils::isNotEmpty).forEach(existingPaths -> {
            List<Path> paths = sanitizedBuilder.stream().map(Path.PathBuilder::build).toList();
            Map<String, List<String>> pathsWithHost = VerifyApiPathDomainService.getPathsWithHost(paths);
            Map<String, List<String>> existingPathsWithHost = VerifyApiPathDomainService.getPathsWithHost(existingPaths);
            pathsWithHost.forEach((host, hostPaths) -> hostPaths.forEach(hostPath -> {
                List<String> existingHostPaths = existingPathsWithHost.getOrDefault(host, List.of());
                this.findConflictingPathError((String)hostPath, existingHostPaths).ifPresent(errors::add);
            }));
            List<String> pathsWithoutHosts = VerifyApiPathDomainService.getPathsWithoutHost(paths);
            List<String> existingPathsWithoutHost = VerifyApiPathDomainService.getPathsWithoutHost(existingPaths);
            pathsWithoutHosts.forEach(path -> this.findConflictingPathError((String)path, existingPathsWithoutHost).ifPresent(errors::add));
        });
        return errors;
    }

    private Optional<Validator.Error> findConflictingPathError(String path, List<String> existingPaths) {
        return existingPaths.stream().findFirst().filter(existingPath -> existingPath.startsWith(path) || path.startsWith((String)existingPath)).map(conflictingPath -> Validator.Error.severe("Path [%s] already exists", conflictingPath));
    }

    private List<Validator.Error> invalidPathErrors(List<Path.PathBuilder> sanitizedBuilder) {
        ArrayList<Validator.Error> errors = new ArrayList<Validator.Error>();
        sanitizedBuilder.forEach(builder -> {
            Path path = builder.build();
            try {
                Path sanitized = path.sanitize();
                builder.path(sanitized.getPath());
            }
            catch (InvalidPathsException e) {
                errors.add(Validator.Error.severe("Path [%s] is invalid", path.getPath()));
            }
        });
        return errors;
    }

    private List<Validator.Error> duplicatePathErrors(List<Path.PathBuilder> sanitizedBuilder) {
        HashSet seen = new HashSet();
        return sanitizedBuilder.stream().map(Path.PathBuilder::build).filter(path -> !seen.add(path)).map(duplicate -> Validator.Error.severe("Path [%s] is duplicated", duplicate.getPath())).toList();
    }

    private static Map<String, List<String>> getPathsWithHost(List<Path> paths) {
        return paths.stream().filter(path -> StringUtils.isNotEmpty(path.getHost())).collect(Collectors.groupingBy(Path::getHost, Collectors.mapping(Path::getPath, Collectors.toList())));
    }

    private static List<String> getPathsWithoutHost(List<Path> paths) {
        return paths.stream().filter(path -> StringUtils.isEmpty(path.getHost())).map(Path::getPath).toList();
    }

    private static List<Path> extractPaths(Api api) {
        return api.getDefinitionVersion() == DefinitionVersion.V4 ? VerifyApiPathDomainService.getV4Paths(api) : VerifyApiPathDomainService.getV2Paths(api);
    }

    private static List<Path> getV4Paths(Api api) {
        return api.getApiDefinitionV4().getListeners().stream().filter(HttpListener.class::isInstance).map(HttpListener.class::cast).flatMap(httpListener -> httpListener.getPaths().stream().map(path -> Path.builder().host(path.getHost()).path(path.getPath()).overrideAccess(path.isOverrideAccess()).build().sanitize())).toList();
    }

    private static List<Path> getV2Paths(Api api) {
        return api.getApiDefinition().getProxy().getVirtualHosts().stream().map(virtualHost -> Path.builder().host(virtualHost.getHost()).path(virtualHost.getPath()).overrideAccess(virtualHost.isOverrideEntrypoint()).build().sanitize()).toList();
    }

    private static boolean isValidPort(String port, List<RestrictedDomain> restrictedDomainEntities) {
        return restrictedDomainEntities.stream().anyMatch(restrictedDomainEntity -> {
            String restrictedDomain = restrictedDomainEntity.getDomain();
            String restrictedPort = VerifyApiPathDomainService.extractPort(restrictedDomain);
            return VerifyApiPathDomainService.isValidPort(port, restrictedPort);
        });
    }

    private static boolean isValidPort(String port, String restrictedPort) {
        if (port == null && restrictedPort == null) {
            return true;
        }
        if (port == null && VerifyApiPathDomainService.isDefaultHttp(restrictedPort)) {
            return true;
        }
        if (restrictedPort == null && VerifyApiPathDomainService.isDefaultHttp(port)) {
            return true;
        }
        return Objects.equals(port, restrictedPort);
    }

    private static boolean isDefaultHttp(String domainRestrictionOnlyPort) {
        return "80".equals(domainRestrictionOnlyPort) || "443".equals(domainRestrictionOnlyPort);
    }

    private static String extractHost(String hostAndPort) {
        return hostAndPort.split(":")[0];
    }

    private static String extractPort(String hostAndPort) {
        String[] split = hostAndPort.split(":");
        if (split.length > 1) {
            return split[1];
        }
        return null;
    }

    public record Input(String environmentId, String apiId, List<Path> paths) implements Validator.Input
    {
    }
}

