/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.apim.infra.crud_service.environment;

import io.gravitee.apim.core.environment.crud_service.EnvironmentCrudService;
import io.gravitee.apim.core.environment.model.Environment;
import io.gravitee.apim.infra.adapter.EnvironmentAdapter;
import io.gravitee.repository.exceptions.TechnicalException;
import io.gravitee.repository.management.api.EnvironmentRepository;
import io.gravitee.rest.api.service.exceptions.EnvironmentNotFoundException;
import io.gravitee.rest.api.service.exceptions.TechnicalManagementException;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Service;

@Service
public class EnvironmentCrudServiceImpl
implements EnvironmentCrudService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(EnvironmentCrudServiceImpl.class);
    private final EnvironmentRepository environmentRepository;

    public EnvironmentCrudServiceImpl(@Lazy EnvironmentRepository environmentRepository) {
        this.environmentRepository = environmentRepository;
    }

    @Override
    public Environment get(String environmentId) {
        try {
            log.debug("Find environment by id: {}", (Object)environmentId);
            return this.environmentRepository.findById((Object)environmentId).map(EnvironmentAdapter.INSTANCE::toModel).orElseThrow(() -> new EnvironmentNotFoundException(environmentId));
        }
        catch (TechnicalException e) {
            throw new TechnicalManagementException(String.format("An error occurred while finding Environment with id %s", environmentId), e);
        }
    }
}

