/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.apim.infra.crud_service.plugin;

import io.gravitee.apim.core.plugin.crud_service.ResourcePluginCrudService;
import io.gravitee.apim.core.plugin.model.ResourcePlugin;
import io.gravitee.apim.infra.adapter.ResourcePluginAdapter;
import io.gravitee.rest.api.model.platform.plugin.PlatformPluginEntity;
import io.gravitee.rest.api.service.ResourceService;
import io.gravitee.rest.api.service.exceptions.PluginNotFoundException;
import java.util.Optional;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Component;

@Component
public class ResourceCrudServiceImpl
implements ResourcePluginCrudService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ResourceCrudServiceImpl.class);
    private final ResourceService resourceService;

    public ResourceCrudServiceImpl(@Lazy ResourceService resourceService) {
        this.resourceService = resourceService;
    }

    @Override
    public Optional<ResourcePlugin> get(String resourceId) {
        log.debug("Find resource by id : {}", (Object)resourceId);
        try {
            return Optional.of(ResourcePluginAdapter.INSTANCE.map((PlatformPluginEntity)this.resourceService.findById(resourceId)));
        }
        catch (PluginNotFoundException e) {
            throw new PluginNotFoundException(String.format("An error occurred while finding Plugin with id %s", resourceId));
        }
    }
}

