/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.apim.infra.converter.oai;

import io.gravitee.definition.model.v4.listener.Listener;
import io.gravitee.definition.model.v4.listener.entrypoint.Entrypoint;
import io.gravitee.definition.model.v4.listener.http.HttpListener;
import io.gravitee.definition.model.v4.listener.http.Path;
import io.gravitee.rest.api.service.swagger.converter.extension.VirtualHost;
import io.gravitee.rest.api.service.swagger.converter.extension.XGraviteeIODefinition;
import java.net.URI;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import lombok.Generated;

public class OAIToListenersConverter {
    public static OAIToListenersConverter INSTANCE = new OAIToListenersConverter();
    private static final String DEFAULT_ENTRYPOINT_TYPE = "http-proxy";

    List<Listener> convert(XGraviteeIODefinition xGraviteeIODefinition, String apiName, String defaultEndpoint) {
        HttpListener.HttpListenerBuilder listener = (HttpListener.HttpListenerBuilder)HttpListener.builder().entrypoints(Collections.singletonList(Entrypoint.builder().type(DEFAULT_ENTRYPOINT_TYPE).build()));
        List paths = Optional.ofNullable(xGraviteeIODefinition).map(XGraviteeIODefinition::getVirtualHosts).map(this::createPathsFromVirtualHosts).orElseGet(() -> Collections.singletonList(this.createDefaultPath(apiName, defaultEndpoint)));
        return Collections.singletonList(listener.paths(paths).build());
    }

    private List<Path> createPathsFromVirtualHosts(List<VirtualHost> virtualHosts) {
        return virtualHosts.stream().map(vHost -> Path.builder().host(vHost.getHost()).path(vHost.getPath()).overrideAccess(vHost.getOverrideEntrypoint() != null ? vHost.getOverrideEntrypoint() : false).build()).collect(Collectors.toList());
    }

    private Path createDefaultPath(String apiName, String defaultEndpoint) {
        String contextPath = null;
        if (defaultEndpoint != null) {
            contextPath = URI.create(defaultEndpoint).getPath();
        }
        if (contextPath == null || contextPath.isEmpty() || contextPath.equals("/")) {
            contextPath = apiName.replaceAll("\\s+", "").toLowerCase();
        }
        return new Path(contextPath);
    }

    @Generated
    public OAIToListenersConverter() {
    }
}

