/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.apim.core.api.use_case;

import io.gravitee.apim.core.UseCase;
import io.gravitee.apim.core.api.domain_service.VerifyApiPathDomainService;
import io.gravitee.apim.core.api.exception.InvalidPathsException;
import io.gravitee.apim.core.api.model.Path;
import io.gravitee.apim.core.validation.Validator;
import io.gravitee.rest.api.service.common.GraviteeContext;
import java.util.List;

@UseCase
public class VerifyApiPathsUseCase {
    private final VerifyApiPathDomainService verifyApiPathDomainService;

    public VerifyApiPathsUseCase(VerifyApiPathDomainService verifyApiPathDomainService) {
        this.verifyApiPathDomainService = verifyApiPathDomainService;
    }

    public Response execute(Request request) throws InvalidPathsException {
        Validator.Result<VerifyApiPathDomainService.Input> validationResult = this.verifyApiPathDomainService.validateAndSanitize(new VerifyApiPathDomainService.Input(GraviteeContext.getExecutionContext().getEnvironmentId(), request.apiId, request.paths));
        validationResult.severe().ifPresent(errors -> {
            throw new InvalidPathsException(((Validator.Error)errors.iterator().next()).getMessage());
        });
        return validationResult.value().map(sanitized -> new Response(sanitized.paths())).orElseGet(() -> new Response(List.of()));
    }

    public record Request(String apiId, List<Path> paths) {
    }

    public record Response(List<Path> paths) {
    }
}

