/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.rest.api.service.impl.configuration.application.registration.client;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ObjectNode;
import io.gravitee.common.http.HttpMethod;
import io.gravitee.rest.api.service.impl.configuration.application.registration.client.DynamicClientRegistrationException;
import io.gravitee.rest.api.service.impl.configuration.application.registration.client.register.ClientRegistrationRequest;
import io.gravitee.rest.api.service.impl.configuration.application.registration.client.register.ClientRegistrationResponse;
import java.io.IOException;
import java.nio.charset.Charset;
import lombok.Generated;
import org.apache.http.HttpEntity;
import org.apache.http.client.methods.HttpPatch;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpPut;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.ContentType;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.util.EntityUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class DynamicClientRegistrationProviderClient {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(DynamicClientRegistrationProviderClient.class);
    protected final ObjectMapper mapper = new ObjectMapper();
    protected CloseableHttpClient httpClient;
    protected String registrationEndpoint;

    protected ClientRegistrationResponse register(String initialAccessToken, ClientRegistrationRequest request) {
        HttpPost registerRequest = new HttpPost(this.registrationEndpoint);
        registerRequest.setHeader("Authorization", "Bearer " + initialAccessToken);
        registerRequest.setHeader("Accept", "application/json");
        try {
            registerRequest.setEntity((HttpEntity)new StringEntity(this.mapper.writeValueAsString((Object)request), ContentType.create((String)"application/json", (Charset)Charset.defaultCharset())));
            return (ClientRegistrationResponse)this.httpClient.execute((HttpUriRequest)registerRequest, response -> {
                int status = response.getStatusLine().getStatusCode();
                if (status >= 200 && status < 300) {
                    HttpEntity entity = response.getEntity();
                    return this.buildClientRegistrationResponse(entity, request.getApplicationType());
                }
                String responsePayload = EntityUtils.toString((HttpEntity)response.getEntity());
                if (responsePayload != null && !responsePayload.isEmpty()) {
                    try {
                        JsonNode node = this.mapper.readTree(responsePayload);
                        String error = node.path("error").asText();
                        String description = node.path("error_description").asText();
                        throw new DynamicClientRegistrationException(String.format("Unexpected response from OIDC Registration endpoint: error[%s] description[%s]", error, description));
                    }
                    catch (JsonProcessingException ex) {
                        throw new DynamicClientRegistrationException(String.format("Unexpected response from OIDC Registration endpoint: status[%s] message[%s]", status, responsePayload));
                    }
                }
                throw new DynamicClientRegistrationException(String.format("Unexpected response from OIDC Registration endpoint: status[%s]", status));
            });
        }
        catch (Exception ex) {
            throw new DynamicClientRegistrationException(String.format("Unexpected error while registering client: %s", ex.getMessage()), ex);
        }
    }

    public ClientRegistrationResponse update(String registrationAccessToken, String registrationClientUri, ClientRegistrationRequest request, String clientId) {
        HttpPut updateRequest = new HttpPut(registrationClientUri);
        updateRequest.setHeader("Authorization", "Bearer " + registrationAccessToken);
        updateRequest.setHeader("Accept", "application/json");
        try {
            JsonNode reqNode = this.mapper.readTree(this.mapper.writeValueAsString((Object)request));
            ((ObjectNode)reqNode).put("client_id", clientId);
            if (request.getScope() != null && !request.getScope().isEmpty()) {
                ((ObjectNode)reqNode).put("scope", String.join((CharSequence)" ", request.getScope()));
            } else {
                ((ObjectNode)reqNode).remove("scope");
            }
            updateRequest.setEntity((HttpEntity)new StringEntity(this.mapper.writeValueAsString((Object)reqNode), ContentType.create((String)"application/json", (Charset)Charset.defaultCharset())));
            return (ClientRegistrationResponse)this.httpClient.execute((HttpUriRequest)updateRequest, response -> {
                int status = response.getStatusLine().getStatusCode();
                if (status >= 200 && status < 300) {
                    HttpEntity entity = response.getEntity();
                    return this.buildClientRegistrationResponse(entity, request.getApplicationType());
                }
                String responsePayload = EntityUtils.toString((HttpEntity)response.getEntity());
                if (responsePayload != null && !responsePayload.isEmpty()) {
                    try {
                        JsonNode node = this.mapper.readTree(responsePayload);
                        String error = node.path("error").asText();
                        String description = node.path("error_description").asText();
                        throw new DynamicClientRegistrationException(String.format("Unexpected response from OIDC Registration endpoint: error[%s] description[%s]", error, description));
                    }
                    catch (JsonProcessingException ex) {
                        throw new DynamicClientRegistrationException(String.format("Unexpected response from OIDC Registration endpoint: status[%s] message[%s]", status, responsePayload));
                    }
                }
                throw new DynamicClientRegistrationException(String.format("Unexpected response from OIDC Registration endpoint: status[%s]", status));
            });
        }
        catch (Exception ex) {
            throw new DynamicClientRegistrationException(String.format("Unexpected error while registering client: %s", ex.getMessage()), ex);
        }
    }

    public ClientRegistrationResponse renewClientSecret(String method, String endpoint, String registrationAccessToken, String applicationType) {
        HttpPost renewRequest;
        if (method.equalsIgnoreCase(HttpMethod.POST.name())) {
            renewRequest = new HttpPost(endpoint);
        } else if (method.equalsIgnoreCase(HttpMethod.PUT.name())) {
            renewRequest = new HttpPut(endpoint);
        } else if (method.equalsIgnoreCase(HttpMethod.PATCH.name())) {
            renewRequest = new HttpPatch(endpoint);
        } else {
            throw new DynamicClientRegistrationException("Client registration does not use valid method");
        }
        renewRequest.setHeader("Authorization", "Bearer " + registrationAccessToken);
        renewRequest.setHeader("Accept", "application/json");
        try {
            return (ClientRegistrationResponse)this.httpClient.execute((HttpUriRequest)renewRequest, response -> {
                int status = response.getStatusLine().getStatusCode();
                if (status >= 200 && status < 300) {
                    HttpEntity entity = response.getEntity();
                    return this.buildClientRegistrationResponse(entity, applicationType);
                }
                String responsePayload = EntityUtils.toString((HttpEntity)response.getEntity());
                if (responsePayload != null && !responsePayload.isEmpty()) {
                    try {
                        JsonNode node = this.mapper.readTree(responsePayload);
                        String error = node.path("error").asText();
                        String description = node.path("error_description").asText();
                        throw new DynamicClientRegistrationException(String.format("Unexpected response from renew client secret endpoint: error[%s] description[%s]", error, description));
                    }
                    catch (JsonProcessingException ex) {
                        throw new DynamicClientRegistrationException(String.format("Unexpected response from new client secret endpoint: status[%s] message[%s]", status, responsePayload));
                    }
                }
                throw new DynamicClientRegistrationException(String.format("Unexpected response from renew client secret endpoint: status[%s]", status));
            });
        }
        catch (Exception ex) {
            throw new DynamicClientRegistrationException(String.format("Unexpected error while renewing client secret: %s", ex.getMessage()), ex);
        }
    }

    public ClientRegistrationResponse register(ClientRegistrationRequest request) {
        log.debug("Generate an access_token");
        String accessToken = this.getInitialAccessToken();
        log.debug("Register the client");
        return this.register(accessToken, request);
    }

    public abstract String getInitialAccessToken();

    private ClientRegistrationResponse buildClientRegistrationResponse(HttpEntity entity, String applicationType) throws IOException {
        if (entity != null) {
            ClientRegistrationResponse clientRegistrationResponse = (ClientRegistrationResponse)this.mapper.readValue(EntityUtils.toString((HttpEntity)entity), ClientRegistrationResponse.class);
            if (clientRegistrationResponse.getApplicationType() == null) {
                clientRegistrationResponse.setApplicationType(applicationType);
            }
            return clientRegistrationResponse;
        }
        throw new DynamicClientRegistrationException("Client registration response does not contain any body");
    }
}

