/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.rest.api.service.impl;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import io.gravitee.repository.exceptions.TechnicalException;
import io.gravitee.repository.management.api.search.MediaCriteria;
import io.gravitee.repository.media.api.MediaRepository;
import io.gravitee.repository.media.model.Media;
import io.gravitee.rest.api.model.MediaEntity;
import io.gravitee.rest.api.model.PageMediaEntity;
import io.gravitee.rest.api.service.ConfigService;
import io.gravitee.rest.api.service.MediaService;
import io.gravitee.rest.api.service.common.ExecutionContext;
import io.gravitee.rest.api.service.common.UuidString;
import io.gravitee.rest.api.service.exceptions.ApiMediaNotFoundException;
import io.gravitee.rest.api.service.exceptions.TechnicalManagementException;
import io.gravitee.rest.api.service.impl.AbstractService;
import jakarta.xml.bind.DatatypeConverter;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Component;

@Component
public class MediaServiceImpl
extends AbstractService
implements MediaService {
    private static final String MEDIA_TYPE_IMAGE = "image";
    private final MediaRepository mediaRepository;
    private final ConfigService configService;
    private final ObjectMapper objectMapper;

    public MediaServiceImpl(@Lazy MediaRepository mediaRepository, ConfigService configService, ObjectMapper objectMapper) {
        this.mediaRepository = mediaRepository;
        this.configService = configService;
        this.objectMapper = objectMapper;
    }

    @Override
    public String savePortalMedia(ExecutionContext executionContext, MediaEntity mediaEntity) {
        return this.saveApiMedia(executionContext, null, mediaEntity);
    }

    @Override
    public String saveApiMedia(ExecutionContext context, String api, MediaEntity mediaEntity) {
        try {
            MessageDigest digest = MessageDigest.getInstance("MD5");
            byte[] hash = digest.digest(mediaEntity.getData());
            String hashString = DatatypeConverter.printHexBinary((byte[])hash);
            String id = mediaEntity.getId() != null ? mediaEntity.getId() : UuidString.generateRandom();
            Optional checkMedia = this.mediaRepository.findByHash(hashString, MediaCriteria.builder().organization(context.getOrganizationId()).environment(context.getEnvironmentId()).api(api).mediaType(mediaEntity.getType()).build());
            if (checkMedia.isPresent()) {
                return ((Media)checkMedia.get()).getHash();
            }
            Media media = MediaServiceImpl.convert(mediaEntity);
            media.setId(id);
            media.setHash(hashString);
            media.setSize(Long.valueOf(mediaEntity.getData().length));
            media.setApi(api);
            media.setData(mediaEntity.getData());
            media.setEnvironment(context.getEnvironmentId());
            media.setOrganization(context.getOrganizationId());
            this.mediaRepository.create(media);
            return hashString;
        }
        catch (TechnicalException | NoSuchAlgorithmException ex) {
            throw new TechnicalManagementException(String.format("An error occurs while trying to create media: %s", mediaEntity), ex);
        }
    }

    @Override
    public MediaEntity findByHash(ExecutionContext context, String hash) {
        try {
            return this.mediaRepository.findByHash(hash, MediaCriteria.builder().organization(context.getOrganizationId()).environment(context.getEnvironmentId()).mediaType(MEDIA_TYPE_IMAGE).build()).map(MediaServiceImpl::convert).orElse(null);
        }
        catch (TechnicalException e) {
            throw new TechnicalManagementException(String.format("An error has occurred trying to find media with hash %s", hash), e);
        }
    }

    @Override
    public MediaEntity findByHashAndApiId(String hash, String apiId) {
        try {
            return this.mediaRepository.findByHash(hash, MediaCriteria.builder().api(apiId).mediaType(MEDIA_TYPE_IMAGE).build()).map(MediaServiceImpl::convert).orElse(null);
        }
        catch (TechnicalException e) {
            throw new TechnicalManagementException(String.format("An error as occurred trying to find media for API %s with hash %s", apiId, hash), e);
        }
    }

    @Override
    public MediaEntity findByHash(ExecutionContext context, String hash, boolean ignoreType) {
        try {
            return this.mediaRepository.findByHash(hash, MediaCriteria.builder().organization(context.getOrganizationId()).environment(context.getEnvironmentId()).mediaType(ignoreType ? null : MEDIA_TYPE_IMAGE).build()).map(MediaServiceImpl::convert).orElse(null);
        }
        catch (TechnicalException e) {
            throw new TechnicalManagementException(String.format("An error as occurred trying to find media with hash %s", hash), e);
        }
    }

    @Override
    public MediaEntity findByHashAndApi(String hash, String api, boolean ignoreType) {
        try {
            return this.mediaRepository.findByHash(hash, MediaCriteria.builder().api(api).mediaType(ignoreType ? null : MEDIA_TYPE_IMAGE).build()).map(MediaServiceImpl::convert).orElse(null);
        }
        catch (TechnicalException e) {
            throw new TechnicalManagementException(String.format("An error as occurred trying to find media for API %s with hash %s", api, hash), e);
        }
    }

    @Override
    public List<MediaEntity> findAllWithoutContent(ExecutionContext context, List<PageMediaEntity> pageMediaEntities) {
        return this.findAllWithoutContent(pageMediaEntities, MediaCriteria.builder().organization(context.getOrganizationId()).environment(context.getEnvironmentId()).build());
    }

    @Override
    public List<MediaEntity> findAllWithoutContent(List<PageMediaEntity> pageMediaEntities, String api) {
        return this.findAllWithoutContent(pageMediaEntities, MediaCriteria.builder().api(api).build());
    }

    private List<MediaEntity> findAllWithoutContent(List<PageMediaEntity> pageMediaEntities, MediaCriteria mediaCriteria) {
        try {
            ArrayList<MediaEntity> result = new ArrayList<MediaEntity>();
            if (pageMediaEntities != null && !pageMediaEntities.isEmpty()) {
                for (PageMediaEntity pme : pageMediaEntities) {
                    Optional foundMedia = this.mediaRepository.findByHash(pme.getMediaHash(), mediaCriteria, false);
                    if (!foundMedia.isPresent()) continue;
                    MediaEntity me = MediaServiceImpl.convert((Media)foundMedia.get());
                    me.setFileName(pme.getMediaName());
                    me.setUploadDate(pme.getAttachedAt());
                    result.add(me);
                }
            }
            return result;
        }
        catch (TechnicalException e) {
            throw new TechnicalManagementException(String.format("An error as occurred trying to find medias with criteria %s", mediaCriteria), e);
        }
    }

    @Override
    public Long getMediaMaxSize(ExecutionContext executionContext) {
        return (long)this.configService.getPortalSettings(executionContext).getPortal().getUploadMedia().getMaxSizeInOctet();
    }

    @Override
    public List<MediaEntity> findAllByApiId(String apiId) {
        try {
            return this.mediaRepository.findAllByApi(apiId).stream().map(MediaServiceImpl::convert).toList();
        }
        catch (TechnicalException e) {
            throw new TechnicalManagementException(String.format("An error as occurred trying to find medias for API %s", apiId), e);
        }
    }

    @Override
    public String createWithDefinition(ExecutionContext executionContext, String api, String mediaDefinition) {
        try {
            MediaEntity media = this.convertToEntity(mediaDefinition);
            return this.saveApiMedia(executionContext, api, media);
        }
        catch (JsonProcessingException e) {
            throw new TechnicalManagementException(String.format("An error has occurred during media creation while trying to JSON deserialize the media %s", mediaDefinition), e);
        }
    }

    @Override
    public void deleteAllByApi(String apiId) {
        try {
            this.mediaRepository.deleteAllByApi(apiId);
        }
        catch (TechnicalException e) {
            throw new TechnicalManagementException(String.format("An error has occurred while trying to delete medias for API %s", apiId), e);
        }
    }

    @Override
    public void deleteByHashAndApi(String hash, String apiId) {
        try {
            MediaCriteria mediaCriteria = MediaCriteria.builder().api(apiId).build();
            Media media = (Media)this.mediaRepository.findByHash(hash, mediaCriteria).orElseThrow(() -> new ApiMediaNotFoundException(hash, apiId));
            this.mediaRepository.deleteByHashAndApi(media.getHash(), apiId);
        }
        catch (TechnicalException e) {
            throw new TechnicalManagementException(String.format("An error has occurred trying to delete media for API %s with hash %s", apiId, hash), e);
        }
    }

    private MediaEntity convertToEntity(String mediaDefinition) throws JsonProcessingException {
        return (MediaEntity)this.objectMapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false).readValue(mediaDefinition, MediaEntity.class);
    }

    private static Media convert(MediaEntity imageEntity) {
        Media media = new Media();
        media.setFileName(imageEntity.getFileName());
        media.setSize(Long.valueOf(imageEntity.getSize()));
        media.setType(imageEntity.getType());
        media.setSubType(imageEntity.getSubType());
        media.setId(imageEntity.getId());
        return media;
    }

    private static MediaEntity convert(Media media) {
        MediaEntity mediaEntity = new MediaEntity();
        mediaEntity.setId(media.getId());
        mediaEntity.setData(media.getData());
        mediaEntity.setType(media.getType());
        mediaEntity.setSubType(media.getSubType());
        mediaEntity.setFileName(media.getFileName());
        mediaEntity.setSize(media.getSize().longValue());
        mediaEntity.setUploadDate(media.getCreatedAt());
        mediaEntity.setHash(media.getHash());
        return mediaEntity;
    }
}

