/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.apim.infra.crud_service.documentation;

import io.gravitee.apim.core.documentation.crud_service.PageRevisionCrudService;
import io.gravitee.apim.core.documentation.model.Page;
import io.gravitee.apim.core.exception.TechnicalDomainException;
import io.gravitee.apim.infra.adapter.PageAdapter;
import io.gravitee.repository.exceptions.TechnicalException;
import io.gravitee.repository.management.api.PageRevisionRepository;
import io.gravitee.repository.management.model.PageRevision;
import io.gravitee.rest.api.service.exceptions.TechnicalManagementException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Optional;
import lombok.Generated;
import org.apache.commons.codec.binary.Hex;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Service;

@Service
public class PageRevisionCrudServiceImpl
implements PageRevisionCrudService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(PageRevisionCrudServiceImpl.class);
    private final PageRevisionRepository pageRevisionRepository;

    public PageRevisionCrudServiceImpl(@Lazy PageRevisionRepository pageRevisionRepository) {
        this.pageRevisionRepository = pageRevisionRepository;
    }

    @Override
    public io.gravitee.apim.core.documentation.model.PageRevision create(Page page) {
        io.gravitee.apim.core.documentation.model.PageRevision pageRevisionToCreate = PageAdapter.INSTANCE.toPageRevision(page);
        this.computeHash(pageRevisionToCreate);
        try {
            Optional lastPageRevision = this.pageRevisionRepository.findLastByPageId(page.getId());
            pageRevisionToCreate.setRevision(lastPageRevision.map(rev -> rev.getRevision() + 1).orElse(1));
            PageRevision createdPageRevision = this.pageRevisionRepository.create(PageAdapter.INSTANCE.toPageRevisionRepository(pageRevisionToCreate));
            return PageAdapter.INSTANCE.toEntity(createdPageRevision);
        }
        catch (TechnicalException e) {
            throw new TechnicalDomainException(String.format("An error occurred while creating PageRevision for page %s", page), e);
        }
    }

    public void computeHash(io.gravitee.apim.core.documentation.model.PageRevision pageRevision) {
        try {
            String canonicalRevision = this.canonicalRevision(pageRevision);
            MessageDigest md = MessageDigest.getInstance("sha-256");
            md.update(canonicalRevision.getBytes());
            byte[] digest = md.digest();
            pageRevision.setHash(Hex.encodeHexString((byte[])digest));
        }
        catch (NoSuchAlgorithmException e) {
            throw new TechnicalManagementException(String.format("Unable to instantiate MessageDigest for page %s", pageRevision), e);
        }
    }

    private String canonicalRevision(io.gravitee.apim.core.documentation.model.PageRevision pageRevision) {
        StringBuilder builder = new StringBuilder();
        builder.append(Optional.ofNullable(pageRevision.getName()).map(c -> c.trim()).orElse(""));
        builder.append('\n');
        builder.append(Optional.ofNullable(pageRevision.getContent()).map(c -> c.trim()).orElse(""));
        builder.append('\n');
        builder.append(pageRevision.getContributor());
        builder.append('\n');
        builder.append(pageRevision.getModificationDate().getTime());
        builder.append('\n');
        return builder.toString();
    }
}

