/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.apim.core.plan.domain_service;

import io.gravitee.apim.core.DomainService;
import io.gravitee.apim.core.audit.domain_service.AuditDomainService;
import io.gravitee.apim.core.audit.model.ApiAuditLogEntity;
import io.gravitee.apim.core.audit.model.AuditInfo;
import io.gravitee.apim.core.audit.model.AuditProperties;
import io.gravitee.apim.core.audit.model.event.PlanAuditEvent;
import io.gravitee.apim.core.exception.ValidationDomainException;
import io.gravitee.apim.core.plan.crud_service.PlanCrudService;
import io.gravitee.apim.core.plan.model.Plan;
import io.gravitee.apim.core.subscription.query_service.SubscriptionQueryService;
import io.gravitee.common.utils.TimeProvider;
import java.util.Map;

@DomainService
public class ClosePlanDomainService {
    private final PlanCrudService planCrudService;
    private final SubscriptionQueryService subscriptionQueryService;
    private final AuditDomainService auditService;

    public ClosePlanDomainService(PlanCrudService planCrudService, SubscriptionQueryService subscriptionQueryService, AuditDomainService auditService) {
        this.planCrudService = planCrudService;
        this.subscriptionQueryService = subscriptionQueryService;
        this.auditService = auditService;
    }

    public void close(String planId, AuditInfo auditInfo) {
        if (!this.subscriptionQueryService.findActiveSubscriptionsByPlan(planId).isEmpty()) {
            throw new ValidationDomainException("Impossible to close a plan with active subscriptions");
        }
        Plan planToClose = this.planCrudService.getById(planId);
        Plan closedPlan = planToClose.close();
        Plan planUpdated = this.planCrudService.update(closedPlan);
        this.createAuditLog(closedPlan, planUpdated, auditInfo);
    }

    private void createAuditLog(Plan planToClose, Plan planUpdated, AuditInfo auditInfo) {
        this.auditService.createApiAuditLog(ApiAuditLogEntity.builder().organizationId(auditInfo.organizationId()).environmentId(auditInfo.environmentId()).apiId(planToClose.getApiId()).event(PlanAuditEvent.PLAN_CLOSED).actor(auditInfo.actor()).oldValue(planToClose).newValue(planUpdated).createdAt(TimeProvider.now()).properties(Map.of(AuditProperties.PLAN, planToClose.getId())).build());
    }
}

