/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.apim.core.api.domain_service;

import io.gravitee.apim.core.DomainService;
import io.gravitee.apim.core.api.crud_service.ApiCrudService;
import io.gravitee.apim.core.api.domain_service.ApiIndexerDomainService;
import io.gravitee.apim.core.api.domain_service.CategoryDomainService;
import io.gravitee.apim.core.api.domain_service.ValidateFederatedApiDomainService;
import io.gravitee.apim.core.api.model.Api;
import io.gravitee.apim.core.audit.domain_service.AuditDomainService;
import io.gravitee.apim.core.audit.model.ApiAuditLogEntity;
import io.gravitee.apim.core.audit.model.AuditInfo;
import io.gravitee.apim.core.audit.model.event.ApiAuditEvent;
import io.gravitee.apim.core.membership.model.PrimaryOwnerEntity;
import io.gravitee.apim.core.search.Indexer;
import io.gravitee.common.utils.TimeProvider;
import java.util.Collections;
import java.util.function.UnaryOperator;
import lombok.Generated;

@DomainService
public class UpdateFederatedApiDomainService {
    private final ApiCrudService apiCrudService;
    private final AuditDomainService auditService;
    private final ValidateFederatedApiDomainService validateFederatedApiDomainService;
    private final CategoryDomainService categoryDomainService;
    private final ApiIndexerDomainService apiIndexerDomainService;

    public Api update(String apiId, UnaryOperator<Api> updater, AuditInfo auditInfo, PrimaryOwnerEntity primaryOwnerEntity) {
        Api currentApi = this.apiCrudService.get(apiId);
        Api federatedApi = (Api)updater.apply(currentApi);
        Api preparedApi = this.validateFederatedApiDomainService.validateAndSanitizeForUpdate(federatedApi, currentApi, primaryOwnerEntity);
        preparedApi.setUpdatedAt(TimeProvider.now());
        Api updated = this.apiCrudService.update(preparedApi);
        this.createAuditLog(auditInfo, preparedApi, currentApi);
        this.createIndex(auditInfo, preparedApi, primaryOwnerEntity);
        this.categoryDomainService.updateOrderCategoriesOfApi(updated.getId(), updated.getCategories());
        updated.setCategories(this.categoryDomainService.toCategoryKey(updated, updated.getEnvironmentId()));
        return updated;
    }

    private void createAuditLog(AuditInfo auditInfo, Api updatedApi, Api currentApi) {
        this.auditService.createApiAuditLog(ApiAuditLogEntity.builder().organizationId(auditInfo.organizationId()).environmentId(auditInfo.environmentId()).apiId(updatedApi.getId()).event(ApiAuditEvent.API_UPDATED).actor(auditInfo.actor()).oldValue(currentApi).newValue(updatedApi).createdAt(updatedApi.getUpdatedAt()).properties(Collections.emptyMap()).build());
    }

    private void createIndex(AuditInfo auditInfo, Api updateApi, PrimaryOwnerEntity primaryOwnerEntity) {
        this.apiIndexerDomainService.index(new Indexer.IndexationContext(auditInfo.organizationId(), auditInfo.environmentId()), updateApi, primaryOwnerEntity);
    }

    @Generated
    public UpdateFederatedApiDomainService(ApiCrudService apiCrudService, AuditDomainService auditService, ValidateFederatedApiDomainService validateFederatedApiDomainService, CategoryDomainService categoryDomainService, ApiIndexerDomainService apiIndexerDomainService) {
        this.apiCrudService = apiCrudService;
        this.auditService = auditService;
        this.validateFederatedApiDomainService = validateFederatedApiDomainService;
        this.categoryDomainService = categoryDomainService;
        this.apiIndexerDomainService = apiIndexerDomainService;
    }
}

