/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.rest.api.service.impl;

import io.gravitee.repository.exceptions.TechnicalException;
import io.gravitee.repository.management.api.ApiQualityRuleRepository;
import io.gravitee.repository.management.model.ApiQualityRule;
import io.gravitee.repository.management.model.Audit;
import io.gravitee.rest.api.model.quality.ApiQualityRuleEntity;
import io.gravitee.rest.api.model.quality.NewApiQualityRuleEntity;
import io.gravitee.rest.api.model.quality.UpdateApiQualityRuleEntity;
import io.gravitee.rest.api.service.ApiQualityRuleService;
import io.gravitee.rest.api.service.AuditService;
import io.gravitee.rest.api.service.common.ExecutionContext;
import io.gravitee.rest.api.service.exceptions.ApiQualityRuleAlreadyExistsException;
import io.gravitee.rest.api.service.exceptions.ApiQualityRuleNotFoundException;
import io.gravitee.rest.api.service.exceptions.TechnicalManagementException;
import io.gravitee.rest.api.service.impl.AbstractService;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Component;

@Component
public class ApiQualityRuleServiceImpl
extends AbstractService
implements ApiQualityRuleService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ApiQualityRuleServiceImpl.class);
    @Lazy
    @Autowired
    private ApiQualityRuleRepository apiQualityRuleRepository;
    @Autowired
    private AuditService auditService;

    @Override
    public List<ApiQualityRuleEntity> findByApi(String api) {
        try {
            log.debug("Find quality rules by API {}", (Object)api);
            return this.apiQualityRuleRepository.findByApi(api).stream().map(this::convert).collect(Collectors.toList());
        }
        catch (TechnicalException ex) {
            throw new TechnicalManagementException(String.format("An error occurs while trying to find quality rules by API %s", api), ex);
        }
    }

    @Override
    public ApiQualityRuleEntity create(ExecutionContext executionContext, NewApiQualityRuleEntity newEntity) {
        try {
            Optional optionalApiQualityRule = this.apiQualityRuleRepository.findById(newEntity.getApi(), newEntity.getQualityRule());
            if (optionalApiQualityRule.isPresent()) {
                throw new ApiQualityRuleAlreadyExistsException(newEntity.getApi(), newEntity.getQualityRule());
            }
            ApiQualityRule apiQualityRule = this.convert(newEntity);
            this.auditService.createAuditLog(executionContext, Collections.singletonMap(Audit.AuditProperties.API_QUALITY_RULE, apiQualityRule.getApi()), (Audit.AuditEvent)ApiQualityRule.AuditEvent.API_QUALITY_RULE_CREATED, apiQualityRule.getCreatedAt(), null, apiQualityRule);
            return this.convert(this.apiQualityRuleRepository.create(apiQualityRule));
        }
        catch (TechnicalException e) {
            throw new TechnicalManagementException(String.format("An error occurs while trying to create an API quality rule %s", newEntity), e);
        }
    }

    @Override
    public ApiQualityRuleEntity update(ExecutionContext executionContext, UpdateApiQualityRuleEntity updateEntity) {
        try {
            Optional optionalApiQualityRule = this.apiQualityRuleRepository.findById(updateEntity.getApi(), updateEntity.getQualityRule());
            if (optionalApiQualityRule.isEmpty()) {
                throw new ApiQualityRuleNotFoundException(updateEntity.getApi(), updateEntity.getQualityRule());
            }
            ApiQualityRule apiQualityRule = this.apiQualityRuleRepository.update(this.convert(updateEntity));
            this.auditService.createAuditLog(executionContext, Collections.singletonMap(Audit.AuditProperties.API_QUALITY_RULE, apiQualityRule.getApi()), (Audit.AuditEvent)ApiQualityRule.AuditEvent.API_QUALITY_RULE_UPDATED, apiQualityRule.getUpdatedAt(), optionalApiQualityRule.get(), apiQualityRule);
            return this.convert(apiQualityRule);
        }
        catch (TechnicalException e) {
            throw new TechnicalManagementException(String.format("An error occurs while trying to update API quality rule %s", updateEntity), e);
        }
    }

    private ApiQualityRuleEntity convert(ApiQualityRule apiQualityRule) {
        ApiQualityRuleEntity entity = new ApiQualityRuleEntity();
        entity.setApi(apiQualityRule.getApi());
        entity.setQualityRule(apiQualityRule.getQualityRule());
        entity.setChecked(apiQualityRule.isChecked());
        entity.setCreatedAt(apiQualityRule.getCreatedAt());
        entity.setUpdatedAt(apiQualityRule.getUpdatedAt());
        return entity;
    }

    private ApiQualityRule convert(NewApiQualityRuleEntity apiQualityRuleEntity) {
        ApiQualityRule apiQualityRule = new ApiQualityRule();
        apiQualityRule.setApi(apiQualityRuleEntity.getApi());
        apiQualityRule.setQualityRule(apiQualityRuleEntity.getQualityRule());
        apiQualityRule.setChecked(apiQualityRuleEntity.isChecked());
        Date now = new Date();
        apiQualityRule.setCreatedAt(now);
        apiQualityRule.setUpdatedAt(now);
        return apiQualityRule;
    }

    private ApiQualityRule convert(UpdateApiQualityRuleEntity apiQualityRuleEntity) {
        ApiQualityRule apiQualityRule = new ApiQualityRule();
        apiQualityRule.setApi(apiQualityRuleEntity.getApi());
        apiQualityRule.setQualityRule(apiQualityRuleEntity.getQualityRule());
        apiQualityRule.setChecked(apiQualityRuleEntity.isChecked());
        Date now = new Date();
        apiQualityRule.setCreatedAt(now);
        apiQualityRule.setUpdatedAt(now);
        return apiQualityRule;
    }
}

