/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.apim.core.integration.use_case;

import io.gravitee.apim.core.UseCase;
import io.gravitee.apim.core.api.crud_service.ApiCrudService;
import io.gravitee.apim.core.api.domain_service.ApiIndexerDomainService;
import io.gravitee.apim.core.api.domain_service.ApiMetadataDomainService;
import io.gravitee.apim.core.api.model.Api;
import io.gravitee.apim.core.api.model.ApiFieldFilter;
import io.gravitee.apim.core.api.model.ApiSearchCriteria;
import io.gravitee.apim.core.api.query_service.ApiQueryService;
import io.gravitee.apim.core.audit.domain_service.AuditDomainService;
import io.gravitee.apim.core.audit.model.ApiAuditLogEntity;
import io.gravitee.apim.core.audit.model.AuditInfo;
import io.gravitee.apim.core.audit.model.event.ApiAuditEvent;
import io.gravitee.apim.core.documentation.domain_service.DeleteApiDocumentationDomainService;
import io.gravitee.apim.core.documentation.query_service.PageQueryService;
import io.gravitee.apim.core.membership.domain_service.DeleteMembershipDomainService;
import io.gravitee.apim.core.plan.domain_service.DeletePlanDomainService;
import io.gravitee.apim.core.plan.model.Plan;
import io.gravitee.apim.core.plan.query_service.PlanQueryService;
import io.gravitee.apim.core.search.Indexer;
import io.gravitee.apim.core.subscription.domain_service.CloseSubscriptionDomainService;
import io.gravitee.apim.core.subscription.domain_service.DeleteSubscriptionDomainService;
import io.gravitee.apim.core.subscription.model.SubscriptionEntity;
import io.gravitee.apim.core.subscription.query_service.SubscriptionQueryService;
import io.gravitee.common.utils.TimeProvider;
import io.reactivex.rxjava3.core.Flowable;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@UseCase
public class DeleteIngestedApisUseCase {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(DeleteIngestedApisUseCase.class);
    private final ApiQueryService apiQueryService;
    private final PlanQueryService planQueryService;
    private final SubscriptionQueryService subscriptionQueryService;
    private final CloseSubscriptionDomainService closeSubscriptionDomainService;
    private final DeleteSubscriptionDomainService deleteSubscriptionDomainService;
    private final DeletePlanDomainService deletePlanDomainService;
    private final PageQueryService pageQueryService;
    private final DeleteApiDocumentationDomainService deleteApiDocumentationDomainService;
    private final AuditDomainService auditDomainService;
    private final ApiMetadataDomainService apiMetadataDomainService;
    private final DeleteMembershipDomainService deleteMembershipDomainService;
    private final ApiCrudService apiCrudService;
    private final ApiIndexerDomainService apiIndexerDomainService;

    public Output execute(Input input) {
        AtomicInteger skippedCounter = new AtomicInteger();
        AtomicInteger errorCounter = new AtomicInteger();
        AtomicInteger deletedCounter = new AtomicInteger();
        List<Api> apisToDelete = this.apiQueryService.search(ApiSearchCriteria.builder().integrationId(input.integrationId).build(), null, ApiFieldFilter.builder().pictureExcluded(true).definitionExcluded(true).build()).toList();
        Flowable.fromIterable(apisToDelete).subscribe(api -> {
            if (api.getApiLifecycleState().equals((Object)Api.ApiLifecycleState.PUBLISHED)) {
                skippedCounter.incrementAndGet();
            } else {
                this.delete((Api)api, input.auditInfo);
                deletedCounter.incrementAndGet();
            }
        }, exception -> {
            log.error("Error to delete ingested APi", exception);
            errorCounter.incrementAndGet();
        }).dispose();
        return new Output(deletedCounter.get(), skippedCounter.get(), errorCounter.get());
    }

    private void delete(Api api, AuditInfo auditInfo) {
        String apiId = api.getId();
        this.planQueryService.findAllByApiId(apiId).forEach(plan -> {
            this.subscriptionQueryService.findActiveSubscriptionsByPlan(plan.getId()).forEach(activeSubscription -> this.closeSubscriptionDomainService.closeSubscription(activeSubscription.getId(), auditInfo));
            this.subscriptionQueryService.findSubscriptionsByPlan(plan.getId()).forEach(subscription -> this.deleteSubscriptionDomainService.delete((SubscriptionEntity)subscription, auditInfo));
            this.deletePlanDomainService.delete((Plan)plan, auditInfo);
        });
        this.pageQueryService.searchByApiId(apiId).forEach(page -> this.deleteApiDocumentationDomainService.delete(api, page.getId(), auditInfo));
        this.apiIndexerDomainService.delete(new Indexer.IndexationContext(auditInfo.organizationId(), auditInfo.environmentId()), api);
        this.deleteMembershipDomainService.deleteApiMemberships(apiId, auditInfo);
        this.apiMetadataDomainService.deleteApiMetadata(apiId, auditInfo);
        this.apiCrudService.delete(api.getId());
        this.createAuditLog(auditInfo, api);
    }

    private void createAuditLog(AuditInfo auditInfo, Api api) {
        this.auditDomainService.createApiAuditLog(ApiAuditLogEntity.builder().organizationId(auditInfo.organizationId()).environmentId(auditInfo.environmentId()).apiId(api.getId()).event(ApiAuditEvent.API_DELETED).actor(auditInfo.actor()).oldValue(api).createdAt(TimeProvider.now()).properties(Collections.emptyMap()).build());
    }

    @Generated
    public DeleteIngestedApisUseCase(ApiQueryService apiQueryService, PlanQueryService planQueryService, SubscriptionQueryService subscriptionQueryService, CloseSubscriptionDomainService closeSubscriptionDomainService, DeleteSubscriptionDomainService deleteSubscriptionDomainService, DeletePlanDomainService deletePlanDomainService, PageQueryService pageQueryService, DeleteApiDocumentationDomainService deleteApiDocumentationDomainService, AuditDomainService auditDomainService, ApiMetadataDomainService apiMetadataDomainService, DeleteMembershipDomainService deleteMembershipDomainService, ApiCrudService apiCrudService, ApiIndexerDomainService apiIndexerDomainService) {
        this.apiQueryService = apiQueryService;
        this.planQueryService = planQueryService;
        this.subscriptionQueryService = subscriptionQueryService;
        this.closeSubscriptionDomainService = closeSubscriptionDomainService;
        this.deleteSubscriptionDomainService = deleteSubscriptionDomainService;
        this.deletePlanDomainService = deletePlanDomainService;
        this.pageQueryService = pageQueryService;
        this.deleteApiDocumentationDomainService = deleteApiDocumentationDomainService;
        this.auditDomainService = auditDomainService;
        this.apiMetadataDomainService = apiMetadataDomainService;
        this.deleteMembershipDomainService = deleteMembershipDomainService;
        this.apiCrudService = apiCrudService;
        this.apiIndexerDomainService = apiIndexerDomainService;
    }

    public record Input(String integrationId, AuditInfo auditInfo) {
        @Generated
        public static InputBuilder builder() {
            return new InputBuilder();
        }

        @Generated
        public static class InputBuilder {
            @Generated
            private String integrationId;
            @Generated
            private AuditInfo auditInfo;

            @Generated
            InputBuilder() {
            }

            @Generated
            public InputBuilder integrationId(String integrationId) {
                this.integrationId = integrationId;
                return this;
            }

            @Generated
            public InputBuilder auditInfo(AuditInfo auditInfo) {
                this.auditInfo = auditInfo;
                return this;
            }

            @Generated
            public Input build() {
                return new Input(this.integrationId, this.auditInfo);
            }

            @Generated
            public String toString() {
                return "DeleteIngestedApisUseCase.Input.InputBuilder(integrationId=" + this.integrationId + ", auditInfo=" + this.auditInfo + ")";
            }
        }
    }

    public record Output(int deleted, int skipped, int errors) {
    }
}

