/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.apim.core.theme.use_case;

import io.gravitee.apim.core.UseCase;
import io.gravitee.apim.core.theme.crud_service.ThemeCrudService;
import io.gravitee.apim.core.theme.domain_service.CurrentThemeDomainService;
import io.gravitee.apim.core.theme.domain_service.ThemeDomainService;
import io.gravitee.apim.core.theme.domain_service.ValidateThemeDomainService;
import io.gravitee.apim.core.theme.model.Theme;
import io.gravitee.apim.core.theme.model.UpdateTheme;
import io.gravitee.rest.api.service.common.ExecutionContext;
import lombok.Generated;

@UseCase
public class UpdateThemeUseCase {
    private final ValidateThemeDomainService validateThemeDomainService;
    private final ThemeDomainService themeDomainService;
    private final CurrentThemeDomainService currentThemeDomainService;
    private final ThemeCrudService themeCrudService;

    public Output execute(Input input) {
        UpdateTheme updateTheme = input.updateTheme();
        this.validateThemeDomainService.validateUpdateTheme(input.updateTheme(), input.executionContext());
        Theme existingTheme = this.themeCrudService.get(input.updateTheme().getId());
        Theme updatedTheme = this.themeDomainService.update(updateTheme, existingTheme);
        if (!existingTheme.isEnabled() && updatedTheme.isEnabled()) {
            this.currentThemeDomainService.disablePreviousEnabledTheme(updatedTheme);
        }
        return new Output(updatedTheme);
    }

    @Generated
    public UpdateThemeUseCase(ValidateThemeDomainService validateThemeDomainService, ThemeDomainService themeDomainService, CurrentThemeDomainService currentThemeDomainService, ThemeCrudService themeCrudService) {
        this.validateThemeDomainService = validateThemeDomainService;
        this.themeDomainService = themeDomainService;
        this.currentThemeDomainService = currentThemeDomainService;
        this.themeCrudService = themeCrudService;
    }

    public record Input(UpdateTheme updateTheme, ExecutionContext executionContext) {
        @Generated
        public static InputBuilder builder() {
            return new InputBuilder();
        }

        @Generated
        public static class InputBuilder {
            @Generated
            private UpdateTheme updateTheme;
            @Generated
            private ExecutionContext executionContext;

            @Generated
            InputBuilder() {
            }

            @Generated
            public InputBuilder updateTheme(UpdateTheme updateTheme) {
                this.updateTheme = updateTheme;
                return this;
            }

            @Generated
            public InputBuilder executionContext(ExecutionContext executionContext) {
                this.executionContext = executionContext;
                return this;
            }

            @Generated
            public Input build() {
                return new Input(this.updateTheme, this.executionContext);
            }

            @Generated
            public String toString() {
                return "UpdateThemeUseCase.Input.InputBuilder(updateTheme=" + this.updateTheme + ", executionContext=" + this.executionContext + ")";
            }
        }
    }

    public record Output(Theme result) {
    }
}

